/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.gct;

import java.io.PrintWriter;
import org.broadinstitute.genee.io.util.StringConverter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;

public class GctDatasetWriter13 {
    private StringConverter formatter;

    public GctDatasetWriter13(StringConverter formatter) {
        this.formatter = formatter;
    }

    public void write(Dataset dataset, PrintWriter pw) {
        int i;
        int rows = dataset.getRowCount();
        int ncols = dataset.getColumnCount();
        MetadataModel rowMetadata = GctDatasetWriter13.idFirst(dataset.getRowMetadata());
        MetadataModel columnMetadata = GctDatasetWriter13.idFirst(dataset.getColumnMetadata());
        String version = "#1.3";
        pw.print(version);
        pw.println();
        int rowMetadataCount = rowMetadata.getMetadataCount();
        pw.print(rows + "\t" + ncols + "\t" + (rowMetadataCount - 1) + "\t" + (columnMetadata.getMetadataCount() - 1));
        pw.println();
        for (i = 0; i < rowMetadataCount; ++i) {
            if (i > 0) {
                pw.print("\t");
            }
            String name = rowMetadata.getColumnName(i);
            if (i == 0 && !name.equals(columnMetadata.getColumnName(0))) {
                name = name + "/" + columnMetadata.getColumnName(0);
            }
            pw.print(name);
        }
        for (int j = 0; j < ncols; ++j) {
            pw.print("\t");
            pw.print(this.formatter.toString(columnMetadata.get(0).getValue(j)));
        }
        pw.println();
        int metadataSize = columnMetadata.getMetadataCount();
        for (int columnMetadataIndex = 1; columnMetadataIndex < metadataSize; ++columnMetadataIndex) {
            pw.print(columnMetadata.getColumnName(columnMetadataIndex));
            for (int i2 = 1; i2 < rowMetadataCount; ++i2) {
                pw.print("\t");
                pw.print("na");
            }
            for (int j = 0; j < ncols; ++j) {
                pw.print("\t");
                Object value = columnMetadata.getValue(j, columnMetadataIndex);
                if (value == null) continue;
                pw.print(this.formatter.toString(value));
            }
            pw.println();
        }
        for (i = 0; i < rows; ++i) {
            for (int rowMetadataIndex = 0; rowMetadataIndex < rowMetadataCount; ++rowMetadataIndex) {
                Object value;
                if (rowMetadataIndex > 0) {
                    pw.print("\t");
                }
                if ((value = rowMetadata.getValue(i, rowMetadataIndex)) == null) continue;
                pw.print(this.formatter.toString(value));
            }
            for (int j = 0; j < ncols; ++j) {
                pw.print("\t");
                pw.print(this.formatter.format(dataset.getValue(i, j)));
            }
            pw.println();
        }
    }

    public static MetadataModel idFirst(MetadataModel model) {
        int idIndex = model.getColumnIndex("id");
        if (idIndex > 0) {
            int[] order = new int[model.getMetadataCount()];
            order[0] = idIndex;
            int j = 1;
            int count = model.getMetadataCount();
            for (int i = 0; i < count; ++i) {
                if (i == idIndex) continue;
                order[j++] = i;
            }
            return new MetadataModelColumnView(model, order);
        }
        return model;
    }
}

