/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.geneset;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetMatrixReader;
import org.broadinstitute.genee.io.util.CommentCharReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSet;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetMatrix;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GmtReader
implements GeneSetMatrixReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeneSetMatrix read(String file) throws IOException {
        CommentCharReader br = null;
        try {
            String s;
            br = new CommentCharReader(IOUtil.getBufferedReader(file));
            ArrayList<GeneSet> gsets = new ArrayList<GeneSet>();
            while ((s = ((BufferedReader)br).readLine()) != null) {
                String[] tokens = s.split("\t");
                String name = tokens[0].trim();
                String description = tokens[1].trim();
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                for (int i = 2; i < tokens.length; ++i) {
                    String geneName = tokens[i].trim();
                    if (geneName.equals("")) continue;
                    ids.add(geneName);
                }
                DefaultGeneSet gset = new DefaultGeneSet(name, description, ids);
                gsets.add(gset);
            }
            DefaultGeneSetMatrix defaultGeneSetMatrix = new DefaultGeneSetMatrix(IOUtil.getName(file), gsets);
            return defaultGeneSetMatrix;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

