/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.geneset;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.io.matrix.geneset.GeneSetMatrixReader;
import org.broadinstitute.genee.io.util.CommentCharReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSet;
import org.broadinstitute.genee.matrix.geneset.DefaultGeneSetMatrix;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GmxReader
implements GeneSetMatrixReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeneSetMatrix read(String file) throws IOException {
        CommentCharReader br = null;
        try {
            String s;
            br = new CommentCharReader(IOUtil.getBufferedReader(file));
            String[] gsetNames = ((BufferedReader)br).readLine().split("\t");
            String[] tokens = new String[gsetNames.length];
            IOUtil.split(((BufferedReader)br).readLine(), tokens, '\t');
            String[] namesEnglish = (String[])tokens.clone();
            Set[] members = new Set[gsetNames.length];
            for (int i = 0; i < gsetNames.length; ++i) {
                members[i] = new LinkedHashSet();
            }
            while ((s = ((BufferedReader)br).readLine()) != null) {
                IOUtil.split(s, tokens, '\t');
                for (int i = 0; i < gsetNames.length; ++i) {
                    if (tokens[i].equals("")) continue;
                    members[i].add(tokens[i]);
                }
            }
            ArrayList<GeneSet> gsets = new ArrayList<GeneSet>();
            for (int i = 0; i < members.length; ++i) {
                String gsetName = gsetNames[i];
                gsets.add(new DefaultGeneSet(gsetName, namesEnglish[i], members[i]));
            }
            DefaultGeneSetMatrix defaultGeneSetMatrix = new DefaultGeneSetMatrix(IOUtil.getName(file), gsets);
            return defaultGeneSetMatrix;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

