/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.geneset;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.matrix.geneset.GeneSet;
import org.broadinstitute.genee.matrix.geneset.GeneSetMatrix;

public class GmxWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(GeneSetMatrix matrix, File file) throws IOException {
        PrintWriter pw = null;
        try {
            GeneSet gset;
            int i;
            int nsets = matrix.getNumGeneSets();
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            for (i = 0; i < nsets; ++i) {
                gset = matrix.get(i);
                if (i > 0) {
                    pw.print("\t");
                }
                pw.print(gset.getName());
            }
            pw.println();
            for (i = 0; i < nsets; ++i) {
                gset = matrix.get(i);
                String desc = gset.getDescription();
                if (desc == null) {
                    desc = "";
                }
                if (i > 0) {
                    pw.print("\t");
                }
                pw.print(desc);
            }
            pw.println();
            int maxSize = 0;
            List[] lists = new List[nsets];
            for (int i2 = 0; i2 < nsets; ++i2) {
                GeneSet gset2 = matrix.get(i2);
                maxSize = Math.max(maxSize, gset2.size());
                lists[i2] = new ArrayList<String>(gset2.getMembers());
            }
            for (int index = 0; index < maxSize; ++index) {
                for (int i3 = 0; i3 < nsets; ++i3) {
                    List gset3 = lists[i3];
                    if (i3 > 0) {
                        pw.print("\t");
                    }
                    if (index >= gset3.size()) continue;
                    pw.print((String)gset3.get(index));
                }
                pw.println();
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }
}

