/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.plate;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.io.util.PlateUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class AnalystReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> read(String file) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            Dataset dataset = null;
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            int plateNumber = 1;
            br.readLine();
            do {
                for (int i = 0; i < 5; ++i) {
                    br.readLine();
                }
                dataset = this.readPlate(br);
                if (dataset == null) continue;
                dataset.setName(String.valueOf(plateNumber++));
                dataset.setProperty("File", file);
                datasets.add(dataset);
            } while (dataset != null);
            ArrayList<Dataset> arrayList = datasets;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private Dataset readPlate(BufferedReader br) throws IOException {
        int numTokens;
        String line = br.readLine();
        if (line == null || "".equals(line)) {
            return null;
        }
        String[] tokens = IOUtil.split(line);
        int columns = tokens.length;
        ArrayList<float[]> floatList = new ArrayList<float[]>();
        floatList.add(AnalystReader.toFloat(tokens));
        while ((line = br.readLine()) != null && !"".equals(line) && (numTokens = IOUtil.split(line, tokens, '\t')) == columns) {
            floatList.add(AnalystReader.toFloat(tokens));
        }
        float[][] array = new float[floatList.size()][];
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            array[i] = (float[])floatList.get(i);
        }
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset("", array);
        Vector columnIds = dataset.getColumnMetadata().add("Id", Integer.class);
        for (int i = 0; i < columns; ++i) {
            columnIds.setValue(i, i + 1);
        }
        Vector rowIds = dataset.getColumnMetadata().add("Id", String.class);
        int nrows = array.length;
        for (int i = 0; i < nrows; ++i) {
            rowIds.setValue(i, PlateUtil.convertRowIndexToString(i));
        }
        return dataset;
    }

    public static void main(String[] args) throws IOException {
        AnalystReader reader = new AnalystReader();
        List<Dataset> datasets = reader.read("/Users/jgould/Downloads/rawfilesfromanalyst/022811 MLPCN stauro.txt");
    }

    private static float[] toFloat(String[] tokens) {
        int columns = tokens.length;
        float[] array = new float[columns];
        for (int i = 0; i < columns; ++i) {
            array[i] = ParserHelper.parseFloatNaN(tokens[i]);
        }
        return array;
    }
}

