/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.matrix.plate;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.io.matrix.plate.PlateFileInfo;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;

public class EnvisionFileInfo
implements PlateFileInfo {
    private int columns;
    private TIntArrayList dataLineStarts;
    private String file;
    private List<String> plateNames;
    private int rows;
    private boolean singleTable;
    private boolean tabDelimitted;
    private String barcode;
    private String plateName;
    private List<String> barcodes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvisionFileInfo(String file) throws IOException {
        block19: {
            this.columns = -1;
            this.rows = -1;
            this.singleTable = false;
            this.file = file;
            this.barcodes = new ArrayList<String>();
            LineNumberReader reader = null;
            try {
                String s;
                reader = IOUtil.getLineNumberReader(file);
                this.dataLineStarts = new TIntArrayList();
                this.plateNames = new ArrayList<String>();
                reader.readLine();
                String header = reader.readLine();
                while (header != null) {
                    if (header.indexOf(9) != -1) {
                        this.tabDelimitted = true;
                        break;
                    }
                    if (header.indexOf(44) != -1) {
                        this.tabDelimitted = false;
                        break;
                    }
                    header = reader.readLine();
                }
                if (this.tabDelimitted) {
                    while ((s = reader.readLine()) != null) {
                        String tmp;
                        String[] tokens;
                        if (s.startsWith("Plate information")) {
                            reader.readLine();
                            s = reader.readLine();
                            tokens = IOUtil.split(s);
                            if (tokens.length > 2) {
                                this.barcode = tokens[2];
                            }
                            if (tokens.length <= 0) continue;
                            this.plateName = tokens[0];
                            continue;
                        }
                        if (s.startsWith("Results for")) {
                            this.dataLineStarts.add(reader.getLineNumber() + 1);
                            if (this.plateName == null) {
                                this.plateName = String.valueOf(this.plateNames.size() + 1);
                            }
                            this.plateNames.add(String.valueOf(this.plateNames.size() + 1));
                            this.barcodes.add(this.barcode);
                            this.plateName = null;
                            this.barcode = null;
                            continue;
                        }
                        if (s.startsWith("Number of rows")) {
                            tokens = IOUtil.split(s);
                            tmp = tokens[tokens.length - 1];
                            tmp = tmp.replace("Number of rows", "");
                            tmp = tmp.replaceAll("\\.", "");
                            tmp = tmp.trim();
                            this.rows = ParserHelper.parseInt(tmp);
                            continue;
                        }
                        if (!s.startsWith("Number of columns")) continue;
                        tokens = IOUtil.split(s);
                        tmp = tokens[tokens.length - 1];
                        tmp = tmp.replace("Number of columns", "");
                        tmp = tmp.replaceAll("\\.", "");
                        tmp = tmp.trim();
                        this.columns = ParserHelper.parseInt(tmp);
                    }
                    break block19;
                }
                while ((s = reader.readLine()) != null) {
                    String[] tokens;
                    if (s.startsWith("Results for")) {
                        this.dataLineStarts.add(reader.getLineNumber() + 1);
                        this.singleTable = false;
                        String plateName = "Plate" + String.valueOf(this.plateNames.size() + 1);
                        this.barcodes.add(this.barcode);
                        this.barcode = null;
                        this.plateNames.add(plateName);
                        continue;
                    }
                    if (s.startsWith("PlateNumber,PlateRepeat")) {
                        String dataLine;
                        this.singleTable = true;
                        this.dataLineStarts.add(reader.getLineNumber());
                        while (!(dataLine = reader.readLine().trim()).equals("")) {
                            String[] tokens2 = IOUtil.splitComma(dataLine);
                            this.plateNames.add(tokens2[0]);
                            this.barcodes.add(tokens2[2]);
                        }
                        continue;
                    }
                    if (s.startsWith("Number of rows")) {
                        tokens = IOUtil.splitComma(s);
                        this.rows = ParserHelper.parseInt(tokens[tokens.length - 1].trim());
                        continue;
                    }
                    if (!s.startsWith("Number of columns")) continue;
                    tokens = IOUtil.splitComma(s);
                    this.columns = ParserHelper.parseInt(tokens[tokens.length - 1].trim());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    public TIntArrayList getDataLineStarts() {
        return this.dataLineStarts;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int getNumberOfPlates() {
        return this.plateNames.size();
    }

    @Override
    public String getPlateName(int index) {
        return this.plateNames.get(index);
    }

    public String getBarcode(int index) {
        return index < this.barcodes.size() ? this.barcodes.get(index) : null;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    public boolean isSingleTable() {
        return this.singleTable;
    }

    public boolean isTabDelimitted() {
        return this.tabDelimitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensionsFromDataBlock() throws IOException {
        int dataStartLineNumber = this.getDataLineStarts().getQuick(0);
        BufferedReader br = null;
        try {
            br = IOUtil.getBufferedReader(this.file);
            for (int lineNumber = 0; lineNumber < dataStartLineNumber; ++lineNumber) {
                br.readLine();
            }
            String line = br.readLine();
            String[] tokens = this.isTabDelimitted() ? IOUtil.split(line) : IOUtil.splitComma(line);
            this.columns = tokens.length - 1;
            StringBuilder sb = new StringBuilder();
            char delim = this.isTabDelimitted() ? (char)'\t' : ',';
            for (int j = 0; j < this.columns; ++j) {
                sb.append(delim);
            }
            String empty = sb.toString();
            this.rows = 1;
            while ((line = br.readLine()) != null && !line.equals("") && !line.equals(empty)) {
                ++this.rows;
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public String toString() {
        return "FileInfo [rows=" + this.rows + ", columns=" + this.columns + ", dataLineStarts=" + this.dataLineStarts + ", plateNames=" + this.plateNames + ", tabDelimitted=" + this.tabDelimitted + "]";
    }
}

