/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.persistence;

import com.jidesoft.comparator.FastComparableComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.broadinstitute.genee.matrix.Comparators;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class VectorPersistence {
    private boolean colorText;
    private boolean categoryVisible;
    private Integer chartStyle = -1;
    private boolean discrete;
    private boolean textVisible;
    private boolean toolTipVisible;
    @Deprecated
    private boolean chartVisible;
    private String name;
    private Object[] customSortOrder;
    private Class<?> columnClass;

    public VectorPersistence() {
    }

    public VectorPersistence(Vector column) {
        this.categoryVisible = MetadataUtil.isColorVisible(column);
        this.chartStyle = (Integer)column.getProperty("Chart Style");
        this.discrete = MetadataUtil.getBoolean(column, "Discrete Key");
        this.textVisible = MetadataUtil.isTextVisible(column);
        this.toolTipVisible = MetadataUtil.isToolTipVisible(column);
        this.colorText = MetadataUtil.getBoolean(column, "Text Color Visible");
        this.name = column.getName();
        Comparator<Object> c = column.getComparator();
        this.customSortOrder = c == null || c instanceof Comparators.StringCaseInsensitiveComparator || c instanceof FastComparableComparator ? null : VectorUtil.getValues(column).toArray();
        this.columnClass = column.getColumnClass();
    }

    public Integer getChartStyle() {
        return this.chartStyle;
    }

    public Class<?> getColumnClass() {
        return this.columnClass;
    }

    public Object[] getCustomSortOrder() {
        return this.customSortOrder;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCategoryVisible() {
        return this.categoryVisible;
    }

    public boolean isColorText() {
        return this.colorText;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public boolean isToolTipVisible() {
        return this.toolTipVisible;
    }

    public void setChartStyle(Integer chartStyle) {
        this.chartStyle = chartStyle;
    }

    public void setColorText(boolean colorText) {
        this.colorText = colorText;
    }

    public void setColumnClass(Class<?> columnClass) {
        this.columnClass = columnClass;
    }

    public void setCustomSortOrder(Object[] customSortOrder) {
        this.customSortOrder = customSortOrder;
    }

    public void setDiscrete(boolean discrete) {
        this.discrete = discrete;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setToolTipVisible(boolean toolTipVisible) {
        this.toolTipVisible = toolTipVisible;
    }

    public static void configure(Vector column, VectorPersistence persistence) {
        column.setProperty("Color Visible", persistence.isCategoryVisible());
        column.setProperty("Chart Style", persistence.getChartStyle());
        column.setProperty("Text Color Visible", persistence.isColorText());
        if (persistence.getCustomSortOrder() != null) {
            column.setComparator(Comparators.createComparatorForOrder(Arrays.asList(persistence.getCustomSortOrder())));
        }
        column.setProperty("Discrete Key", persistence.isDiscrete());
        column.setProperty("Text Visible", persistence.isTextVisible());
        column.setProperty("Tooltip Visible", persistence.isToolTipVisible());
    }
}

