/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.BUnzip2;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.GUnzip;
import org.apache.tools.ant.taskdefs.Untar;

public class ArchiveUtil {
    private ArchiveUtil() {
    }

    public static void extract(File source, File outputDir) {
        String name = source.getName().toLowerCase();
        if (name.endsWith(".zip")) {
            ArchiveUtil.unzip(source, outputDir);
        } else if (name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
            ArchiveUtil.untar(source, outputDir);
        } else if (name.endsWith(".tar.bz2")) {
            ArchiveUtil.untar(source, outputDir);
        } else if (name.endsWith(".gz")) {
            ArchiveUtil.gunzip(source, outputDir);
        } else if (name.endsWith(".bz2")) {
            ArchiveUtil.bunzip2(source, outputDir);
        } else {
            ArchiveUtil.unzip(source, outputDir);
        }
    }

    public static void bunzip2(File bzipFile, File outputDir) {
        BUnzip2 b = new BUnzip2();
        b.setSrc(bzipFile);
        b.setDest(outputDir);
        b.setProject(new Project());
        b.execute();
    }

    public static void gunzip(File gzipFile, File outputDir) {
        GUnzip b = new GUnzip();
        b.setSrc(gzipFile);
        b.setDest(outputDir);
        b.setProject(new Project());
        b.execute();
    }

    public static void untar(File tarFile, File outputDir) {
        Untar b = new Untar();
        String name = tarFile.getName().toLowerCase();
        if (name.endsWith(".gz") || name.endsWith(".tgz")) {
            Untar.UntarCompressionMethod m = new Untar.UntarCompressionMethod();
            m.setValue("gzip");
            b.setCompression(m);
        } else if (name.toLowerCase().endsWith(".bz2")) {
            Untar.UntarCompressionMethod m = new Untar.UntarCompressionMethod();
            m.setValue("bzip2");
            b.setCompression(m);
        }
        b.setSrc(tarFile);
        b.setDest(outputDir);
        b.setProject(new Project());
        b.execute();
    }

    public static void unzip(File zipFile, File outputDir) {
        Expand expander = new Expand();
        expander.setSrc(zipFile);
        expander.setDest(outputDir);
        expander.setProject(new Project());
        expander.execute();
    }
}

