/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableWrapper;

public class ImageUtil {
    private static Map<String, String[]> fileFormatToExtensions;

    private ImageUtil() {
    }

    public static BufferedImage componentSnapshot(Component c) {
        return ImageUtil.snapshot(new DrawableWrapper(c));
    }

    public static BufferedImage createImage(int width, int height) {
        return GraphicsEnvironment.isHeadless() ? new BufferedImage(width, height, 1) : ImageUtil.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTiledPdf(Drawable drawable, File file, boolean tileColumns, boolean tileRows) throws IOException, DocumentException {
        int numRows;
        int numColumns;
        if (drawable == null) {
            throw new NullPointerException("drawable is null.");
        }
        float pageWidth = PageSize.LETTER.getWidth();
        float pageHeight = PageSize.LETTER.getHeight();
        Dimension drawableSize = drawable.getDrawableSize();
        int n = numColumns = !tileColumns ? 1 : (int)Math.ceil((float)drawableSize.width / pageWidth);
        if (numColumns < 1) {
            numColumns = 1;
        }
        int n2 = numRows = !tileRows ? 1 : (int)Math.ceil((float)drawableSize.height / pageHeight);
        if (numRows < 1) {
            numRows = 1;
        }
        if (numRows == 1 && numColumns == 1) {
            ImageUtil.saveAsPdfUsingIText(drawable, file);
            return;
        }
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        float y = (float)(-drawableSize.height) + pageHeight;
        for (int i = 0; i < numRows; ++i) {
            float x = 0.0f;
            for (int j = 0; j < numColumns; ++j) {
                Point2D.Float p = new Point2D.Float(x, y);
                points.add(p);
                x -= pageWidth;
            }
            y += pageHeight;
        }
        Document document = new Document(new Rectangle(0.0f, 0.0f, tileColumns ? pageWidth : (float)drawableSize.width, tileRows ? pageHeight : (float)drawableSize.height));
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
            document.open();
            PdfContentByte contentByte = writer.getDirectContent();
            PdfTemplate fullTemplate = contentByte.createTemplate((float)drawableSize.width, (float)drawableSize.height);
            Graphics2D g2 = fullTemplate.createGraphics((float)drawableSize.width, (float)drawableSize.height, (FontMapper)new DefaultFontMapper());
            drawable.draw(g2, new java.awt.Rectangle(drawableSize));
            g2.dispose();
            for (Point2D.Float p : points) {
                contentByte.addTemplate(fullTemplate, 1.0f, 0.0f, 0.0f, 1.0f, p.x, p.y);
                document.newPage();
            }
        }
        finally {
            document.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTiledPdf(Printable printable, File file, boolean tileColumns, boolean tileRows) throws IOException, DocumentException, PrinterException {
        file.delete();
        float pageWidth = PageSize.LETTER.getWidth();
        float pageHeight = PageSize.LETTER.getHeight();
        Document document = new Document(new Rectangle(0.0f, 0.0f, pageWidth, pageHeight));
        try {
            int returnValue;
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
            document.open();
            PdfContentByte canvas = writer.getDirectContent();
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            pageFormat.setPaper(paper);
            int i = 0;
            do {
                document.newPage();
                paper.setSize(pageWidth, pageHeight);
                Graphics2D g2 = canvas.createGraphics(pageWidth, pageHeight, (FontMapper)new DefaultFontMapper());
                returnValue = printable.print(g2, pageFormat, i++);
                g2.dispose();
            } while (returnValue != 1);
        }
        finally {
            document.close();
        }
    }

    public static Color decodeColor(String s) {
        try {
            return Color.decode(s);
        }
        catch (NumberFormatException e) {
            return ImageUtil.decodeRGBTriplet(s);
        }
    }

    public static Color decodeRGBTriplet(String triplet) {
        String[] rgb = triplet.split(":");
        if (rgb.length != 3) {
            throw new NumberFormatException("Invalid rgb triplet " + triplet);
        }
        int r = 0;
        int g = 0;
        int b = 0;
        r = Integer.parseInt(rgb[0]);
        g = Integer.parseInt(rgb[1]);
        b = Integer.parseInt(rgb[2]);
        try {
            return new Color(r, g, b);
        }
        catch (IllegalArgumentException iae) {
            throw new NumberFormatException(iae.getMessage());
        }
    }

    public static String[] getExtensions(String fileFormat) {
        return fileFormatToExtensions.get(fileFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color[] parseColorMap(File file) {
        BufferedReader br = null;
        try {
            Color[] c;
            br = new BufferedReader(new FileReader(file));
            String s = null;
            ArrayList<Color[]> colors = new ArrayList<Color[]>();
            while ((s = br.readLine()) != null) {
                if (s.trim().equals("")) continue;
                c = ImageUtil.decodeColor(s);
                colors.add(c);
            }
            c = colors.toArray(new Color[0]);
            return c;
        }
        catch (IOException ioe) {
            Color[] colorArray = null;
            return colorArray;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Color[] parseString(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String[] tokens = s.split(";");
        Color[] colors = new Color[tokens.length];
        int length = tokens.length;
        for (int i = 0; i < length; ++i) {
            colors[i] = new Color(Integer.parseInt(tokens[i]));
        }
        return colors;
    }

    public static BufferedImage readImage(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            if (image == null) {
                RenderedOp src = JAI.create((String)"fileload", (Object)file.getCanonicalPath());
                image = src.getAsBufferedImage();
            }
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveImage(Drawable drawable, String format, File file, boolean checkFileExtension) throws IOException {
        if (format.equalsIgnoreCase("pdf")) {
            if (checkFileExtension) {
                file = new File(file.getParent(), ImageUtil.checkFileExtension(file.getName(), format));
            }
            ImageUtil.saveAsPdfUsingIText(drawable, file);
        } else if (format.equalsIgnoreCase("eps")) {
            if (checkFileExtension) {
                file = new File(file.getParent(), ImageUtil.checkFileExtension(file.getName(), format));
            }
        } else {
            ImageUtil.saveImage(ImageUtil.snapshot(drawable), file, format, checkFileExtension);
        }
    }

    public static void saveImage(RenderedImage image, File outputFile, String outputFileFormat, boolean checkExtension) throws IOException {
        boolean wrote;
        if (checkExtension) {
            outputFile = new File(outputFile.getParentFile(), ImageUtil.checkFileExtension(outputFile.getName(), outputFileFormat));
        }
        if (!(wrote = ImageIO.write(image, outputFileFormat, outputFile)) && outputFileFormat.equalsIgnoreCase("tiff")) {
            TIFFEncodeParam param = new TIFFEncodeParam();
            param.setCompression(1);
            JAI.create((String)"filestore", (RenderedImage)image, (Object)outputFile.getCanonicalPath(), (Object)outputFileFormat, (Object)param);
            System.gc();
        } else if (!wrote) {
            System.err.println("Unable to save image");
        }
    }

    public static BufferedImage snapshot(Drawable drawable) {
        return ImageUtil.snapshot(drawable, 5);
    }

    public static BufferedImage snapshot(Drawable drawable, int imageType) {
        if (drawable == null) {
            throw new IllegalArgumentException("Param drawable cannot be null");
        }
        Dimension size = drawable.getDrawableSize();
        try {
            BufferedImage image = new BufferedImage(size.width, size.height, imageType);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(Color.BLACK);
            drawable.draw(g, new java.awt.Rectangle(size));
            g.dispose();
            return image;
        }
        catch (NegativeArraySizeException x) {
            throw new IllegalArgumentException("Image is too large.");
        }
    }

    public static String toString(Color color) {
        return String.valueOf(color.getRGB());
    }

    public static String toString(Color[] colors) {
        StringBuilder buf = new StringBuilder();
        int length = colors.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append(colors[i].getRGB());
        }
        return buf.toString();
    }

    public static String toString(float[] values) {
        StringBuilder buf = new StringBuilder();
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append(values[i]);
        }
        return buf.toString();
    }

    private static String checkFileExtension(String outputFileName, String outputFileFormat) {
        String[] extensions = ImageUtil.getExtensions(outputFileFormat);
        if (extensions != null && extensions.length > 0) {
            for (int i = 0; i < extensions.length; ++i) {
                if (!outputFileName.endsWith(extensions[i])) continue;
                return outputFileName;
            }
            return outputFileName + extensions[0];
        }
        return outputFileName;
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static void saveAsPdfUsingIText(Drawable drawable, File file) throws IOException {
        if (drawable == null) {
            throw new NullPointerException("drawable is null.");
        }
        OutputStream os = null;
        Dimension size = drawable.getDrawableSize();
        int width = size.width;
        int height = size.height;
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            os = new BufferedOutputStream(new FileOutputStream(file));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2d = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
            drawable.draw(g2d, new java.awt.Rectangle(size));
            g2d.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            writer.flush();
            document.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static {
        ImageIO.setUseCache(true);
        fileFormatToExtensions = new HashMap<String, String[]>();
        fileFormatToExtensions.put("jpeg", new String[]{".jpeg", ".jpg"});
        fileFormatToExtensions.put("png", new String[]{".png"});
        fileFormatToExtensions.put("tiff", new String[]{".tiff"});
        fileFormatToExtensions.put("eps", new String[]{".eps", ".ps"});
        fileFormatToExtensions.put("bmp", new String[]{".bmp"});
        fileFormatToExtensions.put("pdf", new String[]{".pdf"});
    }
}

