/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.CdtWriter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.menu.file.StringTableModel;
import org.broadinstitute.genee.io.matrix.ListFileWriter;
import org.broadinstitute.genee.io.matrix.ProjectReader;
import org.broadinstitute.genee.io.matrix.ProjectWriter;
import org.broadinstitute.genee.io.matrix.RnkReader;
import org.broadinstitute.genee.io.matrix.TxtProjectWriter;
import org.broadinstitute.genee.io.matrix.gct.GctReader;
import org.broadinstitute.genee.io.matrix.gct.GctWriter12;
import org.broadinstitute.genee.io.matrix.gct.GctWriter13;
import org.broadinstitute.genee.io.matrix.gctx.GctxProjectReader;
import org.broadinstitute.genee.io.matrix.gctx.GctxProjectWriter;
import org.broadinstitute.genee.io.matrix.geneset.GmtDatasetReader;
import org.broadinstitute.genee.io.matrix.geneset.GmxDatasetReader;
import org.broadinstitute.genee.io.matrix.gpr.GprReader;
import org.broadinstitute.genee.io.matrix.res.ResReader;
import org.broadinstitute.genee.io.matrix.stanford.CdtReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class ProjectIO {
    private static Map<String, ProjectWriter> formatNameToWriterMap = new HashMap<String, ProjectWriter>();
    private static Map<String, ProjectReader> suffixToReader;

    private ProjectIO() {
    }

    public static ProjectReader getProjectReader(String pathname) {
        String ext = IOUtil.getExtension(pathname);
        return suffixToReader.get(ext);
    }

    public static Project read(String[][] matrix, int dataColumnStart, int dataRowStart, String datasetName) {
        return ProjectIO.readProject(new StringTableModel(matrix), dataColumnStart, dataRowStart, datasetName);
    }

    public static Project readProject(String pathname) throws IOException {
        Project p;
        ProjectReader reader = ProjectIO.getProjectReader(pathname);
        if (reader == null) {
            BufferedReader br = IOUtil.getBufferedReader(pathname);
            String line = br.readLine();
            br.close();
            if (line != null && line.startsWith("#1.3")) {
                reader = new GctReader();
            } else {
                return null;
            }
        }
        if ((p = reader.read(pathname)) != null) {
            boolean isGctx = reader instanceof GctxProjectReader;
            if (p.getOriginalDataset().getProperty("genee.options") == null) {
                MetadataUtil.setColumnMetadataVisibility(p.getOriginalDataset().getColumnMetadata());
                MetadataUtil.setRowMetadataVisibility(p.getOriginalDataset().getRowMetadata());
            }
            MetadataUtil.maybeConvertMetadataClass(p.getOriginalDataset(), !isGctx);
            if (reader instanceof GmtDatasetReader || reader instanceof GmxDatasetReader) {
                p.getOriginalDataset().setProperty("isBinary", true);
            }
        }
        return p;
    }

    public static Project readProject(TableModel tableModel, int dataColumnStart, int dataRowStart, String datasetName) {
        int unique;
        String name;
        int i;
        int columns = tableModel.getColumnCount() - dataColumnStart;
        int rows = tableModel.getRowCount() - dataRowStart;
        RowMajorArray2DDataset dataset = new RowMajorArray2DDataset(datasetName, rows, columns);
        if (dataColumnStart > 0) {
            for (i = 0; i < dataRowStart; ++i) {
                name = (String)tableModel.getValueAt(i, 0);
                if (name == null || name.equals("") || name.equals("na")) {
                    name = "Annotation";
                }
                unique = 1;
                while (dataset.getColumnMetadata().get(name) != null) {
                    name = name + "-" + unique;
                    ++unique;
                }
                Vector v = dataset.getColumnMetadata().getMetadataCount() == 0 ? MetadataUtil.addRowVector(dataset.getColumnMetadata(), new String(name), String.class) : MetadataUtil.addColumnVector(dataset.getColumnMetadata(), new String(name), String.class);
                boolean nonEmpty = false;
                for (int j = 0; j < columns; ++j) {
                    String s = (String)tableModel.getValueAt(i, j + dataColumnStart);
                    if (s == null || s.equals("")) continue;
                    nonEmpty = true;
                    v.setValue(j, new String(s));
                }
                if (nonEmpty) continue;
                dataset.getColumnMetadata().remove(dataset.getColumnMetadata().getColumnIndex(v.getName()));
            }
        }
        if (dataRowStart > 0) {
            for (int j = 0; j < dataColumnStart; ++j) {
                name = (String)tableModel.getValueAt(0, j);
                if (name == null || name.equals("")) {
                    name = "Annotation";
                }
                unique = 1;
                while (dataset.getRowMetadata().get(name) != null) {
                    name = name + "-" + unique;
                    ++unique;
                }
                MetadataUtil.addRowVector(dataset.getRowMetadata(), new String(name), String.class);
            }
        }
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < dataColumnStart; ++j) {
                String metaDataValue = (String)tableModel.getValueAt(i + dataRowStart, j);
                dataset.getRowMetadata().get(j).setValue(i, metaDataValue != null ? new String(metaDataValue) : null);
            }
        }
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                String s = (String)tableModel.getValueAt(i + dataRowStart, j + dataColumnStart);
                try {
                    dataset.setValue(i, j, ParserHelper.parseFloatNaN(s));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("Unable to parse value value " + s + " at row " + i + " and column " + j + ".");
                }
            }
        }
        MetadataUtil.setColumnMetadataVisibility(dataset.getColumnMetadata());
        MetadataUtil.setRowMetadataVisibility(dataset.getRowMetadata());
        MetadataUtil.maybeConvertMetadataClass(dataset, true);
        return new DefaultProject(dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeProject(Project project, ProjectWriter writer, String pathname, boolean checkFileExtension) throws IOException {
        if (checkFileExtension) {
            pathname = writer.checkFileExtension(pathname);
        }
        if (writer instanceof GctxProjectWriter) {
            ((GctxProjectWriter)writer).write(project, pathname);
        } else {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(pathname);
                writer.write(project, pw);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        return pathname;
    }

    public static void writeProject(Project project, String formatName, PrintWriter pw) throws IOException {
        ProjectWriter writer = formatNameToWriterMap.get(formatName);
        if (writer == null) {
            throw new IOException("No writer to save the data in " + formatName + " format.");
        }
        if (writer instanceof GctxProjectWriter) {
            throw new IOException("Can not write to a gctx file using a print writer. Please supply a file instead.");
        }
        writer.write(project, pw);
    }

    public static String writeProject(Project project, String formatName, String pathname) throws IOException {
        return ProjectIO.writeProject(project, formatName, pathname, true);
    }

    public static String writeProject(Project project, String formatName, String pathname, boolean checkFileExtension) throws IOException {
        ProjectWriter writer = formatNameToWriterMap.get(formatName);
        if (writer == null) {
            throw new IOException("No writer to save the data in " + formatName + " format.");
        }
        return ProjectIO.writeProject(project, writer, pathname, checkFileExtension);
    }

    private static void addReaders(Iterator<ProjectReader> readers) {
        while (readers.hasNext()) {
            ProjectReader reader = readers.next();
            List<String> suffixes = reader.getFileSuffixes();
            int cnt = suffixes.size();
            for (int j = 0; j < cnt; ++j) {
                String suffix = suffixes.get(j);
                suffixToReader.put(suffix.toLowerCase(), reader);
            }
        }
    }

    private static void addWriters(Iterator<ProjectWriter> writers) {
        while (writers.hasNext()) {
            ProjectWriter writer = writers.next();
            formatNameToWriterMap.put(writer.getFormatName(), writer);
        }
    }

    static {
        ProjectIO.addWriters(Arrays.asList(new GctWriter12(), new GctWriter13(), new TxtProjectWriter(), new CdtWriter(), new GctxProjectWriter(), new ListFileWriter()).iterator());
        suffixToReader = new HashMap<String, ProjectReader>();
        ProjectIO.addReaders(Arrays.asList(new GctReader(), new ResReader(), new CdtReader(), new GprReader(), new RnkReader(), new GctxProjectReader(), new GmxDatasetReader(), new GmtDatasetReader()).iterator());
    }
}

