/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.io.util;

import com.google.common.base.Function;
import gnu.trove.list.array.TIntArrayList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.FloatList;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class ToStringUtil {
    private ToStringUtil() {
    }

    public static String allToString(MetadataModel model, int index, String sep) {
        StringBuilder sb = new StringBuilder();
        int metadataCount = model.getMetadataCount();
        for (int i = 0; i < metadataCount; ++i) {
            Object value = model.get(i).getValue(index);
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(Formatter.toString(value));
        }
        return sb.toString();
    }

    public static void printStackTrace() {
        System.out.println(ToStringUtil.toString(new RuntimeException()));
    }

    public static String toString(char[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String toString(Collection<?> collection, String sep) {
        return ToStringUtil.toString(collection, sep, null);
    }

    public static String toString(Collection<?> collection, String sep, Function<Object, String> toStringFunction) {
        StringBuilder sb = new StringBuilder();
        if (collection == null) {
            return "";
        }
        for (Object obj : collection) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            String value = toStringFunction != null ? (String)toStringFunction.apply(obj) : String.valueOf(obj);
            sb.append(value);
        }
        return sb.toString();
    }

    public static String toString(double[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(Formatter.format(array[i]));
        }
        return sb.toString();
    }

    public static String toString(float[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(Formatter.format(array[i]));
        }
        return sb.toString();
    }

    public static String toString(float[][] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int rows = array.length;
        for (int i = 0; i < rows; ++i) {
            int cols = array[i].length;
            for (int j = 0; j < cols; ++j) {
                if (j > 0) {
                    sb.append(sep);
                }
                sb.append(Formatter.format(array[i][j]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(FloatList list, String sep) {
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            String value = Formatter.format(list.getValue(i));
            sb.append(value);
        }
        return sb.toString();
    }

    public static String toString(int[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String toString(int[][] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int rows = array.length;
        for (int i = 0; i < rows; ++i) {
            int cols = array[i].length;
            for (int j = 0; j < cols; ++j) {
                if (j > 0) {
                    sb.append(sep);
                }
                sb.append(array[i][j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Iterable it, String sep) {
        StringBuilder sb = new StringBuilder();
        if (it == null) {
            return "";
        }
        int i = 0;
        for (Object obj : it) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(obj);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(long[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String toString(MetadataModel model) {
        StringBuilder sb = new StringBuilder();
        int size = model.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ToStringUtil.toString(model, i, " "));
        }
        return sb.toString();
    }

    public static String toString(MetadataModel model, int itemIndex) {
        return ToStringUtil.toString(model, itemIndex, ", ");
    }

    public static String toString(MetadataModel model, int itemIndex, String sep) {
        if (model.getMetadataCount() == 0) {
            return "" + itemIndex;
        }
        MetadataModel subset = MetadataUtil.getTextColumns(model);
        if (subset.getMetadataCount() > 0) {
            return ToStringUtil.allToString(subset, itemIndex, ", ");
        }
        subset = MetadataUtil.getCategoryColumns(model);
        if (subset.getMetadataCount() > 0) {
            return ToStringUtil.allToString(subset, itemIndex, ", ");
        }
        return ToStringUtil.allToString(model, itemIndex, ", ");
    }

    public static String toString(Object[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String toString(short[] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(String.valueOf(array[i]));
        }
        return sb.toString();
    }

    public static String toString(String[][] array, String sep) {
        StringBuilder sb = new StringBuilder();
        if (array == null) {
            return "";
        }
        int rows = array.length;
        for (int i = 0; i < rows; ++i) {
            int cols = array[0].length;
            for (int j = 0; j < cols; ++j) {
                if (j > 0) {
                    sb.append(sep);
                }
                sb.append(array[i][j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String toString(Throwable t, int depth) {
        StringBuilder buf = new StringBuilder();
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < Math.min(depth, trace.length); ++i) {
            buf.append("\tat " + trace[i]);
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String toString(TIntArrayList list, String sep) {
        StringBuilder sb = new StringBuilder();
        if (list == null) {
            return "";
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(list.getQuick(i));
        }
        return sb.toString();
    }
}

