/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex;

import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.menu.GENEEMenuBar;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.luminex.AbstractLuminexProcessor;
import org.broadinstitute.genee.luminex.Ceiling;
import org.broadinstitute.genee.luminex.CollapsedToolTipProvider;
import org.broadinstitute.genee.luminex.Floor;
import org.broadinstitute.genee.luminex.ui.compound.method2.CompoundProcessedGUI;
import org.broadinstitute.genee.luminex.ui.compound.method2.LuminexProcessedResult;
import org.broadinstitute.genee.math.stat.CollapseDataset;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.TroveFloatList;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class PRISMCompoundProcessor
extends AbstractLuminexProcessor {
    private boolean scaleToUntreated;
    private float censorValue;
    private boolean doCensoring;
    private HashMap<Identifier, TIntArrayList> compoundToTreatedIndices;
    private Dataset mergedCollapsedDataset;
    private int cellLineCount;
    private float[][] nullDistributionForEachCellLine;
    private float[] untreatedCellLineStdevs;
    private float[] untreatedCellLineMeans;
    private RowMajorArray2DDataset averageZScore;
    private RowMajorArray2DDataset compoundPValues;
    private RowMajorArray2DDataset zScoreAtEachConcentration;
    private StringBuilder censorStringBuf;
    private float floor = Float.NaN;
    private String[] rowMetadataNamesForReplicatesMinusConcentration;
    private float ceiling = Float.NaN;

    public void setThreshold(boolean threshold, float value) {
        this.floor = threshold ? value : Float.NaN;
    }

    public void setCeiling(boolean ceiling, float value) {
        this.ceiling = ceiling ? value : Float.NaN;
    }

    public void execute() {
        final GENEETreeNode activeNode = Application.getWindowManager().getNode();
        new BackgroundTask<GENEEFolderNode>("PRISM"){

            @Override
            protected GENEEFolderNode doInBackground() throws Exception {
                return PRISMCompoundProcessor.this.doInBackground();
            }

            @Override
            protected void succeeded(GENEEFolderNode node) {
                activeNode.insert(node, activeNode.getChildCount());
                Application.add(node);
            }
        }.execute();
    }

    public void setCensor(boolean censor, float value) {
        this.censorValue = value;
        this.doCensoring = censor;
    }

    public void setScaleToUntreated(boolean scaleToUntreated) {
        this.scaleToUntreated = scaleToUntreated;
    }

    private void censorBasedOnUntreatedMedian(RowMajorArray2DDataset untreatedMediansPerPlateAndCellLine) {
        this.censorStringBuf = new StringBuilder();
        float[][] array = this.dataset.getArray();
        for (int plateIdx = 0; plateIdx < this.plateNames.length; ++plateIdx) {
            StringBuilder censoringInfo = new StringBuilder();
            for (int cellLineIdx = 0; cellLineIdx < this.dataset.getColumnCount(); ++cellLineIdx) {
                float plateUntreatedMedian = untreatedMediansPerPlateAndCellLine.getValue(plateIdx, cellLineIdx);
                if (!(plateUntreatedMedian <= this.censorValue)) continue;
                if (censoringInfo.length() > 0) {
                    censoringInfo.append(", ");
                }
                censoringInfo.append(ToStringUtil.toString(this.dataset.getColumnMetadata(), cellLineIdx));
                TIntArrayList indices = (TIntArrayList)this.plateNameToRowIndices.get(this.plateNames[plateIdx]);
                int rows = indices.size();
                for (int i = 0; i < rows; ++i) {
                    int index = indices.getQuick(i);
                    array[index][cellLineIdx] = Float.NaN;
                }
            }
            if (censoringInfo.length() <= 0) continue;
            this.censorStringBuf.append(this.plateNames[plateIdx] + " " + censoringInfo.toString());
        }
    }

    private static boolean isUntreated(Dataset dataset, String[] concentrationMetadataNames, int rowIndex) {
        for (String concentrationMetadataName : concentrationMetadataNames) {
            Number conc = (Number)dataset.getRowMetadata().getValue(rowIndex, concentrationMetadataName);
            if (conc == null || conc.floatValue() == 0.0f) continue;
            return false;
        }
        return true;
    }

    private RowMajorArray2DDataset computeUntreatedMediansPerPlateAndCellLine() {
        RowMajorArray2DDataset untreatedMediansPerPlateAndCellLine = new RowMajorArray2DDataset("", this.plateNames.length, this.dataset.getColumnCount());
        Vector plate = MetadataUtil.addRowVector(untreatedMediansPerPlateAndCellLine.getRowMetadata(), "Plate", String.class);
        for (int i = 0; i < plate.size(); ++i) {
            plate.setValue(i, this.plateNames[i]);
        }
        for (int plateIdx = 0; plateIdx < this.plateNames.length; ++plateIdx) {
            TIntArrayList rowIndices = (TIntArrayList)this.plateNameToRowIndices.get(this.plateNames[plateIdx]);
            int cols = this.dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                TFloatArrayList untreatedValues = new TFloatArrayList();
                int rows = rowIndices.size();
                for (int i = 0; i < rows; ++i) {
                    float val;
                    int index = rowIndices.getQuick(i);
                    if (!PRISMCompoundProcessor.isUntreated(this.dataset, this.concentrationMetadataNames, index) || Float.isNaN(val = this.dataset.getValue(index, j))) continue;
                    untreatedValues.add(val);
                }
                if (untreatedValues.size() == 0) {
                    System.err.println("No untreated values found for plate " + this.plateNames[plateIdx] + " in column " + j + ", " + ToStringUtil.toString(this.dataset.getColumnMetadata(), j));
                    return null;
                }
                float untreatedMedian = new Median().evaluate(new TroveFloatList(untreatedValues));
                untreatedMediansPerPlateAndCellLine.setValue(plateIdx, j, untreatedMedian);
            }
        }
        return untreatedMediansPerPlateAndCellLine;
    }

    private GENEEFolderNode doInBackground() throws Exception {
        Object f;
        RowMajorArray2DDataset untreatedMediansPerPlateAndCellLine;
        ArrayList<ProjectGENEEResultTreeNode> results = new ArrayList<ProjectGENEEResultTreeNode>();
        History history = new History("PRISM");
        ArrayList<RowMajorArray2DDataset> datasetProcessingSteps = new ArrayList<RowMajorArray2DDataset>();
        RowMajorArray2DDataset rawDataset = DatasetUtil.deepCopy(this.dataset);
        datasetProcessingSteps.add(rawDataset);
        if (this.subtractBackground) {
            Dataset backgroundDataset = this.subtractBackgroundFunction.execute();
            history.add(this.subtractBackgroundFunction.toString(), null);
            this.createNode(results, backgroundDataset, "Background", history);
            datasetProcessingSteps.add((RowMajorArray2DDataset)this.createNode(results, this.dataset, "Background Subtraction", datasetProcessingSteps, history).getProject().getOriginalDataset());
        }
        if ((untreatedMediansPerPlateAndCellLine = this.computeUntreatedMediansPerPlateAndCellLine()) != null) {
            this.createNode(results, untreatedMediansPerPlateAndCellLine, "Untreated Medians", history);
        }
        if (this.doCensoring) {
            if (untreatedMediansPerPlateAndCellLine == null) {
                throw new RuntimeException("Unable to compute untreated medians.");
            }
            this.censorBasedOnUntreatedMedian(untreatedMediansPerPlateAndCellLine);
            history.add("Censored points for cell line on plate if median of untreated is less than ", Formatter.format(this.censorValue));
            if (this.censorStringBuf.length() > 0) {
                history.add("Censored", this.censorStringBuf.toString());
            } else {
                history.add("No points censored.", null);
            }
            this.createNode(results, this.dataset, "Censored", datasetProcessingSteps, history).getProject().getOriginalDataset();
        }
        if (this.scaleToUntreated) {
            if (untreatedMediansPerPlateAndCellLine == null) {
                throw new RuntimeException("Unable to compute untreated medians.");
            }
            this.scaleToUntreated(untreatedMediansPerPlateAndCellLine);
            history.add("Scaled to untreated=100", null);
            datasetProcessingSteps.add((RowMajorArray2DDataset)this.createNode(results, this.dataset, "Scale to untreated=100", datasetProcessingSteps, history).getProject().getOriginalDataset());
        }
        if (!Float.isNaN(this.floor)) {
            f = new Floor(this.dataset, this.floor);
            ((Floor)f).execute();
            history.add(((Floor)f).toString(), null);
            datasetProcessingSteps.add((RowMajorArray2DDataset)this.createNode(results, this.dataset, "Floor", datasetProcessingSteps, history).getProject().getOriginalDataset());
        }
        if (!Float.isNaN(this.ceiling)) {
            f = new Ceiling(this.dataset, this.ceiling);
            ((Ceiling)f).execute();
            history.add(((Ceiling)f).toString(), null);
            datasetProcessingSteps.add((RowMajorArray2DDataset)this.createNode(results, this.dataset, "Ceiling", datasetProcessingSteps, history).getProject().getOriginalDataset());
        }
        this.cellLineCount = this.dataset.getColumnCount();
        String collapseString = "Collapsed replicates using " + this.collapseReplicatesMethod.toString();
        if (this.collapseReplicatesMethod == CollapseMethodOption.TRIMMED_MEAN) {
            collapseString = collapseString + " s=" + this.collapseReplicatesTrimmedMeanS + ", l=" + this.collapseReplicatesTrimmedMeanS;
        }
        history.add(collapseString, null);
        CollapseDataset collapseReplicates = new CollapseDataset();
        collapseReplicates.setCollapseMethod(this.collapseReplicatesMethod);
        collapseReplicates.setTrimmedMeanL(this.collapseReplicatesTrimmedMeanL);
        collapseReplicates.setTrimmedMeanS(this.collapseReplicatesTrimmedMeanS);
        collapseReplicates.setCollapseTo(this.namesForReplicates);
        DefaultProject mergedProjectBeforeCollapsing = new DefaultProject(DatasetUtil.shallowCopy(this.dataset));
        collapseReplicates.setDataset(mergedProjectBeforeCollapsing.getSortedFilteredDataset());
        this.mergedCollapsedDataset = collapseReplicates.execute();
        Map<Identifier, TIntArrayList> replicateToIndices = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(mergedProjectBeforeCollapsing.getSortedFilteredDataset().getRowMetadata(), this.namesForReplicates));
        TIntArrayList allUntreatedIndices = new TIntArrayList();
        this.compoundToTreatedIndices = new HashMap();
        ArrayList<String> tmpList = new ArrayList<String>(Arrays.asList(this.namesForReplicates));
        for (String concentrationMetadataName : this.concentrationMetadataNames) {
            tmpList.remove(concentrationMetadataName);
        }
        this.rowMetadataNamesForReplicatesMinusConcentration = tmpList.toArray(new String[0]);
        for (int compoundIdx = 0; compoundIdx < this.mergedCollapsedDataset.getRowCount(); ++compoundIdx) {
            boolean isUntreated = PRISMCompoundProcessor.isUntreated(this.mergedCollapsedDataset, this.concentrationMetadataNames, compoundIdx);
            Object[] metadataArray = new Object[this.rowMetadataNamesForReplicatesMinusConcentration.length];
            for (int j = 0; j < this.rowMetadataNamesForReplicatesMinusConcentration.length; ++j) {
                metadataArray[j] = this.mergedCollapsedDataset.getRowMetadata().getValue(compoundIdx, this.rowMetadataNamesForReplicatesMinusConcentration[j]);
            }
            if (isUntreated) {
                allUntreatedIndices.add(compoundIdx);
                continue;
            }
            Object compound = this.mergedCollapsedDataset.getRowMetadata().getValue(compoundIdx, 0);
            Identifier<Object> replicate = new Identifier<Object>(compound, metadataArray);
            TIntArrayList treatedIndices = this.compoundToTreatedIndices.get(replicate);
            if (treatedIndices == null) {
                treatedIndices = new TIntArrayList();
                this.compoundToTreatedIndices.put(replicate, treatedIndices);
            }
            treatedIndices.add(compoundIdx);
        }
        if (untreatedMediansPerPlateAndCellLine != null) {
            this.computeZScoreAtEachConc();
        }
        LuminexProcessedResult result = new LuminexProcessedResult();
        result.averageZScore = this.averageZScore;
        result.untreatedMediansPerPlateAndCellLine = untreatedMediansPerPlateAndCellLine;
        result.mergedCollapsedDataset = this.mergedCollapsedDataset;
        result.untreatedIndices = allUntreatedIndices;
        result.zScoreAtEachConcentration = this.zScoreAtEachConcentration;
        result.nullDistributionForEachCellLine = this.nullDistributionForEachCellLine;
        result.untreatedCellLineMeans = this.untreatedCellLineMeans;
        result.untreatedCellLineStdevs = this.untreatedCellLineStdevs;
        result.drugPValues = this.compoundPValues;
        DefaultProject rescaledProject = new DefaultProject(result.mergedCollapsedDataset);
        HeatMapPanel rescaledHeatMap = new HeatMapPanel(rescaledProject);
        rescaledHeatMap.setToolTipProvider(new CollapsedToolTipProvider(datasetProcessingSteps, replicateToIndices, this.namesForReplicates));
        this.sort(rescaledProject);
        HeatMapColorScheme rescaledColorScheme = rescaledHeatMap.getColorScheme();
        rescaledColorScheme.setGlobalMaxMode(2, 100.0f);
        rescaledColorScheme.setGlobalMinMode(2, 0.0f);
        rescaledColorScheme.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE});
        rescaledHeatMap.setName("Rescaled");
        ProjectGENEEResultTreeNode rescaledNode = new ProjectGENEEResultTreeNode(rescaledHeatMap.getProject(), rescaledHeatMap, history);
        results.add(rescaledNode);
        if (this.zScoreAtEachConcentration != null) {
            DefaultProject zScoreConcentrationProject = new DefaultProject(this.zScoreAtEachConcentration);
            CompoundProcessedGUI.ZScoreHeatMap zScoreHeatMap = new CompoundProcessedGUI.ZScoreHeatMap(zScoreConcentrationProject, result.untreatedMediansPerPlateAndCellLine);
            zScoreHeatMap.setToolTipProvider(new CollapsedToolTipProvider(datasetProcessingSteps, replicateToIndices, this.namesForReplicates));
            this.sort(zScoreConcentrationProject);
            ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(zScoreHeatMap.getProject(), zScoreHeatMap, history);
            node.setAutoOpen(false);
            results.add(node);
        }
        if (result.averageZScore != null) {
            DefaultProject aveZScoreProject = new DefaultProject(result.averageZScore);
            CompoundProcessedGUI.AverageZScore averageZScoreView = new CompoundProcessedGUI.AverageZScore(aveZScoreProject);
            this.sort(aveZScoreProject);
            GENEEMenuBar averageZScoreMenuBar = new GENEEMenuBar(averageZScoreView);
            GENEEWindow dotPlotWindow = Application.createViewWindow("Dot Plot");
            ProjectGENEEResultTreeNode node = new ProjectGENEEResultTreeNode(averageZScoreView.getProject(), averageZScoreView, history);
            node.setAutoOpen(false);
            results.add(node);
            DefaultProject pValueProject = new DefaultProject(result.drugPValues);
            GENEEWindow window2 = Application.createViewWindow("Dot Plot");
            CompoundProcessedGUI.PValueHeatMap pValueHeatMap = new CompoundProcessedGUI.PValueHeatMap(pValueProject);
            GENEEMenuBar pValueMenuBar = new GENEEMenuBar(pValueHeatMap);
            this.sort(pValueProject);
            node = new ProjectGENEEResultTreeNode(pValueHeatMap.getProject(), pValueHeatMap, history);
            results.add(node);
        }
        return new GENEEFolderNode("PRISM", history, results.toArray(new MutableTreeNode[0]));
    }

    private RowMajorArray2DDataset scaleToUntreated(RowMajorArray2DDataset untreatedMediansPerPlateAndCellLine) {
        float[][] array = this.dataset.getArray();
        for (int plateIdx = 0; plateIdx < this.plateNames.length; ++plateIdx) {
            Object plate = this.plateNames[plateIdx];
            TIntArrayList rowIndicesForPlate = (TIntArrayList)this.plateNameToRowIndices.get(plate);
            for (int cellLineIdx = 0; cellLineIdx < this.dataset.getColumnCount(); ++cellLineIdx) {
                float plateUntreatedMedian = untreatedMediansPerPlateAndCellLine.getValue(plateIdx, cellLineIdx);
                int rows = rowIndicesForPlate.size();
                for (int i = 0; i < rows; ++i) {
                    int index = rowIndicesForPlate.getQuick(i);
                    array[index][cellLineIdx] = plateUntreatedMedian == 0.0f ? Float.NaN : array[index][cellLineIdx] / plateUntreatedMedian * 100.0f;
                }
            }
        }
        return untreatedMediansPerPlateAndCellLine;
    }

    private void computeZScoreAtEachConc() {
        int cellLineIdx;
        this.untreatedCellLineMeans = new float[this.cellLineCount];
        this.untreatedCellLineStdevs = new float[this.cellLineCount];
        this.nullDistributionForEachCellLine = new float[this.cellLineCount][];
        for (cellLineIdx = 0; cellLineIdx < this.cellLineCount; ++cellLineIdx) {
            TFloatArrayList nullDistributionList = new TFloatArrayList();
            for (Object plate : this.plateNames) {
                TIntArrayList rowIndices = (TIntArrayList)this.plateNameToRowIndices.get(plate);
                int rows = rowIndices.size();
                for (int i = 0; i < rows; ++i) {
                    int index = rowIndices.getQuick(i);
                    if (!PRISMCompoundProcessor.isUntreated(this.dataset, this.concentrationMetadataNames, index)) continue;
                    nullDistributionList.add(this.dataset.getValue(index, cellLineIdx));
                }
            }
            if (nullDistributionList.size() == 0) {
                throw new RuntimeException("No untreated data points found. Please ensure your dataset has entries with concentration=0.");
            }
            nullDistributionList.sort();
            float[] nullDistributionArray = nullDistributionList.toArray();
            this.nullDistributionForEachCellLine[cellLineIdx] = nullDistributionArray;
            float mean = new Mean().evaluate(new ArrayFloatList(nullDistributionArray));
            float stdev = new StandardDeviation().evaluate(new ArrayFloatList(nullDistributionArray));
            this.untreatedCellLineMeans[cellLineIdx] = mean;
            this.untreatedCellLineStdevs[cellLineIdx] = stdev;
        }
        this.zScoreAtEachConcentration = new RowMajorArray2DDataset("Z Scores", this.mergedCollapsedDataset.getRowCount(), this.mergedCollapsedDataset.getColumnCount());
        MetadataUtil.copy(this.mergedCollapsedDataset.getRowMetadata(), this.zScoreAtEachConcentration.getRowMetadata());
        for (cellLineIdx = 0; cellLineIdx < this.cellLineCount; ++cellLineIdx) {
            float stdev = this.untreatedCellLineStdevs[cellLineIdx];
            if (stdev == 0.0f) {
                stdev = 0.001f;
            }
            NormalDistribution normalDistribution = new NormalDistribution((double)this.untreatedCellLineMeans[cellLineIdx], (double)stdev);
            for (int drugIdx = 0; drugIdx < this.mergedCollapsedDataset.getRowCount(); ++drugIdx) {
                float value = this.mergedCollapsedDataset.getValue(drugIdx, cellLineIdx);
                this.zScoreAtEachConcentration.setValue(drugIdx, cellLineIdx, (float)(((double)value - normalDistribution.getMean()) / normalDistribution.getStandardDeviation()));
            }
        }
    }

    private ViewableGENEETreeNode createNode(List<ProjectGENEEResultTreeNode> results, Dataset datasets, String name, History history) {
        return this.createNode(results, datasets, name, null, history);
    }
}

