/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.luminex.ui.input;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.gui.parameters.MetadataCheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.luminex.ui.input.BackgroundSubstractionPanel;
import org.broadinstitute.genee.luminex.ui.input.CollapseReplicatesPanel;
import org.broadinstitute.genee.luminex.ui.input.FloorCeilingPanel;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;

public class InputPanel {
    private JCheckBox scaleToWellSignalFraction;
    private CollapseReplicatesPanel collapseReplicatesPanel;
    private JPanel processingOptionsPanel;
    private FormLayout formLayout;
    private BackgroundSubstractionPanel backgroundSubtractPanel;
    private FloorCeilingPanel thresholdPanel;
    private CellConstraints cc = new CellConstraints();
    private FloorCeilingPanel ceilingPanel;
    private InputParameter concentrationOrPuroMetadataInputField;
    private MetadataComboBoxInputParameter plateMetadataNameInputField;

    public InputPanel() {
        this.formLayout = new FormLayout("p", "");
        this.formLayout.setHonorsVisibility(true);
        this.processingOptionsPanel = new JPanel();
        this.processingOptionsPanel.setLayout((LayoutManager)this.formLayout);
        UIUtil.setDialogBorder(this.processingOptionsPanel);
    }

    public void addBackgroundSubtraction(Dataset dataset) {
        this.nextRow();
        this.backgroundSubtractPanel = new BackgroundSubstractionPanel(dataset);
        this.processingOptionsPanel.add((Component)this.backgroundSubtractPanel, this.cc.xy(1, this.formLayout.getRowCount()));
    }

    public void addCeilingTreated() {
        this.nextRow();
        this.ceilingPanel = new FloorCeilingPanel(false);
        this.processingOptionsPanel.add((Component)this.ceilingPanel, this.cc.xy(1, this.formLayout.getRowCount()));
    }

    public void addCollapseReplicates(Dataset dataset) {
        this.nextRow();
        this.collapseReplicatesPanel = new CollapseReplicatesPanel(dataset);
        this.processingOptionsPanel.add((Component)this.collapseReplicatesPanel, this.cc.xy(1, this.formLayout.getRowCount()));
    }

    public void addMetadataInputFields(Dataset dataset, boolean isCompound) {
        this.nextRow();
        FormBuilder fb = new FormBuilder();
        fb.nextRow();
        fb.addFirstColumn(new JLabel((isCompound ? "Concentration" : "Puro") + " annotation:"));
        if (!isCompound) {
            this.concentrationOrPuroMetadataInputField = new MetadataComboBoxInputParameter(true, Number.class);
            this.concentrationOrPuroMetadataInputField.init(new DefaultProject(dataset));
        } else {
            this.concentrationOrPuroMetadataInputField = new MetadataCheckBoxListParameter(true, Number.class);
            this.concentrationOrPuroMetadataInputField.init(new DefaultProject(dataset));
        }
        fb.add(this.concentrationOrPuroMetadataInputField.getJComponent());
        fb.nextRow();
        fb.addLabel("Plate annotation:");
        this.plateMetadataNameInputField = new MetadataComboBoxInputParameter(true);
        this.plateMetadataNameInputField.init(new DefaultProject(dataset));
        MetadataModel model = dataset.getRowMetadata();
        ArrayList<String> concentrationFields = new ArrayList<String>();
        int count = model.getMetadataCount();
        for (int i = 0; i < count; ++i) {
            String name = model.getColumnName(i).toLowerCase();
            if (name.contains("plate")) {
                this.plateMetadataNameInputField.setSelectedItem(name);
                continue;
            }
            if (!name.contains("conc")) continue;
            concentrationFields.add(name);
        }
        if (this.concentrationOrPuroMetadataInputField instanceof MetadataCheckBoxListParameter) {
            ((MetadataCheckBoxListParameter)this.concentrationOrPuroMetadataInputField).setSelection(concentrationFields.toArray());
        } else {
            ((MetadataComboBoxInputParameter)this.concentrationOrPuroMetadataInputField).setSelection(concentrationFields.toArray());
        }
        fb.add(this.plateMetadataNameInputField.getJComponent());
        this.processingOptionsPanel.add((Component)fb.getPanel(), this.cc.xy(1, this.formLayout.getRowCount()));
    }

    public void addScaleToWellSignalFraction() {
        this.nextRow();
        this.scaleToWellSignalFraction = new JCheckBox("Scale to well signal fraction (total = 1)", false);
        JPanel panel = new JPanel((LayoutManager)new FormLayout("pref", "pref"));
        panel.add((Component)this.scaleToWellSignalFraction, this.cc.xy(1, 1));
        this.processingOptionsPanel.add((Component)panel, this.cc.xy(1, this.formLayout.getRowCount()));
    }

    public void addThresholdTreated() {
        this.nextRow();
        this.thresholdPanel = new FloorCeilingPanel(true);
        this.processingOptionsPanel.add((Component)this.thresholdPanel, this.cc.xy(1, this.formLayout.getRowCount()));
    }

    public String getBackgroundSubtractMatchValue() {
        return this.backgroundSubtractPanel.getMatchValue();
    }

    public CollapseMethodOption getBackgroundSubtractionCollapseMethod() {
        return this.backgroundSubtractPanel.getMethod();
    }

    public BackgroundSubstractionPanel getBackgroundSubtractPanel() {
        return this.backgroundSubtractPanel;
    }

    public float getCeilingValue() {
        return this.ceilingPanel.getValue();
    }

    public CollapseMethodOption getCollapseReplicatesMethod() {
        return this.collapseReplicatesPanel.getCollapseMethod();
    }

    public int getCollapseReplicatesTrimmedMeanL() {
        return this.collapseReplicatesPanel.getTrimmedMeanL();
    }

    public int getCollapseReplicatesTrimmedMeanS() {
        return this.collapseReplicatesPanel.getTrimmedMeanS();
    }

    public String[] getConcentrationOrPuroMetadataFieldName() {
        Object val = this.concentrationOrPuroMetadataInputField.getParameterValue();
        if (val instanceof Object[]) {
            Object[] tmp = (Object[])val;
            String[] array = new String[tmp.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (String)tmp[i];
            }
            return array;
        }
        return new String[]{(String)val};
    }

    public FormLayout getFormLayout() {
        return this.formLayout;
    }

    public String getPlateMetadaFieldNameName() {
        return this.plateMetadataNameInputField.getParameterValue();
    }

    public MetadataComboBoxInputParameter getPlateMetadataNameInputField() {
        return this.plateMetadataNameInputField;
    }

    public JPanel getProcessingOptionsPanel() {
        return this.processingOptionsPanel;
    }

    public String[] getRowMetadataReplicateNames() {
        return this.collapseReplicatesPanel.getRowMetadataReplicateNames();
    }

    public int getSubtractBackgroundTrimmedMeanL() {
        return this.backgroundSubtractPanel.getTrimmedMeanL();
    }

    public int getSubtractBackgroundTrimmedMeanS() {
        return this.backgroundSubtractPanel.getTrimmedMeanS();
    }

    public float getThresholdValue() {
        return this.thresholdPanel.getValue();
    }

    public boolean isCeilingValues() {
        return this.ceilingPanel.isSelected();
    }

    public boolean isScaleToWellSignalFraction() {
        return this.scaleToWellSignalFraction.isSelected();
    }

    public boolean isSubtractBackground() {
        return this.backgroundSubtractPanel.isSubtractBackground();
    }

    public boolean isThresholdValues() {
        return this.thresholdPanel.isSelected();
    }

    public void nextRow() {
        this.formLayout.appendRow(UIUtil.decodeRowSpec("8px"));
        this.formLayout.appendRow(UIUtil.decodeRowSpec("pref"));
    }
}

