/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.mac;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class AppleScript {
    private static final String CMD = "/usr/bin/osascript";
    private static final String ARGS = "-ss";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runScript(String script) throws IOException {
        File file = AppleScript.save(script);
        try {
            Object object = AppleScript.runScript(file);
            return object;
        }
        finally {
            file.delete();
        }
    }

    public static void setSpotlightComment(String comment, File ... files) {
        try {
            StringBuilder sb = new StringBuilder();
            for (File file : files) {
                sb.append("set p to \"" + file.getCanonicalPath() + "\"\n");
                sb.append("set a to POSIX file p as alias\n");
                sb.append("tell application \"Finder\"\n");
                sb.append("if exists a then\n");
                sb.append("set comment of a to \"" + comment + "\"\n");
                sb.append("end if\n");
                sb.append("end tell\n");
            }
            AppleScript.runScript(sb.toString());
        }
        catch (Exception x) {
            System.err.println("Unable to set spotlight comment.");
        }
    }

    private static Object runScript(File f) throws IOException {
        int exit = 0;
        StringBuilder sbIS = new StringBuilder();
        StringBuilder sbES = new StringBuilder();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(CMD, ARGS, f.getAbsolutePath());
        Process p = pb.start();
        InputStream is = p.getInputStream();
        InputStream es = p.getErrorStream();
        while (true) {
            int isData = is.available() > 0 ? is.read() : -1;
            int esData = es.available() > 0 ? es.read() : -1;
            if (isData != -1) {
                sbIS.append(new Character((char)isData));
            }
            if (esData != -1) {
                sbES.append(new Character((char)esData));
            }
            if (isData != -1 || esData != -1) continue;
            try {
                exit = p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                continue;
            }
            break;
        }
        if (exit == 0) {
            return sbIS;
        }
        throw new IOException(sbES.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File save(String script) {
        File f = null;
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            f = File.createTempFile("jasconn_", ".scpt");
            fw = new FileWriter(f);
            bw = new BufferedWriter(fw);
            bw.write(script);
        }
        catch (Throwable thr) {
            f = null;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {}
            }
        }
        return f;
    }
}

