/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import java.math.BigInteger;
import org.broadinstitute.genee.marker.permutation.CombinationGenerator;
import org.broadinstitute.genee.marker.permutation.Permuter;

public class BalancedCompletePermuter
implements Permuter {
    CombinationGenerator comb1;
    CombinationGenerator comb2;
    int[] comb1Indices;
    int[] classZeroIndices;
    int[] classOneIndices;

    public BalancedCompletePermuter(int[] classZeroIndices, int[] classOneIndices) {
        this.classZeroIndices = classZeroIndices;
        this.classOneIndices = classOneIndices;
        this.comb1 = new CombinationGenerator(classOneIndices.length, classOneIndices.length / 2);
        this.comb2 = new CombinationGenerator(classOneIndices.length, classOneIndices.length / 2);
        this.comb1Indices = this.comb1.getNext();
    }

    public BigInteger getTotal() {
        return this.comb1.getTotal().multiply(this.comb2.getTotal());
    }

    @Override
    public int[] next() {
        int[] values = new int[this.classOneIndices.length * 2];
        for (int i = 0; i < this.comb1Indices.length; ++i) {
            values[this.classOneIndices[this.comb1Indices[i]]] = 1;
        }
        int[] indices = this.comb2.getNext();
        for (int i = 0; i < indices.length; ++i) {
            values[this.classZeroIndices[indices[i]]] = 1;
        }
        if (!this.comb2.hasMore()) {
            this.comb2.reset();
            if (this.comb1.hasMore()) {
                this.comb1Indices = this.comb1.getNext();
            }
        }
        return values;
    }
}

