/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import java.util.Random;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.marker.permutation.Permuter;

public class ContinuousRandomPermuter
implements Permuter {
    private int[] array;
    private Random rnd;
    private int n;

    public ContinuousRandomPermuter(int n, int seed) {
        this.array = IOUtil.seqInt(n);
        this.n = n;
        this.rnd = new Random(seed);
    }

    @Override
    public int[] next() {
        for (int i = this.n; i > 1; --i) {
            ContinuousRandomPermuter.swap(this.array, i - 1, this.rnd.nextInt(i));
        }
        return this.array;
    }

    private static void swap(int[] arr, int i, int j) {
        int tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }
}

