/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.marker.permutation;

import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.sampling.RandomSampler;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import org.broadinstitute.genee.marker.permutation.Permuter;

public class UnbalancedRandomPermuter
implements Permuter {
    MersenneTwister random;
    long[] values;
    int size;
    int numClassOne;

    public UnbalancedRandomPermuter(int size, int numClassOne, int seed) {
        this.random = new MersenneTwister(seed);
        this.size = size;
        this.numClassOne = numClassOne;
        this.values = new long[numClassOne];
    }

    @Override
    public int[] next() {
        int[] assignments = new int[this.size];
        RandomSampler.sample((long)this.numClassOne, (long)this.size, (int)this.numClassOne, (long)0L, (long[])this.values, (int)0, (RandomElement)this.random);
        for (int i = 0; i < this.values.length; ++i) {
            int classOneIndex = (int)this.values[i];
            assignments[classOneIndex] = 1;
        }
        return assignments;
    }

    static String toString(int[] a) {
        String s = "";
        for (int i = 0; i < a.length; ++i) {
            s = s + a[i];
        }
        return s;
    }
}

