/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat;

import com.google.common.base.Objects;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.math.stat.CollapseMethodOption;
import org.broadinstitute.genee.math.stat.MedianPolish;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.math.stat.function.Max;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.Median;
import org.broadinstitute.genee.math.stat.function.Min;
import org.broadinstitute.genee.math.stat.function.StandardDeviation;
import org.broadinstitute.genee.math.stat.function.TrimmedMean;
import org.broadinstitute.genee.math.stat.function.bivariate.PearsonCorrelation;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetRowView;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class CollapseDataset {
    private CollapseMethodOption collapseMethod = CollapseMethodOption.MAX;
    private Dataset dataset;
    private String[] collapseToFields;
    private int trimmedMeanL;
    private float minCorrelation = 0.6f;
    private boolean removeNulls = true;
    private boolean removeProbeSetsWithCorrelationLessThanMinCorrelation = false;
    private int trimmedMeanS;
    private List<Object> removeMinCorrelationSymbols;

    public CollapseDataset() {
    }

    public CollapseDataset(Dataset dataset, String[] collapseTo, CollapseMethodOption collapseMethodOption) {
        this.dataset = dataset;
        this.collapseToFields = collapseTo;
        this.collapseMethod = collapseMethodOption;
    }

    public Dataset execute() {
        int j;
        this.removeMinCorrelationSymbols = new ArrayList<Object>();
        Map<Identifier, TIntArrayList> collapseToFieldsToDatasetRowIndices = VectorUtil.createValuesToIndicesMap(MetadataUtil.getVectors(this.dataset.getRowMetadata(), this.collapseToFields));
        if (this.removeProbeSetsWithCorrelationLessThanMinCorrelation) {
            PearsonCorrelation function = new PearsonCorrelation();
            DatasetRowView list1 = new DatasetRowView(this.dataset);
            DatasetRowView list2 = new DatasetRowView(this.dataset);
            Iterator<Identifier> it = collapseToFieldsToDatasetRowIndices.keySet().iterator();
            while (it.hasNext()) {
                Identifier collapseToValue = it.next();
                TIntArrayList indices = collapseToFieldsToDatasetRowIndices.get(collapseToValue);
                boolean passed = false;
                int length = indices.size();
                block1: for (int i = 0; i < length && !passed; ++i) {
                    int index = indices.getQuick(i);
                    list1.setIndex(index);
                    for (j = 0; j < i; ++j) {
                        int index2 = indices.getQuick(j);
                        list2.setIndex(index2);
                        float corr = function.evaluate(list1, list2);
                        if (!(corr >= this.minCorrelation)) continue;
                        passed = true;
                        continue block1;
                    }
                }
                if (indices.size() <= 1 || passed) continue;
                this.removeMinCorrelationSymbols.add(collapseToValue);
                it.remove();
            }
        }
        int columns = this.dataset.getColumnCount();
        RowMajorArray2DDataset collapsedDataset = new RowMajorArray2DDataset("Collapsed", collapseToFieldsToDatasetRowIndices.size(), columns);
        int rowIndex = 0;
        if (this.collapseMethod != CollapseMethodOption.TRIMMED_MEAN) {
            this.trimmedMeanS = 0;
            this.trimmedMeanL = 0;
        }
        for (Identifier collapseToValue : collapseToFieldsToDatasetRowIndices.keySet()) {
            TIntArrayList rowIndices = collapseToFieldsToDatasetRowIndices.get(collapseToValue);
            int nrows = rowIndices.size();
            if (nrows == 1) {
                int index = rowIndices.getQuick(0);
                for (int j2 = 0; j2 < columns; ++j2) {
                    collapsedDataset.setValue(rowIndex, j2, this.dataset.getValue(index, j2));
                }
            } else if (this.collapseMethod == CollapseMethodOption.MEDIAN_POLISH) {
                float[][] array = new float[nrows][columns];
                for (int i = 0; i < nrows; ++i) {
                    int index = rowIndices.getQuick(i);
                    for (j = 0; j < columns; ++j) {
                        float value;
                        array[i][j] = value = this.dataset.getValue(index, j);
                    }
                }
                float[] r = MedianPolish.medianPolish(new RowMajorArray2DDataset("", array));
                for (int j3 = 0; j3 < columns; ++j3) {
                    collapsedDataset.setValue(rowIndex, j3, r[j3]);
                }
            } else if (this.collapseMethod == CollapseMethodOption.MAX_AVERAGE_PROBE || this.collapseMethod == CollapseMethodOption.MAX_MEDIAN_PROBE) {
                FloatListFunction stat = this.collapseMethod == CollapseMethodOption.MAX_AVERAGE_PROBE ? new Mean() : new Median();
                float[] array = new float[columns];
                ArrayFloatList list = new ArrayFloatList(array);
                int probeIndex = -1;
                float max = -3.4028235E38f;
                for (int i = 0; i < nrows; ++i) {
                    int index = rowIndices.getQuick(i);
                    for (int j4 = 0; j4 < columns; ++j4) {
                        float d;
                        array[j4] = d = this.dataset.getValue(index, j4);
                    }
                    float meanOrMedian = stat.evaluate(list);
                    if (!(meanOrMedian > max)) continue;
                    max = meanOrMedian;
                    probeIndex = index;
                }
                for (int j5 = 0; j5 < columns; ++j5) {
                    collapsedDataset.setValue(rowIndex, j5, this.dataset.getValue(probeIndex, j5));
                }
                rowIndices.clear();
                rowIndices.add(probeIndex);
            } else {
                FloatListFunction function;
                if (this.collapseMethod == CollapseMethodOption.MEAN) {
                    function = new Mean();
                } else if (this.collapseMethod == CollapseMethodOption.MEDIAN) {
                    function = new Median();
                } else if (this.collapseMethod == CollapseMethodOption.MAX) {
                    function = new Max();
                } else if (this.collapseMethod == CollapseMethodOption.MIN) {
                    function = new Min();
                } else if (this.collapseMethod == CollapseMethodOption.TRIMMED_MEAN) {
                    function = new TrimmedMean(this.trimmedMeanS, this.trimmedMeanL);
                } else if (this.collapseMethod == CollapseMethodOption.STANDARD_DEVIATION) {
                    function = new StandardDeviation();
                } else {
                    throw new RuntimeException();
                }
                float[] array = new float[nrows];
                ArrayFloatList list = new ArrayFloatList(array);
                for (j = 0; j < columns; ++j) {
                    for (int i = 0; i < nrows; ++i) {
                        float d;
                        int index = rowIndices.getQuick(i);
                        array[i] = d = this.dataset.getValue(index, j);
                    }
                    float value = function.evaluate(list);
                    collapsedDataset.setValue(rowIndex, j, value);
                }
            }
            ++rowIndex;
        }
        MetadataUtil.copy(this.dataset.getColumnMetadata(), collapsedDataset.getColumnMetadata());
        CollapseDataset.setMetadata(this.dataset.getRowMetadata(), collapsedDataset.getRowMetadata(), this.collapseToFields, collapseToFieldsToDatasetRowIndices);
        return collapsedDataset;
    }

    public static void setMetadata(MetadataModel sourceMetadata, MetadataModel collapsedMetadata, String[] collapseToFields, Map<Identifier, TIntArrayList> collapseToFieldsToDatasetRowIndices) {
        for (int i = 0; i < sourceMetadata.getMetadataCount(); ++i) {
            Vector v = sourceMetadata.get(i);
            Vector dest = collapsedMetadata.add(v.getName(), v.getColumnClass());
            VectorUtil.copyProperties(v, dest);
        }
        int collapseDatasetRowIndex = 0;
        HashSet<String> collapseToFieldsSet = new HashSet<String>(Arrays.asList(collapseToFields));
        ArrayList<String> allFields = new ArrayList<String>(MetadataUtil.getNames(collapsedMetadata));
        for (Identifier collapseToValue : collapseToFieldsToDatasetRowIndices.keySet()) {
            TIntArrayList indices = collapseToFieldsToDatasetRowIndices.get(collapseToValue);
            int nfields = allFields.size();
            for (int i = 0; i < nfields; ++i) {
                String field = (String)allFields.get(i);
                int index0 = indices.getQuick(0);
                Vector sourceVector = sourceMetadata.get(field);
                Object value = sourceVector.getValue(index0);
                int collapsedIdx = collapsedMetadata.getColumnIndex(field);
                if (collapsedIdx == -1) continue;
                if (collapseToFieldsSet.contains(sourceVector.getName())) {
                    collapsedMetadata.get(collapsedIdx).setValue(collapseDatasetRowIndex, value);
                    continue;
                }
                boolean same = true;
                int nindices = indices.size();
                for (int n = 0; n < nindices; ++n) {
                    Object testValue = sourceVector.getValue(indices.getQuick(n));
                    if (Objects.equal((Object)value, (Object)testValue)) continue;
                    same = false;
                    break;
                }
                if (same) {
                    collapsedMetadata.get(collapsedIdx).setValue(collapseDatasetRowIndex, value);
                    continue;
                }
                collapsedMetadata.remove(collapsedIdx);
                allFields.remove(i);
                --i;
                --nfields;
            }
            ++collapseDatasetRowIndex;
        }
        if (collapsedMetadata.getMetadataCount() == 0) {
            Vector ids = MetadataUtil.addRowVector(collapsedMetadata, "Id", String.class);
            int size = ids.size();
            for (int i = 0; i < size; ++i) {
                ids.setValue(i, "" + (i + 1));
            }
        }
    }

    public CollapseMethodOption getCollapseMethod() {
        return this.collapseMethod;
    }

    public float getMinCorrelation() {
        return this.minCorrelation;
    }

    public List<Object> getRemoveMinCorrelationSymbols() {
        return this.removeMinCorrelationSymbols;
    }

    public boolean isRemoveNulls() {
        return this.removeNulls;
    }

    public boolean isRemoveProbeSetsWithCorrelationLessThanMinCorrelation() {
        return this.removeProbeSetsWithCorrelationLessThanMinCorrelation;
    }

    public void setCollapseMethod(CollapseMethodOption collapseMethod) {
        this.collapseMethod = collapseMethod;
    }

    public void setCollapseTo(String[] collapseTo) {
        this.collapseToFields = collapseTo;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public void setMinCorrelation(float minCorrelation) {
        this.minCorrelation = minCorrelation;
    }

    public void setRemoveNulls(boolean removeNulls) {
        this.removeNulls = removeNulls;
    }

    public void setRemoveProbeSetsWithCorrelationLessThanMinCorrelation(boolean removeProbeSetsWithCorrelationLessThanMinCorrelation) {
        this.removeProbeSetsWithCorrelationLessThanMinCorrelation = removeProbeSetsWithCorrelationLessThanMinCorrelation;
    }

    public void setTrimmedMean(int s, int l) {
        this.trimmedMeanS = s;
        this.trimmedMeanL = l;
    }

    public void setTrimmedMeanL(int l) {
        this.trimmedMeanL = l;
    }

    public void setTrimmedMeanS(int s) {
        this.trimmedMeanS = s;
    }
}

