/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat;

import org.broadinstitute.genee.math.FloatListStatUtils;
import org.broadinstitute.genee.matrix.ArrayFloatList;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetColumnView;
import org.broadinstitute.genee.matrix.DatasetRowView;

public class MedianPolish {
    public static float[] medianPolish(Dataset z) {
        return MedianPolish.medianPolish(z, 0.01f, 10);
    }

    public static float[] medianPolish(Dataset z, float eps, int maxiter) {
        int j;
        int rows = z.getRowCount();
        int cols = z.getColumnCount();
        float oldsum = 0.0f;
        float newsum = 0.0f;
        float t = 0.0f;
        float[] rdelta = new float[rows];
        float[] cdelta = new float[cols];
        float[] r = new float[rows];
        float[] c = new float[cols];
        float[] result = new float[cols];
        for (int iter = 1; iter <= maxiter; ++iter) {
            int i;
            MedianPolish.getRowMedian(z, rdelta);
            MedianPolish.subtractByRow(z, rdelta);
            for (i = 0; i < rows; ++i) {
                r[i] = r[i] + rdelta[i];
            }
            float delta = FloatListStatUtils.percentile(new ArrayFloatList(c), 50);
            for (j = 0; j < cols; ++j) {
                c[j] = c[j] - delta;
            }
            t += delta;
            MedianPolish.getColMedian(z, cdelta);
            MedianPolish.subtractByCol(z, cdelta);
            for (j = 0; j < cols; ++j) {
                c[j] = c[j] + cdelta[j];
            }
            delta = FloatListStatUtils.percentile(new ArrayFloatList(r), 50);
            for (i = 0; i < rows; ++i) {
                r[i] = r[i] - delta;
            }
            t += delta;
            newsum = MedianPolish.sumAbs(z);
            if ((double)newsum == 0.0 || Math.abs(1.0 - (double)(oldsum / newsum)) < (double)eps) break;
            oldsum = newsum;
        }
        for (j = 0; j < cols; ++j) {
            result[j] = t + c[j];
        }
        return result;
    }

    private static void getColMedian(Dataset z, float[] cdelta) {
        DatasetColumnView view = new DatasetColumnView(z);
        int cols = z.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            view.setIndex(j);
            cdelta[j] = FloatListStatUtils.percentile(view, 50);
        }
    }

    private static void getRowMedian(Dataset z, float[] rdelta) {
        DatasetRowView view = new DatasetRowView(z);
        int rows = z.getRowCount();
        for (int i = 0; i < rows; ++i) {
            view.setIndex(i);
            rdelta[i] = FloatListStatUtils.percentile(view, 50);
        }
    }

    private static void subtractByCol(Dataset z, float[] cdelta) {
        int rows = z.getRowCount();
        int cols = z.getColumnCount();
        for (int j = 0; j < cols; ++j) {
            for (int i = 0; i < rows; ++i) {
                z.setValue(i, j, z.getValue(i, j) - cdelta[j]);
            }
        }
    }

    private static void subtractByRow(Dataset z, float[] rdelta) {
        int rows = z.getRowCount();
        int cols = z.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                z.setValue(i, j, z.getValue(i, j) - rdelta[i]);
            }
        }
    }

    private static float sumAbs(Dataset z) {
        float sum = 0.0f;
        int rows = z.getRowCount();
        int cols = z.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                sum += Math.abs(z.getValue(i, j));
            }
        }
        return sum;
    }
}

