/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function;

import gnu.trove.list.array.TFloatArrayList;
import org.broadinstitute.genee.math.stat.function.FloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class Percentile
implements FloatListFunction {
    private float p;

    public Percentile() {
        this.setQuantile(50.0f);
    }

    @Override
    public float evaluate(FloatList values) {
        return Percentile.percentileRemoveNans(values, this.p);
    }

    public void setQuantile(float p) {
        if (p > 100.0f || p <= 0.0f) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        this.p = p;
    }

    public static float percentile(TFloatArrayList values, float p) {
        int length = values.size();
        if (length == 0) {
            return Float.NaN;
        }
        if (length == 1) {
            return values.get(0);
        }
        float n = length;
        float pos = p * (n + 1.0f) / 100.0f;
        float fpos = (float)Math.floor(pos);
        int intPos = (int)fpos;
        float dif = pos - fpos;
        values.sort();
        if (pos < 1.0f) {
            return values.getQuick(0);
        }
        if (pos >= n) {
            return values.getQuick(length - 1);
        }
        float lower = values.getQuick(intPos - 1);
        float upper = values.getQuick(intPos);
        return lower + dif * (upper - lower);
    }

    public static float percentileRemoveNans(FloatList values, float p) {
        TFloatArrayList sorted = new TFloatArrayList(values.size());
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            float value = values.getValue(i);
            if (Float.isNaN(value)) continue;
            sorted.add(value);
        }
        return Percentile.percentile(sorted, p);
    }
}

