/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class PearsonCorrelation
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList listOne, FloatList listTwo) {
        float sumx = 0.0f;
        float sumxx = 0.0f;
        float sumy = 0.0f;
        float sumyy = 0.0f;
        float sumxy = 0.0f;
        int N = 0;
        int size = listOne.size();
        for (int i = 0; i < size; ++i) {
            float x = listOne.getValue(i);
            float y = listTwo.getValue(i);
            if (Float.isNaN(x) || Float.isNaN(y)) continue;
            sumx += x;
            sumxx += x * x;
            sumy += y;
            sumyy += y * y;
            sumxy += x * y;
            ++N;
        }
        float numr = sumxy - sumx * sumy / (float)N;
        float denr = (float)Math.sqrt((sumxx - sumx * sumx / (float)N) * (sumyy - sumy * sumy / (float)N));
        return numr / denr;
    }

    public String toString() {
        return "Pearson correlation";
    }
}

