/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.math.stat.function.bivariate;

import gnu.trove.list.array.TFloatArrayList;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Spearman;
import org.broadinstitute.genee.math.stat.function.bivariate.BivariateFloatListFunction;
import org.broadinstitute.genee.matrix.FloatList;

public class SpearmanCorrelation
implements BivariateFloatListFunction {
    @Override
    public float evaluate(FloatList data1, FloatList data2) {
        int i;
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException("Size of lists must be equal.");
        }
        float result = 0.0f;
        float denom1 = 0.0f;
        float denom2 = 0.0f;
        int n = data1.size();
        TFloatArrayList tdata1 = new TFloatArrayList();
        TFloatArrayList tdata2 = new TFloatArrayList();
        for (i = 0; i < n; ++i) {
            float term1 = data1.getValue(i);
            float term2 = data2.getValue(i);
            if (Float.isNaN(term1) || Float.isNaN(term2)) continue;
            tdata1.add(term1);
            tdata2.add(term2);
        }
        int m = tdata1.size();
        if (m == 0) {
            return 0.0f;
        }
        float[] rank1 = Spearman.getrank(tdata1);
        float[] rank2 = Spearman.getrank(tdata2);
        float avgrank = 0.5f * (float)(m - 1);
        for (i = 0; i < m; ++i) {
            float value1 = rank1[i];
            float value2 = rank2[i];
            result += value1 * value2;
            denom1 += value1 * value1;
            denom2 += value2 * value2;
        }
        result /= (float)m;
        denom1 /= (float)m;
        denom2 /= (float)m;
        result -= avgrank * avgrank;
        denom1 -= avgrank * avgrank;
        denom2 -= avgrank * avgrank;
        if (denom1 <= 0.0f) {
            return 1.0f;
        }
        if (denom2 <= 0.0f) {
            return 1.0f;
        }
        result = (float)((double)result / Math.sqrt(denom1 * denom2));
        return result;
    }

    public String toString() {
        return "Spearman rank correlation";
    }
}

