/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;

public abstract class AbstractMetadataModel
implements MetadataModel {
    private Map<String, Integer> columnNameToIndex = new HashMap<String, Integer>();
    private List<Vector> vectors = new ArrayList<Vector>();

    protected AbstractMetadataModel() {
    }

    @Override
    public Vector add(String name, Class<?> c) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (c == null) {
            throw new NullPointerException("Class is null");
        }
        Vector vector = this.createVector(name, c);
        this.add(vector);
        return vector;
    }

    @Override
    public Vector get(int columnIndex) {
        return this.vectors.get(columnIndex);
    }

    @Override
    public Vector get(String name) {
        int index = this.getColumnIndex(name);
        return index == -1 ? null : this.vectors.get(index);
    }

    public Class<?> getColumnClass(int columnIndex) {
        return this.vectors.get(columnIndex).getColumnClass();
    }

    @Override
    public int getColumnIndex(String name) {
        Integer index = this.columnNameToIndex.get(name);
        return index != null ? index : -1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.vectors.get(columnIndex).getName();
    }

    @Override
    public int getMetadataCount() {
        return this.vectors.size();
    }

    @Override
    public Object getValue(int rowIndex, int columnIndex) {
        Vector metadataColumn = this.vectors.get(columnIndex);
        return metadataColumn.getValue(rowIndex);
    }

    @Override
    public Object getValue(int rowIndex, String column) {
        Integer columnIndex = this.columnNameToIndex.get(column);
        if (columnIndex == null) {
            throw new IllegalArgumentException("Column " + column + " not found.");
        }
        return this.getValue(rowIndex, columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Vector metadataColumn = this.vectors.get(columnIndex);
        return metadataColumn.getValue(rowIndex);
    }

    @Override
    public void remove(int index) {
        this.vectors.remove(index);
        this.rebuildMap();
    }

    @Override
    public void setValue(int rowIndex, int columnIndex, Object value) {
        Vector metadataColumn = this.vectors.get(columnIndex);
        metadataColumn.setValue(rowIndex, value);
    }

    @Override
    public void setValue(int rowIndex, String name, Object value) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        Integer columnIndex = this.columnNameToIndex.get(name);
        if (columnIndex == null) {
            StringBuilder buf = new StringBuilder();
            int cols = this.getMetadataCount();
            for (int j = 0; j < cols; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(this.vectors.get(j).getName());
            }
            throw new NullPointerException("No column named '" + name + "' found. Column names are: " + buf.toString());
        }
        this.setValue(rowIndex, columnIndex, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            int mcount = this.getMetadataCount();
            for (int j = 0; j < mcount; ++j) {
                if (j > 0) {
                    buf.append("\t");
                }
                Object value = this.get(j).getValue(i);
                buf.append(Formatter.toString(value));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    protected void add(Vector vector) {
        if (this.columnNameToIndex.containsKey(vector.getName())) {
            int existingIndex = this.columnNameToIndex.get(vector.getName());
            this.vectors.remove(existingIndex);
            this.columnNameToIndex.remove(vector.getName());
            this.rebuildMap();
        }
        this.vectors.add(vector);
        this.columnNameToIndex.put(vector.getName(), this.vectors.size() - 1);
    }

    protected abstract Vector createVector(String var1, Class<?> var2);

    private void rebuildMap() {
        this.columnNameToIndex.clear();
        int size = this.vectors.size();
        for (int i = 0; i < size; ++i) {
            this.columnNameToIndex.put(this.vectors.get(i).getName(), i);
        }
    }
}

