/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.AbstractDatasetView;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class DatasetColumnView
extends AbstractDatasetView {
    public DatasetColumnView(Dataset dataset) {
        super(dataset);
    }

    public DatasetColumnView(Dataset dataset, int[] rowIndices) {
        super(dataset, rowIndices);
    }

    @Override
    public float getValue(int rowIndex) {
        return this.indices == null ? this.dataset.getValue(rowIndex, this.index) : this.dataset.getValue(this.indices[rowIndex], this.index);
    }

    @Override
    public Object getObjectValue(int rowIndex, int seriesIndex) {
        return this.indices == null ? this.dataset.getObjectValue(rowIndex, this.index, seriesIndex) : this.dataset.getObjectValue(this.indices[rowIndex], this.index, seriesIndex);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName(int i) {
        return ToStringUtil.toString(this.dataset.getColumnMetadata(), i);
    }

    @Override
    public void setValue(int rowIndex, float value) {
        RowMajorArray2DDataset d = (RowMajorArray2DDataset)this.dataset;
        if (this.indices == null) {
            d.setValue(rowIndex, this.index, value);
        } else {
            d.setValue(this.indices[rowIndex], this.index, value);
        }
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int size() {
        return this.indices == null ? this.dataset.getRowCount() : this.indices.length;
    }
}

