/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.AbstractVector;

public class DefaultVector
extends AbstractVector {
    private Object[] array;

    public DefaultVector(String columnName, Class<?> c, int size) {
        super(columnName, c);
        this.array = new Object[size];
    }

    public DefaultVector(String columnName, Class<?> c, Object[] array) {
        super(columnName, c);
        this.array = array;
    }

    public DefaultVector(String columnName, Object obj) {
        super(columnName, String.class);
        this.array = DefaultVector.createArray(obj);
        int length = this.array.length;
        for (int i = 0; i < length; ++i) {
            if (this.array[i] == null) continue;
            this.setColumnClass(this.array[i].getClass());
            break;
        }
    }

    @Override
    public Object getValue(int index) {
        return this.array[index];
    }

    @Override
    public void setValue(int rowIndex, Object value) {
        this.array[rowIndex] = value;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    private static Object[] createArray(Object obj) {
        Object[] array = null;
        if (obj instanceof double[]) {
            double[] tmp = (double[])obj;
            array = new Object[tmp.length];
            int length = tmp.length;
            for (int i = 0; i < length; ++i) {
                array[i] = tmp[i];
            }
        } else if (obj instanceof String[]) {
            String[] tmp = (String[])obj;
            array = new Object[tmp.length];
            for (Object array[i] : tmp) {
            }
        } else if (obj instanceof int[]) {
            int[] tmp = (int[])obj;
            array = new Object[tmp.length];
            int length = tmp.length;
            for (int i = 0; i < length; ++i) {
                array[i] = tmp[i];
            }
        } else if (obj instanceof boolean[]) {
            boolean[] tmp = (boolean[])obj;
            array = new Object[tmp.length];
            int length = tmp.length;
            for (int i = 0; i < length; ++i) {
                array[i] = tmp[i];
            }
        } else {
            System.err.println("Unknown type: " + obj.getClass());
        }
        return array;
    }
}

