/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import org.broadinstitute.genee.matrix.AbstractDataset;
import org.broadinstitute.genee.matrix.DefaultMetadataModel;
import org.broadinstitute.genee.matrix.MetadataModel;

public abstract class FixedSizeAbstractDataset
extends AbstractDataset {
    protected MetadataModel columnMetadata;
    protected int columns;
    protected MetadataModel rowMetadata;
    protected int rows;

    protected FixedSizeAbstractDataset(String name, int rows, int columns) {
        this.name = name;
        this.rows = rows;
        this.columns = columns;
        this.rowMetadata = new DefaultMetadataModel(rows);
        this.columnMetadata = new DefaultMetadataModel(columns);
    }

    public int addSeries(String name, Object[][] values, Class<?> c) {
        this.seriesNames.add(name);
        this.seriesClasses.add(c);
        this.matrices.add(new ObjectMatrix(values));
        return this.seriesNames.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public MetadataModel getColumnMetadata() {
        return this.columnMetadata;
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public MetadataModel getRowMetadata() {
        return this.rowMetadata;
    }

    public void setColumnMetadata(MetadataModel metadata) {
        if (metadata.getItemCount() != this.getColumnCount()) {
            throw new IllegalArgumentException("Wrong number of items.");
        }
        this.columnMetadata = metadata;
    }

    public void setRowMetadata(MetadataModel metadata) {
        if (metadata.getItemCount() != this.getRowCount()) {
            throw new IllegalArgumentException("Wrong number of items.");
        }
        this.rowMetadata = metadata;
    }

    @Override
    protected AbstractDataset.Matrix createMatrix() {
        return new ObjectMatrix(this.getRowCount(), this.getColumnCount());
    }

    static class ObjectMatrix
    implements AbstractDataset.Matrix {
        private Object[][] matrix;

        public ObjectMatrix(Object[][] values) {
            this.matrix = values;
        }

        private ObjectMatrix(int rows, int columns) {
            this.matrix = new Object[rows][columns];
        }

        @Override
        public Object get(int row, int column) {
            return this.matrix[row][column];
        }

        @Override
        public void set(int row, int column, Object value) {
            this.matrix[row][column] = value;
        }
    }
}

