/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;
import org.broadinstitute.genee.matrix.Vector;

public class GEOSeriesParser {
    private BufferedReader br;
    private Map<String, String[]> categoryToValues = new HashMap<String, String[]>();
    private Dataset dataset;
    private String[] platformHeaders;
    private String[] rowIds;
    private Map<String, Integer> rowIdToIndex;
    private String[] sampleIds;
    private HashMap<String, Integer> sampleIdToIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GEOSeriesParser(String file, boolean headerOnly) throws IOException {
        try {
            this.br = new BufferedReader(new InputStreamReader(IOUtil.getInputStream(file)));
            this.parsePlatformTable(IOUtil.getName(file));
            if (!headerOnly) {
                while (this.parseSamples()) {
                }
            }
        }
        finally {
            this.close();
        }
    }

    public Project createProject() {
        DefaultProject p = new DefaultProject(this.dataset);
        for (String category : this.categoryToValues.keySet()) {
            Vector v = MetadataUtil.addColumnVector(p.getOriginalDataset().getColumnMetadata(), category, String.class);
            String[] values = this.categoryToValues.get(category);
            int cols = this.dataset.getColumnCount();
            for (int j = 0; j < cols; ++j) {
                String value = values[j];
                v.setValue(j, value);
            }
        }
        return p;
    }

    public String[] getSampleIds() {
        return this.sampleIds;
    }

    private void close() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void parsePlatformTable(String name) throws IOException {
        int i;
        int i2;
        String s;
        ArrayList<String> sampleIdList = new ArrayList<String>();
        int rows = 0;
        while ((s = this.br.readLine()) != null) {
            if (s.startsWith("!Platform_data_row_count")) {
                rows = Integer.parseInt(s.substring(s.indexOf(61) + 1).trim());
                continue;
            }
            if (s.startsWith("!Series_sample_id")) {
                String sampleId = s.substring(s.indexOf(61) + 1).trim();
                sampleIdList.add(sampleId);
                continue;
            }
            if (!s.startsWith("!platform_table_begin")) continue;
        }
        this.sampleIds = new String[sampleIdList.size()];
        this.sampleIdToIndex = new HashMap();
        int cols = sampleIdList.size();
        for (int j = 0; j < cols; ++j) {
            String id;
            this.sampleIds[j] = id = (String)sampleIdList.get(j);
            this.sampleIdToIndex.put(id, j);
        }
        String header = this.br.readLine();
        this.platformHeaders = IOUtil.split(header);
        String[] tokens = new String[this.platformHeaders.length];
        this.rowIds = new String[rows];
        for (i2 = 0; i2 < rows; ++i2) {
            s = this.br.readLine();
            IOUtil.split(s, tokens, '\t');
            this.rowIds[i2] = tokens[0];
        }
        this.rowIdToIndex = new HashMap<String, Integer>();
        int size = this.rowIds.length;
        for (i2 = 0; i2 < size; ++i2) {
            this.rowIdToIndex.put(this.rowIds[i2], i2);
        }
        this.dataset = new RowMajorArray2DDataset(name, this.rowIds.length, this.sampleIds.length);
        DatasetUtil.fill(this.dataset, Float.NaN);
        Vector v = MetadataUtil.addRowVector(this.dataset.getRowMetadata(), "Id", String.class);
        int nrows = this.dataset.getRowCount();
        for (i = 0; i < nrows; ++i) {
            v.setValue(i, this.rowIds[i]);
        }
        v = MetadataUtil.addRowVector(this.dataset.getColumnMetadata(), "Id", String.class);
        int ncols = this.dataset.getColumnCount();
        for (i = 0; i < ncols; ++i) {
            v.setValue(i, this.sampleIds[i]);
        }
    }

    private boolean parseSamples() throws IOException {
        String s;
        boolean sampleFound = false;
        while ((s = this.br.readLine()) != null) {
            if (!s.startsWith("^SAMPLE")) continue;
            sampleFound = true;
            break;
        }
        if (!sampleFound) {
            return false;
        }
        String sampleId = s.substring(s.indexOf(61) + 1).trim();
        int sampleColumnIndex = this.sampleIdToIndex.get(sampleId);
        while (!(s = this.br.readLine()).startsWith("!sample_table_begin")) {
            String value;
            String text;
            int cIndex;
            if (!s.startsWith("!Sample_characteristics") || (cIndex = (text = s.substring(s.indexOf(61) + 1)).indexOf(58)) == -1) continue;
            String category = text.substring(0, cIndex).trim();
            String[] array = this.categoryToValues.get(category);
            if (array == null) {
                array = new String[this.dataset.getColumnCount()];
                this.categoryToValues.put(category, array);
            }
            array[sampleColumnIndex] = value = text.substring(cIndex).trim();
        }
        String sampleTableHeader = this.br.readLine();
        String[] header = IOUtil.split(sampleTableHeader);
        String[] tokens = new String[header.length];
        int rows = this.dataset.getRowCount();
        for (int i = 0; i < rows; ++i) {
            s = this.br.readLine();
            IOUtil.split(s, tokens, '\t');
            String rowId = tokens[0];
            Integer rowIndex = this.rowIdToIndex.get(rowId);
            if (rowId.equals("!sample_table_end")) break;
            if (rowIndex == null) {
                throw new IOException("Identifier " + rowId + " not found.");
            }
            this.dataset.setValue(rowIndex, sampleColumnIndex, ParserHelper.parseFloatNaN(tokens[1]));
        }
        return true;
    }
}

