/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix;

import chemaxon.struc.Molecule;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.net.URL;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.AbstractDatasetView;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataModelColumnView;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class MetadataUtil {
    public static final String CHART_COLOR_ENABLED_KEY = "Chart Color Enabled";
    public static final String CHART_COLOR_KEY = "Chart Color";
    public static final String CHART_STYLE_KEY = "Chart Style";
    public static final int STYLE_BARS = 64;
    public static final int STYLE_LINES = 2;
    public static final int STYLE_POINTS = 4;
    public static final int STYLE_RANGE_HORIZONTAL = 8;
    public static final String COLOR_VISIBLE_KEY = "Color Visible";
    public static final String DISCRETE_KEY = "Discrete Key";
    public static final String TEXT_COLOR_VISIBLE_KEY = "Text Color Visible";
    public static final String TEXT_VISIBLE_KEY = "Text Visible";
    public static final String TOOLTIP_VISIBLE_KEY = "Tooltip Visible";
    private static final Set<String> DEFAULT_METADATA_HIDE_ALL = new HashSet<String>(Arrays.asList("array id", "gene id"));
    private static final Set<String> DEFAULT_METADATA_TEXT = new HashSet<String>(Arrays.asList("id", "Id", "Name", "ID", "pert_desc", "pert_dose", "pert_dose_unit", "pert_time", "pert_time_unit", "baseline_expr_log2"));

    private MetadataUtil() {
    }

    public static Vector addColumnVector(MetadataModel model, String name, Class<?> c) {
        Vector v = model.add(name, c);
        v.setProperty(TOOLTIP_VISIBLE_KEY, true);
        if (Number.class.isAssignableFrom(c)) {
            v.setProperty(CHART_STYLE_KEY, 64);
            v.setProperty(CHART_COLOR_ENABLED_KEY, true);
        } else {
            v.setProperty(COLOR_VISIBLE_KEY, true);
        }
        return v;
    }

    public static Vector addRowVector(MetadataModel model, String name, Class<?> c) {
        Vector v = model.add(name, c);
        v.setProperty(TOOLTIP_VISIBLE_KEY, true);
        v.setProperty(TEXT_VISIBLE_KEY, true);
        return v;
    }

    public static void addVectors(MetadataModel srcModel, MetadataModel destModel, String[] fields) {
        for (String field : fields) {
            Vector src = srcModel.get(field);
            Vector copy = destModel.add(field, src.getColumnClass());
            copy.setComparator(src.getComparator());
            VectorUtil.copyProperties(src, copy);
        }
    }

    public static List<Vector> asList(final MetadataModel model) {
        return new AbstractList<Vector>(){

            @Override
            public Vector get(int index) {
                return model.get(index);
            }

            @Override
            public int size() {
                return model.getMetadataCount();
            }
        };
    }

    public static void copy(MetadataModel src, MetadataModel dest) {
        int j;
        if (src.getItemCount() != dest.getItemCount()) {
            throw new IllegalArgumentException("Item count not equal in source and destination. " + src.getItemCount() + " != " + dest.getItemCount());
        }
        int itemCount = src.getItemCount();
        int metadataColumns = src.getMetadataCount();
        for (j = 0; j < metadataColumns; ++j) {
            Vector srcColumn = src.get(j);
            dest.add(src.getColumnName(j), src.get(j).getColumnClass());
            int destColumnIndex = dest.getColumnIndex(src.getColumnName(j));
            Vector destColumn = dest.get(destColumnIndex);
            MetadataUtil.copyProperties(srcColumn, destColumn);
        }
        for (j = 0; j < metadataColumns; ++j) {
            int destColumnIndex = dest.getColumnIndex(src.getColumnName(j));
            int srcColumnIndex = src.getColumnIndex(src.getColumnName(j));
            for (int i = 0; i < itemCount; ++i) {
                dest.setValue(i, destColumnIndex, src.getValue(i, srcColumnIndex));
            }
        }
    }

    public static void copyProperties(Vector srcColumn, Vector destColumn) {
        Collection<Object> keys = srcColumn.getPropertyKeys();
        for (Object key : keys) {
            destColumn.setProperty(key, srcColumn.getProperty(key));
        }
        destColumn.setComparator(srcColumn.getComparator());
    }

    public static String createUniqueName(MetadataModel metadata, String name) {
        int counter = 1;
        String uniqueName = name;
        while (metadata.getColumnIndex(uniqueName) != -1) {
            uniqueName = name + "-" + counter;
            ++counter;
        }
        return uniqueName;
    }

    public static MetadataModel filter(MetadataModel metadata, Object key) {
        TIntArrayList indices = new TIntArrayList();
        int ncols = metadata.getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            if (metadata.get(j).getProperty(key) == null) continue;
            indices.add(j);
        }
        return new MetadataModelColumnView(metadata, indices.toArray());
    }

    public static boolean getBoolean(Vector column, Object key) {
        Boolean b = (Boolean)column.getProperty(key);
        return b != null && b != false;
    }

    public static MetadataModel getCategoryColumns(MetadataModel metadata) {
        return MetadataUtil.filter(metadata, COLOR_VISIBLE_KEY);
    }

    public static MetadataModel getChartColumns(MetadataModel metadata) {
        return MetadataUtil.filter(metadata, CHART_STYLE_KEY);
    }

    public static List<String> getColumnNames(MetadataModel metadata, Class<?> c) {
        ArrayList<String> list = new ArrayList<String>();
        int cols = metadata.getMetadataCount();
        for (int j = 0; j < cols; ++j) {
            if (!c.isAssignableFrom(metadata.get(j).getColumnClass())) continue;
            list.add(metadata.getColumnName(j));
        }
        return list;
    }

    public static MetadataModel getColumns(MetadataModel metadata, Class<?> c) {
        TIntArrayList indices = new TIntArrayList();
        int ncols = metadata.getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            if (!c.isAssignableFrom(metadata.get(j).getColumnClass())) continue;
            indices.add(j);
        }
        return new MetadataModelColumnView(metadata, indices.toArray());
    }

    public static int[] getIndices(MetadataModel model, List<String> names, boolean removeNotFoundNames) {
        TIntArrayList indices = new TIntArrayList();
        for (String name : names) {
            int index = model.getColumnIndex(name);
            if (index != -1) {
                indices.add(index);
                continue;
            }
            if (removeNotFoundNames) continue;
            throw new IllegalArgumentException(name + " not found.");
        }
        return indices.toArray();
    }

    public static String getMetadataName(MetadataModel metadata, Class<?> c) {
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            if (!c.isAssignableFrom(metadata.get(i).getColumnClass())) continue;
            return metadata.getColumnName(i);
        }
        return null;
    }

    public static List<Integer> getMetadataStartsWith(MetadataModel metadata, String text) {
        text = text.toLowerCase();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int ncols = metadata.getMetadataCount();
        for (int i = 0; i < ncols; ++i) {
            String name = metadata.getColumnName(i);
            String lc = name.toLowerCase();
            if (!lc.startsWith(text)) continue;
            list.add(i);
        }
        return list;
    }

    public static List<String> getNames(MetadataModel metadata) {
        ArrayList<String> names = new ArrayList<String>();
        int size = metadata.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            names.add(metadata.getColumnName(i));
        }
        return names;
    }

    public static MetadataModel getTextColumns(MetadataModel metadata) {
        TIntArrayList indices = new TIntArrayList();
        int ncols = metadata.getMetadataCount();
        for (int j = 0; j < ncols; ++j) {
            if (!MetadataUtil.isTextVisible(metadata.get(j))) continue;
            indices.add(j);
        }
        return new MetadataModelColumnView(metadata, indices.toArray());
    }

    public static Vector[] getVectors(MetadataModel metadata, String[] names) {
        Vector[] vectors = new Vector[names.length];
        int ncols = names.length;
        for (int j = 0; j < ncols; ++j) {
            vectors[j] = metadata.get(names[j]);
        }
        return vectors;
    }

    public static boolean isColorVisible(Vector column) {
        return MetadataUtil.getBoolean(column, COLOR_VISIBLE_KEY);
    }

    public static boolean isTextColorVisible(Vector column) {
        return MetadataUtil.getBoolean(column, TEXT_COLOR_VISIBLE_KEY);
    }

    public static boolean isTextVisible(Vector column) {
        return MetadataUtil.getBoolean(column, TEXT_VISIBLE_KEY);
    }

    public static boolean isToolTipVisible(Vector column) {
        return MetadataUtil.getBoolean(column, TOOLTIP_VISIBLE_KEY);
    }

    public static void maybeConvertMetadataClass(Dataset dataset, boolean convertStringsToNumbers) {
        int j;
        int metadataColumns = dataset.getRowMetadata().getMetadataCount();
        for (j = 0; j < metadataColumns; ++j) {
            MetadataUtil.maybeConvertMetadataClass(dataset.getRowMetadata(), null, convertStringsToNumbers, j, true);
        }
        metadataColumns = dataset.getColumnMetadata().getMetadataCount();
        for (j = 0; j < metadataColumns; ++j) {
            MetadataUtil.maybeConvertMetadataClass(dataset.getColumnMetadata(), null, convertStringsToNumbers, j, false);
        }
    }

    public static boolean maybeConvertMetadataClass(MetadataModel metadata, VectorColorModel colorModel, boolean convertStringsToNumbers, int columnIndex, boolean isRows) {
        String metadataName = metadata.getColumnName(columnIndex);
        Vector vector = metadata.get(columnIndex);
        if (metadataName.toLowerCase().contains("smile") && UserUtil.isBroadUser()) {
            metadata.get(columnIndex).setColumnClass(Molecule.class);
            MetadataUtil.convertToMolecule(vector, colorModel);
            return true;
        }
        if (convertStringsToNumbers && MetadataUtil.maybeConvertStringToNumber(vector, colorModel, false)) {
            if (!isRows) {
                vector.setProperty(COLOR_VISIBLE_KEY, null);
                vector.setProperty(CHART_STYLE_KEY, 64);
            }
            return true;
        }
        if (MetadataUtil.maybeConvertStringToURL(vector, colorModel)) {
            return true;
        }
        return MetadataUtil.maybeConvertStringToDate(vector, colorModel);
    }

    public static boolean maybeConvertStringToNumber(Vector vector, VectorColorModel colorModel, boolean updateColors) {
        Float[] newValues = new Float[vector.size()];
        try {
            boolean nonNaN = false;
            int nrows = newValues.length;
            for (int i = 0; i < nrows; ++i) {
                String s = (String)vector.getValue(i);
                if (s == null || s.equals("")) continue;
                float f = ParserHelper.parseFloatNaN(s);
                if (!Float.isNaN(f)) {
                    nonNaN = true;
                }
                newValues[i] = Float.valueOf(f);
            }
            if (!nonNaN) {
                return false;
            }
        }
        catch (Throwable x) {
            return false;
        }
        vector.setColumnClass(Float.class);
        int nrows = newValues.length;
        for (int i = 0; i < nrows; ++i) {
            if (updateColors) {
                MetadataUtil.updateColor(vector, vector.getValue(i), newValues[i], colorModel);
            }
            vector.setValue(i, newValues[i]);
        }
        return true;
    }

    public static void setColumnMetadataVisibility(MetadataModel model) {
        MetadataUtil.setMetadataVisibility(model, false);
    }

    public static void setRowMetadataVisibility(MetadataModel model) {
        MetadataUtil.setMetadataVisibility(model, true);
    }

    public static void setValuesFromFormula(Vector vector, MetadataModel model, AbstractDatasetView datasetView, ScriptEngine engine, String formula) throws ScriptException {
        int count = model.getItemCount();
        for (int i = 0; i < count; ++i) {
            int nmetadata = model.getMetadataCount();
            for (int metadataIndex = 0; metadataIndex < nmetadata; ++metadataIndex) {
                String name = model.getColumnName(metadataIndex);
                name = name.replace(' ', '_');
                engine.put(name, model.get(metadataIndex).getValue(i));
            }
            datasetView.setIndex(i);
            engine.put("dataset", datasetView);
            engine.eval("CV = org.broadinstitute.genee.math.FloatListStatUtils.cv(dataset);");
            engine.eval("MAD = org.broadinstitute.genee.math.FloatListStatUtils.mad(dataset);");
            engine.eval("MEAN = org.broadinstitute.genee.math.FloatListStatUtils.mean(dataset);");
            engine.eval("MEDIAN = org.broadinstitute.genee.math.FloatListStatUtils.median(dataset);");
            engine.eval("MAX = org.broadinstitute.genee.math.FloatListStatUtils.max(dataset);");
            engine.eval("MIN = org.broadinstitute.genee.math.FloatListStatUtils.min(dataset);");
            engine.eval("STDEV = org.broadinstitute.genee.math.FloatListStatUtils.stdev(dataset);");
            engine.eval("SUM = org.broadinstitute.genee.math.FloatListStatUtils.sum(dataset);");
            engine.eval("VARIANCE = org.broadinstitute.genee.math.FloatListStatUtils.variance(dataset);");
            Number result = (Number)engine.eval(formula);
            vector.setValue(i, Float.valueOf(result.floatValue()));
        }
    }

    public static void updateFormulaValues(AbstractDatasetView view, MetadataModel model) {
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("JavaScript");
        int metadataColumns = model.getMetadataCount();
        for (int j = 0; j < metadataColumns; ++j) {
            Vector v = model.get(j);
            String formula = (String)v.getProperty("formula");
            if (formula == null) continue;
            try {
                MetadataUtil.setValuesFromFormula(v, model, view, engine, formula);
                continue;
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
    }

    public static MetadataModel without(MetadataModel model, String ... names) {
        TIntArrayList indices = new TIntArrayList();
        HashSet<String> set = new HashSet<String>(Arrays.asList(names));
        int size = model.getMetadataCount();
        for (int i = 0; i < size; ++i) {
            if (set.contains(model.getColumnName(i))) continue;
            indices.add(i);
        }
        return new MetadataModelColumnView(model, indices.toArray());
    }

    static void copyProperties(MetadataModel src, MetadataModel dest) {
        int count = src.getMetadataCount();
        for (int i = 0; i < count; ++i) {
            int destIndex = dest.getColumnIndex(src.getColumnName(i));
            if (destIndex == -1) continue;
            MetadataUtil.copyProperties(src.get(i), dest.get(destIndex));
        }
    }

    private static void convertToMolecule(Vector vector, VectorColorModel colorModel) {
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Object val = vector.getValue(i);
            try {
                Molecule value = (Molecule)(val instanceof Molecule ? val : MoleculeUtil.read((String)val));
                MetadataUtil.updateColor(vector, vector.getValue(i), value, colorModel);
                vector.setValue(i, value);
                continue;
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
    }

    private static boolean maybeConvertStringToDate(Vector vector, VectorColorModel colorModel) {
        Date[] array = new Date[vector.size()];
        boolean nonNull = false;
        DateFormat format = DateFormat.getInstance();
        try {
            int i;
            int nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                String s = (String)vector.getValue(i);
                if (s == null || s.equals("")) continue;
                nonNull = true;
                array[i] = format.parse(s);
            }
            if (!nonNull) {
                return false;
            }
            vector.setColumnClass(Date.class);
            nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                MetadataUtil.updateColor(vector, vector.getValue(i), array[i], colorModel);
                vector.setValue(i, array[i]);
            }
            return true;
        }
        catch (Throwable x) {
            return false;
        }
    }

    private static boolean maybeConvertStringToURL(Vector vector, VectorColorModel colorModel) {
        URL[] array = new URL[vector.size()];
        boolean nonNull = false;
        try {
            int i;
            int nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                String s = (String)vector.getValue(i);
                if (s == null || s.equals("")) continue;
                nonNull = true;
                array[i] = new URL(s);
            }
            if (!nonNull) {
                return false;
            }
            vector.setColumnClass(URL.class);
            nrows = array.length;
            for (i = 0; i < nrows; ++i) {
                MetadataUtil.updateColor(vector, vector.getValue(i), array[i], colorModel);
                vector.setValue(i, array[i]);
            }
            return true;
        }
        catch (Throwable x) {
            return false;
        }
    }

    private static void setMetadataVisibility(MetadataModel metadata, boolean rows) {
        boolean isL1000;
        boolean bl = rows ? metadata.get("pr_gene_symbol") != null : (isL1000 = metadata.get("pert_id") != null);
        if (!isL1000) {
            for (int metadataIndex = 0; metadataIndex < metadata.getMetadataCount(); ++metadataIndex) {
                String name = metadata.get(metadataIndex).getName();
                metadata.get(metadataIndex).setProperty(TOOLTIP_VISIBLE_KEY, true);
                if (!DEFAULT_METADATA_HIDE_ALL.contains(name)) {
                    if (rows || DEFAULT_METADATA_TEXT.contains(name)) {
                        metadata.get(metadataIndex).setProperty(TEXT_VISIBLE_KEY, true);
                        metadata.get(metadataIndex).setProperty(COLOR_VISIBLE_KEY, false);
                    } else if (metadataIndex == 0) {
                        metadata.get(metadataIndex).setProperty(TEXT_VISIBLE_KEY, true);
                        metadata.get(metadataIndex).setProperty(COLOR_VISIBLE_KEY, false);
                    } else {
                        metadata.get(metadataIndex).setProperty(TEXT_VISIBLE_KEY, false);
                        metadata.get(metadataIndex).setProperty(COLOR_VISIBLE_KEY, true);
                    }
                }
                if (rows || metadata.get(metadataIndex).getProperty(COLOR_VISIBLE_KEY) == null || VectorUtil.getValues(metadata.get(metadataIndex), 2) > 1) continue;
                metadata.get(metadataIndex).setProperty(COLOR_VISIBLE_KEY, null);
            }
        } else {
            Vector v;
            String[] colorFields;
            String[] textFields;
            for (int metadataIndex = 0; metadataIndex < metadata.getMetadataCount(); ++metadataIndex) {
                metadata.get(metadataIndex).setProperty(TEXT_VISIBLE_KEY, false);
                metadata.get(metadataIndex).setProperty(COLOR_VISIBLE_KEY, false);
                metadata.get(metadataIndex).setProperty(TEXT_COLOR_VISIBLE_KEY, false);
                metadata.get(metadataIndex).setProperty(CHART_STYLE_KEY, false);
            }
            if (rows) {
                textFields = new String[]{"pr_id", "id", "pr_gene_symbol", "is_lm"};
                colorFields = new String[]{};
            } else {
                textFields = new String[]{"pert_id", "pert_iname", "pert_desc"};
                colorFields = new String[]{"cell_id", "pert_idose", "pert_dose", "pert_itime", "pert_time"};
            }
            for (String field : colorFields) {
                v = metadata.get(field);
                if (v == null || VectorUtil.getValues(v, 2) != 2) continue;
                v.setProperty(COLOR_VISIBLE_KEY, true);
            }
            for (String field : colorFields) {
                v = metadata.get(field);
                if (v == null || VectorUtil.getValues(v, 2) != 2) continue;
                v.setProperty(COLOR_VISIBLE_KEY, true);
            }
            for (String field : textFields) {
                v = metadata.get(field);
                if (v == null) continue;
                v.setProperty(TEXT_VISIBLE_KEY, true);
            }
        }
    }

    private static void updateColor(Vector vector, Object oldValue, Object newValue, VectorColorModel colorModel) {
        if (colorModel != null && oldValue != null && colorModel.containsDiscreteColor(vector, oldValue)) {
            Color color = (Color)colorModel.getMappedValue(vector, oldValue);
            colorModel.setMappedValue(vector, newValue, color);
        }
    }
}

