/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.matrix.rankedlist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.matrix.VectorUtil;
import org.broadinstitute.genee.matrix.rankedlist.RankedList;
import org.broadinstitute.genee.stats.Sorting;

public class DatasetRankedList
implements RankedList {
    private Dataset dataset;
    private int positiveToZeroIndex;
    private int negativeToZeroIndex;
    private int columnIndex;
    private Map<Object, Object> properties = new HashMap<Object, Object>();
    private int[] rowIndices;
    private Map<Object, Integer> idToIndex;
    private String labelBy;

    public DatasetRankedList(Dataset d, int columnIndex, String labelBy) {
        int i;
        this.labelBy = labelBy;
        Sorting.Indexable[] pairs = new Sorting.FloatIntPair[d.getRowCount()];
        int length = pairs.length;
        for (i = 0; i < length; ++i) {
            pairs[i] = new Sorting.FloatIntPair(d.getValue(i, columnIndex), i);
        }
        this.columnIndex = columnIndex;
        this.rowIndices = Sorting.index(pairs, false);
        this.dataset = DatasetUtil.sliceView(d, this.rowIndices, new int[]{columnIndex});
        this.idToIndex = new HashMap<Object, Integer>();
        length = this.rowIndices.length;
        for (i = 0; i < length; ++i) {
            this.idToIndex.put(this.rowIndices[i], i);
        }
        this.positiveToZeroIndex = VectorUtil.getPositiveToZeroIndex(this);
        this.negativeToZeroIndex = VectorUtil.getNegativeToZeroIndex(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatasetRankedList) {
            DatasetRankedList rl = (DatasetRankedList)obj;
            return rl.dataset == this.dataset && rl.columnIndex == this.columnIndex;
        }
        return false;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public Object getId(int index) {
        return this.rowIndices[index];
    }

    @Override
    public int getIndex(Object id) {
        Integer index = this.idToIndex.get(id);
        return index != null ? index : -1;
    }

    public String getLabelBy() {
        return this.labelBy;
    }

    @Override
    public MetadataModel getMetadata() {
        return this.dataset.getRowMetadata();
    }

    @Override
    public String getName() {
        Vector v = this.dataset.getColumnMetadata().get(this.labelBy);
        return v == null ? ToStringUtil.toString(this.dataset.getColumnMetadata(), 0) : Formatter.toString(v.getValue(0));
    }

    @Override
    public int getNegativeToZeroIndex() {
        return this.negativeToZeroIndex;
    }

    @Override
    public int getPositiveToZeroIndex() {
        return this.positiveToZeroIndex;
    }

    @Override
    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Collection<Object> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public float getScore(int index) {
        return this.dataset.getValue(index, 0);
    }

    public int hashCode() {
        return this.columnIndex;
    }

    public void setLabelBy(String labelBy) {
        this.labelBy = labelBy;
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public int size() {
        return this.dataset.getRowCount();
    }

    public String toString() {
        return this.getName();
    }
}

