/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.grid.JideTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.heatmap.URLTableCellRenderer;
import org.broadinstitute.genee.table.ColumnPositionTableUI;
import org.broadinstitute.genee.table.HeatMapColumnTableModel;
import org.broadinstitute.genee.table.QuaquaColumnTableUI;
import org.broadinstitute.genee.table.TableUtil;
import org.jdesktop.swingx.util.OS;

public class BasicHeatMapColumnTable
extends JideTable {
    protected SizesAndPositions viewSizesAndPositions;

    public BasicHeatMapColumnTable(TableModel model) {
        super(model);
        TableUtil.setRenderers((JTable)((Object)this), false);
        this.setVariousRowHeights(true);
        this.setRowResizable(true);
        this.setIntercellSpacing(new Dimension());
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(URL.class, new URLTableCellRenderer());
        this.setGridColor(UIUtil.LIGHT_BLUE);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(false);
        this.setMinimumSize(new Dimension());
    }

    public void addColumn(TableColumn c) {
        super.addColumn(c);
        int columnSize = (int)Math.ceil(this.viewSizesAndPositions.getSize());
        c.setMinWidth(columnSize);
        c.setPreferredWidth(columnSize);
        c.setWidth(columnSize);
    }

    public void addNotify() {
        super.addNotify();
        UIUtil.registerToolTip((JComponent)((Object)this));
    }

    public int columnAtPoint(Point point) {
        int x = point.x;
        return this.viewSizesAndPositions.getIndex(x, false);
    }

    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < m.getColumnCount(); ++i) {
                TableColumn newColumn = new TableColumn(i);
                this.addColumn(newColumn);
            }
        }
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle r = new Rectangle();
        boolean valid = true;
        if (row < 0) {
            valid = false;
        } else if (row >= this.getRowCount()) {
            r.y = this.getHeight();
            valid = false;
        } else {
            r.height = this.getRowHeight(row);
            for (int i = 0; i < row; ++i) {
                r.y += this.getRowHeight(i);
            }
        }
        if (column < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else if (column >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                r.x = this.getWidth();
            }
            valid = false;
        } else {
            r.x = Math.round(this.viewSizesAndPositions.getPosition(column));
            r.width = (int)Math.ceil(this.viewSizesAndPositions.getSize());
        }
        if (valid && !includeSpacing) {
            int rm = this.getRowMargin();
            int cm = this.getColumnModel().getColumnMargin();
            r.setBounds(r.x + cm / 2, r.y + rm / 2, r.width - cm, r.height - rm);
        }
        return r;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.getDefaultRenderer(((HeatMapColumnTableModel)this.getModel()).getRowClass(row));
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = HeatMapPanel.getSize(this.viewSizesAndPositions);
        return size;
    }

    public SizesAndPositions getViewSizesAndPositions() {
        return this.viewSizesAndPositions;
    }

    public void removeNotify() {
        super.removeNotify();
        UIUtil.unregisterToolTip((JComponent)((Object)this));
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
    }

    public void setViewSizesAndPositions(SizesAndPositions viewColumnSizesAndPositions) {
        this.viewSizesAndPositions = viewColumnSizesAndPositions;
        this.setUI(OS.isMacOSX() ? new QuaquaColumnTableUI(viewColumnSizesAndPositions) : new ColumnPositionTableUI(viewColumnSizesAndPositions));
    }

    public void tableChanged(TableModelEvent e) {
        Project project = ((HeatMapColumnTableModel)this.getModel()).getProject();
        if (project == null) {
            super.tableChanged(e);
            return;
        }
        int[] selectedModelIndices = project.getColumnSelectionModel().getSelectedModelIndices();
        ListSelectionModel selectionModel = this.getColumnModel().getSelectionModel();
        ListSelectionModel rowSelectionModel = this.selectionModel;
        int rowMin = rowSelectionModel.getMinSelectionIndex();
        int rowMax = rowSelectionModel.getMaxSelectionIndex();
        rowMin = Math.max(rowMin, 0);
        rowMax = Math.max(rowMax, 0);
        super.tableChanged(e);
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        rowSelectionModel.addSelectionInterval(rowMin, rowMax);
        for (int modelIndex : selectedModelIndices) {
            int viewIndex = project.convertModelColumnIndexToView(modelIndex);
            if (viewIndex == -1) continue;
            selectionModel.addSelectionInterval(viewIndex, viewIndex);
        }
        selectionModel.setValueIsAdjusting(false);
        if (this.defaultRenderersByColumnClass != null) {
            BasicHeatMapColumnTable.sizeTableRowHeight((JTable)((Object)this));
        }
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane sp = UIUtil.getScrollPane((Component)((Object)this));
        if (sp != null) {
            final BoundedRangeModel model = sp.getVerticalScrollBar().getModel();
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    model.setValue(model.getMaximum());
                    model.removeChangeListener(this);
                }
            });
        }
    }

    public static void sizeTableRowHeight(JTable table) {
        int rows = table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            int height = BasicHeatMapColumnTable.getRowHeight(table, i);
            table.setRowHeight(i, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRowHeight(JTable table, int rowIndex) {
        int prefRowHeight = 20;
        boolean isHeadless = GraphicsEnvironment.isHeadless();
        int ncols = Math.min(100, table.getColumnCount());
        for (int j = 0; j < ncols; ++j) {
            Component c = null;
            Font oldFont = null;
            try {
                TableCellRenderer renderer = table.getCellRenderer(rowIndex, j);
                if (renderer == null) continue;
                Object val = table.getValueAt(rowIndex, j);
                if (!isHeadless) {
                    table.prepareRenderer(renderer, rowIndex, j);
                }
                c = renderer.getTableCellRendererComponent(table, val, false, false, rowIndex, j);
                float fontSize = table.getColumnModel().getColumn(j).getWidth();
                if (fontSize > 16.0f) {
                    fontSize = 16.0f;
                }
                oldFont = c.getFont();
                c.setFont(c.getFont().deriveFont(1, fontSize));
                Dimension size = c.getPreferredSize();
                if (size == null) continue;
                int height = size.height;
                prefRowHeight = Math.max(prefRowHeight, height);
                continue;
            }
            catch (Exception x) {
                x.printStackTrace();
                continue;
            }
            finally {
                if (oldFont != null) {
                    c.setFont(oldFont);
                }
            }
        }
        if (prefRowHeight > 500) {
            prefRowHeight = 500;
        }
        return prefRowHeight;
    }
}

