/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.chart.ConditionalDrawingOptionsPanel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetSeriesAdapter;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.table.DatasetValuesTableModel;
import org.broadinstitute.genee.table.TableUtil;

public class DatasetTablePanel
extends JPanel
implements GENEEWindowNotifier {
    private DatasetValuesTableModel tableModel;
    private Project project;
    private SelectionListener rowSelectionListener;
    private SelectionListener columnSelectionListener;
    private String seriesName;
    private JComboBox datasetComboBox;

    public DatasetTablePanel(Project project) {
        this.project = project;
        this.rowSelectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                DatasetTablePanel.this.updateTable();
            }
        };
        this.columnSelectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                DatasetTablePanel.this.updateTable();
            }
        };
        this.tableModel = new DatasetValuesTableModel(null);
        TableScrollPane sp = new TableScrollPane((MultiTableModel)this.tableModel);
        TableUtil.setRenderers(sp.getMainTable(), true);
        FormBuilder formBuilder = null;
        this.datasetComboBox = UIUtil.createComboBox();
        ConditionalDrawingOptionsPanel.rebuildDatasetCombobox(project, this.datasetComboBox);
        if (this.datasetComboBox.getItemCount() > 1) {
            formBuilder = new FormBuilder();
            formBuilder.nextRow();
            formBuilder.addLabel("Dataset:");
            formBuilder.add(this.datasetComboBox);
        }
        this.datasetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetTablePanel.this.seriesName = (String)DatasetTablePanel.this.datasetComboBox.getSelectedItem();
                DatasetTablePanel.this.updateTable();
            }
        });
        this.setLayout(new BorderLayout());
        if (formBuilder != null) {
            this.add((Component)formBuilder.getPanel(), "North");
        }
        this.add((Component)sp, "Center");
    }

    private void updateTable() {
        Dataset dataset = DatasetUtil.sliceView(this.project.getOriginalDataset(), this.project.getModelRowIndices(true, false), this.project.getModelColumnIndices(true, false));
        if (this.seriesName != null) {
            dataset = new DatasetSeriesAdapter(dataset, this.seriesName);
        }
        this.tableModel.setDataset(dataset);
    }

    @Override
    public void notifyHidden() {
        this.project.getRowSelectionModel().removeSelectionListener(this.rowSelectionListener);
        this.project.removeColumnSelectionListener(this.columnSelectionListener);
    }

    @Override
    public void notifyShowing() {
        this.project.getRowSelectionModel().addSelectionListener(this.rowSelectionListener);
        this.project.addColumnSelectionListener(this.columnSelectionListener);
        this.updateTable();
    }
}

