/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import com.jidesoft.swing.JideLabel;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import org.broadinstitute.genee.io.util.Formatter;

public class DragTextIcon
extends ImageIcon {
    private boolean rotated;

    public DragTextIcon(List<?> values, boolean rotated) {
        JideLabel label = new JideLabel(" ");
        this.rotated = rotated;
        int maxLabelWidth = 0;
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            label.setText(Formatter.toString(values.get(i)));
            maxLabelWidth = Math.max(maxLabelWidth, label.getPreferredSize().width);
        }
        maxLabelWidth = Math.min(300, maxLabelWidth);
        if (!rotated) {
            int height = label.getPreferredSize().height;
            int totalHeight = height * values.size();
            BufferedImage image = new BufferedImage(maxLabelWidth, totalHeight, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            int length2 = values.size();
            for (int i = 0; i < length2; ++i) {
                Object value = values.get(i);
                label.setText(Formatter.toString(value));
                label.setSize(maxLabelWidth, height);
                label.paint((Graphics)g2);
                g2.translate(0, height);
            }
            g2.dispose();
            this.setImage(image);
        } else {
            label.setOrientation(1);
            label.setClockwise(false);
            int labelWidth = label.getPreferredSize().width;
            int totalWidth = labelWidth * values.size();
            BufferedImage image = new BufferedImage(totalWidth, maxLabelWidth, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            int length3 = values.size();
            for (int i = 0; i < length3; ++i) {
                label.setText(Formatter.toString(values.get(i)));
                label.setSize(labelWidth, maxLabelWidth);
                label.paint((Graphics)g2);
                g2.translate(labelWidth, 0);
            }
            g2.dispose();
            this.setImage(image);
        }
    }

    public boolean isRotated() {
        return this.rotated;
    }
}

