/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.heatmap.HeatMapElementPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;
import org.broadinstitute.genee.table.HeatMapColumnTableModel;
import org.broadinstitute.genee.table.VerticalTableDrawer;

public class HeatMapColumnTableDrawer
extends VerticalTableDrawer {
    private SizesAndPositions viewColumnSizesAndPositions;
    private HeatMapColumnTableModel heatMapColumnTableModel;

    public HeatMapColumnTableDrawer(JTable table, SizesAndPositions viewColumnSizesAndPositions) {
        super(table);
        this.viewColumnSizesAndPositions = viewColumnSizesAndPositions;
        this.heatMapColumnTableModel = (HeatMapColumnTableModel)table.getModel();
        this.init();
    }

    protected boolean drawValue(Object value) {
        return !(value instanceof CurveElementList);
    }

    @Override
    protected Color getColor(int row, int column) {
        Vector vector = this.heatMapColumnTableModel.getAsVector(row);
        Color color = null;
        if (vector != null && MetadataUtil.getBoolean(vector, "Text Color Visible")) {
            color = (Color)this.heatMapColumnTableModel.getProject().getColumnColorModel().getMappedValue(vector, this.heatMapColumnTableModel.getValueAt(row, column));
        }
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    @Override
    protected int getColumnEnd(Rectangle clip) {
        return HeatMapElementPanel.getRight(this.heatMapColumnTableModel.getColumnCount(), clip, this.viewColumnSizesAndPositions);
    }

    @Override
    protected int getColumnStart(Rectangle clip) {
        return HeatMapElementPanel.getLeft(clip, this.viewColumnSizesAndPositions);
    }

    @Override
    protected float getPosition(int column) {
        return this.viewColumnSizesAndPositions.getPosition(column);
    }

    @Override
    protected float getSize() {
        return this.viewColumnSizesAndPositions.getSize();
    }
}

