/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.util.ViewportPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.table.RowPositionTableUI;

public class QuaquaRowTableUI
extends RowPositionTableUI
implements ViewportPainter {
    private PropertyChangeListener propertyChangeListener;
    private ListSelectionListener listSelectionListener;
    private TableColumnModelListener columnModelListener;
    private Handler handler;
    private boolean isStriped = false;

    public QuaquaRowTableUI(SizesAndPositions sizesAndPositions) {
        super(sizesAndPositions);
    }

    @Override
    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 157) {
                    e.consume();
                }
            }
        };
    }

    private Color getAlternateColor(int modulo) {
        if (modulo == 0) {
            return UIManager.getColor("Table.alternateBackground.0");
        }
        return UIManager.getColor("Table.alternateBackground.1");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
        this.listSelectionListener = this.createListSelectionListener();
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        }
        this.columnModelListener = this.createTableColumnModelListener();
        if (this.table.getColumnModel() != null) {
            this.table.getColumnModel().addColumnModelListener(this.columnModelListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        }
        if (this.table.getColumnModel() != null) {
            this.table.getColumnModel().removeColumnModelListener(this.columnModelListener);
        }
        this.propertyChangeListener = null;
        this.listSelectionListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Object property = this.table.getClientProperty("Quaqua.Table.style");
        this.isStriped = property != null && property.equals("striped");
        this.updateStriped();
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private void updateStriped() {
    }

    public void paintViewport(Graphics g, JViewport c) {
        int y;
        Dimension vs = c.getSize();
        Dimension ts = this.table.getSize();
        Point p = this.table.getLocation();
        int rh = this.table.getRowHeight();
        int n = this.table.getRowCount();
        int row = Math.abs(p.y / rh);
        int th = n * rh - row * rh;
        if (this.isStriped) {
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                int ymax = Math.min(th, vs.height);
                for (y = p.y + row * rh; y < ymax; y += rh) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
        } else {
            g.setColor(this.table.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.table.getShowHorizontalLines()) {
            g.setColor(this.table.getGridColor());
            if (ts.width < vs.width) {
                row = Math.abs(p.y / rh);
                for (y = p.y + row * rh + rh - 1; y < th; y += rh) {
                    g.drawLine(0, y, vs.width, y);
                }
            }
            if (th < vs.height) {
                for (y = th + rh - 1; y < vs.height; y += rh) {
                    g.drawLine(0, y, vs.width, y);
                }
            }
        }
        if (th < vs.height && this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            TableColumnModel cm = this.table.getColumnModel();
            n = cm.getColumnCount();
            int y2 = th;
            int x = this.table.getX() - 1;
            for (int i = 0; i < n; ++i) {
                TableColumn col = cm.getColumn(i);
                g.drawLine(x += col.getWidth(), y2, x, vs.height);
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private boolean isFocused() {
        return this.table.isEditing() || QuaquaUtilities.isFocused((Component)this.table);
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        if (QuaquaManager.getProperty((String)"Quaqua.Table.useJ2SE5MouseHandler", (String)"false").equals("true") || QuaquaManager.getProperty((String)"java.version").startsWith("1.4") || QuaquaManager.getProperty((String)"java.version").startsWith("1.5")) {
            return new MouseHandler();
        }
        return super.createMouseInputListener();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private ListSelectionListener createListSelectionListener() {
        return this.getHandler();
    }

    private TableColumnModelListener createTableColumnModelListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        private void repaintSelection() {
            int[] rows = QuaquaRowTableUI.this.table.getSelectedRows();
            Object dirtyRect = null;
            for (int r = 0; r < rows.length; ++r) {
                int n = QuaquaRowTableUI.this.table.getColumnCount();
                for (int c = 0; c < n; ++c) {
                    QuaquaRowTableUI.this.table.repaint(QuaquaRowTableUI.this.table.getCellRect(rows[r], c, false));
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.repaintSelection();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintSelection();
        }
    }

    public class MouseHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;
        private boolean mouseReleaseDeselects;
        private static final int MOUSE_DRAG_DOES_NOTHING = 0;
        private static final int MOUSE_DRAG_SELECTS = 1;
        private static final int MOUSE_DRAG_TOGGLES_SELECTION = 2;
        private int mouseDragAction;
        private int toggledRow = -1;
        private int toggledColumn = -1;

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = QuaquaRowTableUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(QuaquaRowTableUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !QuaquaRowTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(QuaquaRowTableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            QuaquaRowTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            QuaquaRowTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !QuaquaRowTableUI.this.table.isEnabled() || e.isPopupTrigger() && (QuaquaRowTableUI.this.table.rowAtPoint(e.getPoint()) == -1 || QuaquaRowTableUI.this.table.isRowSelected(QuaquaRowTableUI.this.table.rowAtPoint(e.getPoint())));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseDragAction = 0;
            this.mouseReleaseDeselects = false;
            this.toggledColumn = -1;
            this.toggledRow = -1;
            Point p = e.getPoint();
            int row = QuaquaRowTableUI.this.table.rowAtPoint(p);
            int column = QuaquaRowTableUI.this.table.columnAtPoint(p);
            if (QuaquaRowTableUI.this.table.isEnabled()) {
                if (QuaquaRowTableUI.this.table.editCellAt(row, column, e)) {
                    this.setDispatchComponent(e);
                    this.repostEvent(e);
                }
                QuaquaRowTableUI.this.table.requestFocusInWindow();
                if (!(row == -1 || column == -1 || QuaquaRowTableUI.this.table.isRowSelected(row) && e.isPopupTrigger())) {
                    int anchorIndex = QuaquaRowTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
                    String javaVersion = System.getProperty("java.version");
                    if (javaVersion.startsWith("1.4") && (e.getModifiersEx() & 0x900) == 256 || !javaVersion.startsWith("1.4") && (e.getModifiersEx() & 0x1900) == 256) {
                        QuaquaRowTableUI.this.table.changeSelection(row, column, true, false);
                        this.toggledRow = row;
                        this.toggledColumn = column;
                        this.mouseDragAction = 2;
                    } else if ((e.getModifiersEx() & 0x1840) == 64 && anchorIndex != -1) {
                        QuaquaRowTableUI.this.table.changeSelection(row, column, false, true);
                        this.mouseDragAction = 1;
                    } else if ((e.getModifiersEx() & 0x140) == 0) {
                        if (QuaquaRowTableUI.this.table.isCellSelected(row, column)) {
                            this.mouseReleaseDeselects = QuaquaRowTableUI.this.table.isFocusOwner();
                        } else {
                            QuaquaRowTableUI.this.table.changeSelection(row, column, false, false);
                            this.mouseDragAction = 1;
                        }
                    }
                }
                QuaquaRowTableUI.this.table.getSelectionModel().setValueIsAdjusting(this.mouseDragAction != 0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.repostEvent(e);
            if (QuaquaRowTableUI.this.table.isEnabled()) {
                this.mouseDragAction = 0;
                if (this.mouseReleaseDeselects) {
                    int row = QuaquaRowTableUI.this.table.rowAtPoint(e.getPoint());
                    int column = QuaquaRowTableUI.this.table.columnAtPoint(e.getPoint());
                    QuaquaRowTableUI.this.table.changeSelection(row, column, false, false);
                }
                QuaquaRowTableUI.this.table.getSelectionModel().setValueIsAdjusting(false);
                if (QuaquaRowTableUI.this.table.isRequestFocusEnabled() && !QuaquaRowTableUI.this.table.isEditing()) {
                    QuaquaRowTableUI.this.table.requestFocus();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!QuaquaRowTableUI.this.table.isEnabled() || this.shouldIgnore(e)) {
                return;
            }
            TableCellEditor editor = QuaquaRowTableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                this.mouseReleaseDeselects = false;
                if (this.mouseDragAction == 1) {
                    int row = QuaquaRowTableUI.this.table.rowAtPoint(e.getPoint());
                    int column = QuaquaRowTableUI.this.table.columnAtPoint(e.getPoint());
                    if (row != -1 && column != -1) {
                        Rectangle cellBounds = QuaquaRowTableUI.this.table.getCellRect(row, column, true);
                        QuaquaRowTableUI.this.table.scrollRectToVisible(cellBounds);
                        QuaquaRowTableUI.this.table.changeSelection(row, column, false, true);
                    }
                } else if (this.mouseDragAction == 2) {
                    int row = QuaquaRowTableUI.this.table.rowAtPoint(e.getPoint());
                    int column = QuaquaRowTableUI.this.table.columnAtPoint(e.getPoint());
                    boolean isCellSelection = QuaquaRowTableUI.this.table.getCellSelectionEnabled();
                    if (row != -1 && column != -1 && (!isCellSelection && row != this.toggledRow || isCellSelection && (row != this.toggledRow || column != this.toggledColumn))) {
                        Rectangle cellBounds = QuaquaRowTableUI.this.table.getCellRect(row, column, true);
                        QuaquaRowTableUI.this.table.scrollRectToVisible(cellBounds);
                        QuaquaRowTableUI.this.table.changeSelection(row, column, true, false);
                        this.toggledRow = row;
                        this.toggledColumn = column;
                    }
                }
            }
        }
    }

    private class Handler
    implements PropertyChangeListener,
    ListSelectionListener,
    TableColumnModelListener {
        private boolean rowSelectionAdjusting;

        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (name.equals("Quaqua.Table.style")) {
                Object value = event.getNewValue();
                QuaquaRowTableUI.this.isStriped = value != null && value.equals("striped");
                QuaquaRowTableUI.this.updateStriped();
            } else if (name.equals("showVerticalLines") || name.equals("showHorizontalLines")) {
                if (QuaquaRowTableUI.this.table.getParent() instanceof JViewport) {
                    QuaquaRowTableUI.this.table.getParent().repaint();
                }
            } else if (name.equals("selectionModel")) {
                if (event.getOldValue() != null) {
                    ((ListSelectionModel)event.getOldValue()).removeListSelectionListener(QuaquaRowTableUI.this.listSelectionListener);
                }
                if (event.getNewValue() != null) {
                    ((ListSelectionModel)event.getNewValue()).addListSelectionListener(QuaquaRowTableUI.this.listSelectionListener);
                }
            } else if (name.equals("columnModel")) {
                if (event.getOldValue() != null) {
                    ((TableColumnModel)event.getOldValue()).removeColumnModelListener(QuaquaRowTableUI.this.columnModelListener);
                }
                if (event.getNewValue() != null) {
                    ((TableColumnModel)event.getNewValue()).addColumnModelListener(QuaquaRowTableUI.this.columnModelListener);
                }
            } else if (name.equals("tableCellEditor")) {
                QuaquaRowTableUI.this.table.repaint();
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant((JComponent)QuaquaRowTableUI.this.table);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        private int getAdjustedIndex(int index, boolean row) {
            int compare = row ? QuaquaRowTableUI.this.table.getRowCount() : QuaquaRowTableUI.this.table.getColumnCount();
            return index < compare ? index : -1;
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            ListSelectionModel selectionModel = QuaquaRowTableUI.this.table.getSelectionModel();
            int firstIndex = this.limit(e.getFirstIndex(), 0, QuaquaRowTableUI.this.table.getColumnCount() - 1);
            int lastIndex = this.limit(e.getLastIndex(), 0, QuaquaRowTableUI.this.table.getColumnCount() - 1);
            int minRow = 0;
            int maxRow = QuaquaRowTableUI.this.table.getRowCount() - 1;
            if (QuaquaRowTableUI.this.table.getRowSelectionAllowed()) {
                minRow = selectionModel.getMinSelectionIndex();
                maxRow = selectionModel.getMaxSelectionIndex();
                int leadRow = this.getAdjustedIndex(selectionModel.getLeadSelectionIndex(), true);
                if (minRow == -1 || maxRow == -1) {
                    if (leadRow == -1) {
                        return;
                    }
                    minRow = maxRow = leadRow;
                } else if (leadRow != -1) {
                    minRow = Math.min(minRow, leadRow);
                    maxRow = Math.max(maxRow, leadRow);
                }
            }
            Rectangle firstColumnRect = QuaquaRowTableUI.this.table.getCellRect(minRow, firstIndex, false);
            Rectangle lastColumnRect = QuaquaRowTableUI.this.table.getCellRect(maxRow, lastIndex, false);
            Rectangle dirtyRegion = firstColumnRect.union(lastColumnRect);
            Dimension intercellSpacing = QuaquaRowTableUI.this.table.getIntercellSpacing();
            if (intercellSpacing != null) {
                dirtyRegion.width += ((QuaquaRowTableUI)QuaquaRowTableUI.this).table.getIntercellSpacing().width;
            }
            QuaquaRowTableUI.this.table.repaint(dirtyRegion);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isAdjusting = e.getValueIsAdjusting();
            if (this.rowSelectionAdjusting && !isAdjusting) {
                this.rowSelectionAdjusting = false;
                return;
            }
            this.rowSelectionAdjusting = isAdjusting;
            if (QuaquaRowTableUI.this.table.getRowCount() <= 0 || QuaquaRowTableUI.this.table.getColumnCount() <= 0) {
                return;
            }
            int firstIndex = this.limit(e.getFirstIndex(), 0, QuaquaRowTableUI.this.table.getRowCount() - 1);
            int lastIndex = this.limit(e.getLastIndex(), 0, QuaquaRowTableUI.this.table.getRowCount() - 1);
            Rectangle firstRowRect = QuaquaRowTableUI.this.table.getCellRect(firstIndex, 0, true);
            Rectangle lastRowRect = QuaquaRowTableUI.this.table.getCellRect(lastIndex, QuaquaRowTableUI.this.table.getColumnCount() - 1, true);
            Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
            dirtyRegion.width += ((QuaquaRowTableUI)QuaquaRowTableUI.this).table.getIntercellSpacing().width;
            QuaquaRowTableUI.this.table.repaint(dirtyRegion);
        }

        private int limit(int i, int a, int b) {
            return Math.min(b, Math.max(i, a));
        }
    }
}

