/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;

public class RowPositionTableUI
extends BasicTableUI {
    private SizesAndPositions sizesAndPositions;

    public RowPositionTableUI(SizesAndPositions sizesAndPositions) {
        this.sizesAndPositions = sizesAndPositions;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            return;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = Math.max(this.sizesAndPositions.getIndex(clip.y, false) - 1, 0);
        int rMax = Math.min(this.sizesAndPositions.getIndex(clip.y + clip.height, false) + 1, this.sizesAndPositions.getLength() - 1);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.sizesAndPositions.getLength() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = true) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        cMax = Math.min(cMax, this.table.getColumnCount() - 1);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
    }

    private Dimension createTableSize(long width) {
        long tmp = Math.abs(width);
        if (tmp > Integer.MAX_VALUE) {
            tmp = Integer.MAX_VALUE;
        }
        int height = this.sizesAndPositions.getLength() == 0 ? 0 : HeatMapPanel.getSize(this.sizesAndPositions);
        return new Dimension((int)tmp, height);
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle cellRect = this.table.getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (aColumn != draggedColumn) {
                    this.paintCell(g, cellRect, row, column);
                }
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            Graphics2D g2 = (Graphics2D)g;
            int tableWidth = damagedArea.x + damagedArea.width;
            Line2D.Float line = new Line2D.Float();
            for (int row = rMin; row <= rMax; ++row) {
                float y = this.sizesAndPositions.getPosition(row);
                line.setLine(damagedArea.x, y, tableWidth - 1, y);
                g2.draw(line);
            }
        }
        if (this.table.getShowVerticalLines()) {
            int column;
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int x = damagedArea.x;
                for (column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                int x = damagedArea.x + damagedArea.width;
                for (column = cMin; column < cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g.drawLine((x -= w) - 1, 0, x - 1, tableHeight - 1);
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), 0, x, tableHeight - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }
}

