/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private float[][] L;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix Arg) {
        float[][] A = Arg.getArray();
        this.n = Arg.getRowDimension();
        this.L = new float[this.n][this.n];
        this.isspd = Arg.getColumnDimension() == this.n;
        for (int j = 0; j < this.n; ++j) {
            int k;
            float[] Lrowj = this.L[j];
            float d = 0.0f;
            for (k = 0; k < j; ++k) {
                float[] Lrowk = this.L[k];
                float s = 0.0f;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (A[j][k] - s) / this.L[k][k];
                d += s * s;
                this.isspd &= A[k][j] == A[j][k];
            }
            this.isspd &= (double)(d = A[j][j] - d) > 0.0;
            this.L[j][j] = (float)Math.sqrt(Math.max((double)d, 0.0));
            for (k = j + 1; k < this.n; ++k) {
                this.L[j][k] = 0.0f;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix B) {
        int i;
        int j;
        int k;
        if (B.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        float[][] X = B.getArrayCopy();
        int nx = B.getColumnDimension();
        for (k = 0; k < this.n; ++k) {
            j = 0;
            while (j < nx) {
                for (i = 0; i < k; ++i) {
                    float[] fArray = X[k];
                    int n = j;
                    fArray[n] = fArray[n] - X[i][j] * this.L[k][i];
                }
                float[] fArray = X[k];
                int n = j++;
                fArray[n] = fArray[n] / this.L[k][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                for (i = k + 1; i < this.n; ++i) {
                    float[] fArray = X[k];
                    int n = j;
                    fArray[n] = fArray[n] - X[i][j] * this.L[i][k];
                }
                float[] fArray = X[k];
                int n = j++;
                fArray[n] = fArray[n] / this.L[k][k];
            }
        }
        return new Matrix(X, this.n, nx);
    }
}

