/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import Jama.util.Maths;
import java.io.Serializable;

public class SingularValueDecomposition
implements Serializable {
    private float[][] U;
    private float[][] V;
    private float[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix Arg) {
        int i;
        int k;
        int j;
        float[][] A = Arg.getArrayCopy();
        this.m = Arg.getRowDimension();
        this.n = Arg.getColumnDimension();
        int nu = Math.min(this.m, this.n);
        this.s = new float[Math.min(this.m + 1, this.n)];
        this.U = new float[this.m][nu];
        this.V = new float[this.n][this.n];
        float[] e = new float[this.n];
        float[] work = new float[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.s[k2] = 0.0f;
                for (i3 = k2; i3 < this.m; ++i3) {
                    this.s[k2] = Maths.hypot(this.s[k2], A[i3][k2]);
                }
                if ((double)this.s[k2] != 0.0) {
                    if ((double)A[k2][k2] < 0.0) {
                        this.s[k2] = -this.s[k2];
                    }
                    for (i3 = k2; i3 < this.m; ++i3) {
                        float[] fArray = A[i3];
                        int n = k2;
                        fArray[n] = fArray[n] / this.s[k2];
                    }
                    float[] fArray = A[k2];
                    int n = k2;
                    fArray[n] = (float)((double)fArray[n] + 1.0);
                }
                this.s[k2] = -this.s[k2];
            }
            for (j = k2 + 1; j < this.n; ++j) {
                if (k2 < nct & (double)this.s[k2] != 0.0) {
                    float t = 0.0f;
                    for (i2 = k2; i2 < this.m; ++i2) {
                        t += A[i2][k2] * A[i2][j];
                    }
                    t = -t / A[k2][k2];
                    for (i2 = k2; i2 < this.m; ++i2) {
                        float[] fArray = A[i2];
                        int n = j;
                        fArray[n] = fArray[n] + t * A[i2][k2];
                    }
                }
                e[j] = A[k2][j];
            }
            if (wantu & k2 < nct) {
                for (i3 = k2; i3 < this.m; ++i3) {
                    this.U[i3][k2] = A[i3][k2];
                }
            }
            if (k2 >= nrt) continue;
            e[k2] = 0.0f;
            for (i3 = k2 + 1; i3 < this.n; ++i3) {
                e[k2] = Maths.hypot(e[k2], e[i3]);
            }
            if ((double)e[k2] != 0.0) {
                if ((double)e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i3 = k2 + 1;
                while (i3 < this.n) {
                    int n = i3++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = (float)((double)e[n] + 1.0);
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.m & (double)e[k2] != 0.0) {
                for (i3 = k2 + 1; i3 < this.m; ++i3) {
                    work[i3] = 0.0f;
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    for (int i4 = k2 + 1; i4 < this.m; ++i4) {
                        int n = i4;
                        work[n] = work[n] + e[j] * A[i4][j];
                    }
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    float t = -e[j] / e[k2 + 1];
                    for (i2 = k2 + 1; i2 < this.m; ++i2) {
                        float[] fArray = A[i2];
                        int n = j;
                        fArray[n] = fArray[n] + t * work[i2];
                    }
                }
            }
            if (!wantv) continue;
            for (i3 = k2 + 1; i3 < this.n; ++i3) {
                this.V[i3][k2] = e[i3];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0f;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0f;
        if (wantu) {
            for (j = nct; j < nu; ++j) {
                for (int i5 = 0; i5 < this.m; ++i5) {
                    this.U[i5][j] = 0.0f;
                }
                this.U[j][j] = 1.0f;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i6;
                if ((double)this.s[k] != 0.0) {
                    for (int j2 = k + 1; j2 < nu; ++j2) {
                        float t = 0.0f;
                        for (i = k; i < this.m; ++i) {
                            t += this.U[i][k] * this.U[i][j2];
                        }
                        t = -t / this.U[k][k];
                        for (i = k; i < this.m; ++i) {
                            float[] fArray = this.U[i];
                            int n = j2;
                            fArray[n] = fArray[n] + t * this.U[i][k];
                        }
                    }
                    for (i6 = k; i6 < this.m; ++i6) {
                        this.U[i6][k] = -this.U[i6][k];
                    }
                    this.U[k][k] = 1.0f + this.U[k][k];
                    for (i6 = 0; i6 < k - 1; ++i6) {
                        this.U[i6][k] = 0.0f;
                    }
                    continue;
                }
                for (i6 = 0; i6 < this.m; ++i6) {
                    this.U[i6][k] = 0.0f;
                }
                this.U[k][k] = 1.0f;
            }
        }
        if (wantv) {
            for (k = this.n - 1; k >= 0; --k) {
                if (k < nrt & (double)e[k] != 0.0) {
                    for (int j3 = k + 1; j3 < nu; ++j3) {
                        float t = 0.0f;
                        for (i = k + 1; i < this.n; ++i) {
                            t += this.V[i][k] * this.V[i][j3];
                        }
                        t = -t / this.V[k + 1][k];
                        for (i = k + 1; i < this.n; ++i) {
                            float[] fArray = this.V[i];
                            int n = j3;
                            fArray[n] = fArray[n] + t * this.V[i][k];
                        }
                    }
                }
                for (int i7 = 0; i7 < this.n; ++i7) {
                    this.V[i7][k] = 0.0f;
                }
                this.V[k][k] = 1.0f;
            }
        }
        int pp = p - 1;
        int iter = 0;
        float eps = (float)Math.pow(2.0, -52.0);
        float tiny = (float)Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1])))) continue;
                e[k3] = 0.0f;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    float t = (float)((ks != p ? (double)Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? (double)Math.abs(e[ks - 1]) : 0.0));
                    if (!(Math.abs(this.s[ks]) <= tiny + eps * t)) continue;
                    this.s[ks] = 0.0f;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    float sn;
                    float cs;
                    float t;
                    float f = e[p - 2];
                    e[p - 2] = 0.0f;
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t = Maths.hypot(this.s[j4], f);
                        cs = this.s[j4] / t;
                        sn = f / t;
                        this.s[j4] = t;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (!wantv) continue;
                        for (int i8 = 0; i8 < this.n; ++i8) {
                            t = cs * this.V[i8][j4] + sn * this.V[i8][p - 1];
                            this.V[i8][p - 1] = -sn * this.V[i8][j4] + cs * this.V[i8][p - 1];
                            this.V[i8][j4] = t;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    float sn;
                    float cs;
                    float t;
                    float f = e[k3 - 1];
                    e[k3 - 1] = 0.0f;
                    for (int j5 = k3; j5 < p; ++j5) {
                        t = Maths.hypot(this.s[j5], f);
                        cs = this.s[j5] / t;
                        sn = f / t;
                        this.s[j5] = t;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (!wantu) continue;
                        for (int i9 = 0; i9 < this.m; ++i9) {
                            t = cs * this.U[i9][j5] + sn * this.U[i9][k3 - 1];
                            this.U[i9][k3 - 1] = -sn * this.U[i9][j5] + cs * this.U[i9][k3 - 1];
                            this.U[i9][j5] = t;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    float scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                    float sp = this.s[p - 1] / scale;
                    float spm1 = this.s[p - 2] / scale;
                    float epm1 = e[p - 2] / scale;
                    float sk = this.s[k3] / scale;
                    float ek = e[k3] / scale;
                    float b = (float)((double)((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0);
                    float c = sp * epm1 * (sp * epm1);
                    float shift = 0.0f;
                    if ((double)b != 0.0 | (double)c != 0.0) {
                        shift = (float)Math.sqrt(b * b + c);
                        if ((double)b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    float f = (sk + sp) * (sk - sp) + shift;
                    float g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i10;
                        float t = Maths.hypot(f, g);
                        float cs = f / t;
                        float sn = g / t;
                        if (j6 != k3) {
                            e[j6 - 1] = t;
                        }
                        f = cs * this.s[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.s[j6];
                        g = sn * this.s[j6 + 1];
                        this.s[j6 + 1] = cs * this.s[j6 + 1];
                        if (wantv) {
                            for (i10 = 0; i10 < this.n; ++i10) {
                                t = cs * this.V[i10][j6] + sn * this.V[i10][j6 + 1];
                                this.V[i10][j6 + 1] = -sn * this.V[i10][j6] + cs * this.V[i10][j6 + 1];
                                this.V[i10][j6] = t;
                            }
                        }
                        t = Maths.hypot(f, g);
                        cs = f / t;
                        sn = g / t;
                        this.s[j6] = t;
                        f = cs * e[j6] + sn * this.s[j6 + 1];
                        this.s[j6 + 1] = -sn * e[j6] + cs * this.s[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (!wantu || j6 >= this.m - 1) continue;
                        for (i10 = 0; i10 < this.m; ++i10) {
                            t = cs * this.U[i10][j6] + sn * this.U[i10][j6 + 1];
                            this.U[i10][j6 + 1] = -sn * this.U[i10][j6] + cs * this.U[i10][j6 + 1];
                            this.U[i10][j6] = t;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if ((double)this.s[k3] <= 0.0) {
                        this.s[k3] = (float)((double)this.s[k3] < 0.0 ? (double)(-this.s[k3]) : 0.0);
                        if (wantv) {
                            for (int i11 = 0; i11 <= pp; ++i11) {
                                this.V[i11][k3] = -this.V[i11][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this.s[k3] >= this.s[k3 + 1])) {
                        float t = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t;
                        if (wantv && k3 < this.n - 1) {
                            for (int i12 = 0; i12 < this.n; ++i12) {
                                t = this.V[i12][k3 + 1];
                                this.V[i12][k3 + 1] = this.V[i12][k3];
                                this.V[i12][k3] = t;
                            }
                        }
                        if (wantu && k3 < this.m - 1) {
                            for (int i13 = 0; i13 < this.m; ++i13) {
                                t = this.U[i13][k3 + 1];
                                this.U[i13][k3 + 1] = this.U[i13][k3];
                                this.U[i13][k3] = t;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public Matrix getV() {
        return new Matrix(this.V, this.n, this.n);
    }

    public float[] getSingularValues() {
        return this.s;
    }

    public Matrix getS() {
        Matrix X = new Matrix(this.n, this.n);
        float[][] S = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                S[i][j] = 0.0f;
            }
            S[i][i] = this.s[i];
        }
        return X;
    }

    public float norm2() {
        return this.s[0];
    }

    public float cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        float eps = (float)Math.pow(2.0, -52.0);
        float tol = (float)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > tol)) continue;
            ++r;
        }
        return r;
    }
}

