/*
 * Decompiled with CFR 0.152.
 */
package com.community.xanadu.components.dnd;

import com.community.xanadu.utils.WindowsUtils;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DnDGhostDialog {
    private static boolean debug = false;
    private float alpha = 0.6f;
    private Image image;
    private JPanel panel = new JPanel(){

        @Override
        public boolean contains(int x, int y) {
            return false;
        }

        @Override
        public boolean contains(Point p) {
            return false;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (DnDGhostDialog.this.image == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            if (DnDGhostDialog.this.image != null) {
                Shape oldClip = g2.getClip();
                Area a1 = new Area(this.getBounds());
                a1.subtract(new Area(new Rectangle(this.getWidth() / 2, this.getHeight() / 2, 1, 1)));
                g2.setClip(a1);
                if (debug) {
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                g2.setComposite(AlphaComposite.SrcOver.derive(DnDGhostDialog.this.alpha));
                g2.drawImage(DnDGhostDialog.this.image, 0, 0, null);
                g2.setClip(oldClip);
            }
            DnDGhostDialog.this.panel.setDoubleBuffered(false);
        }
    };
    private JDialog window = new JDialog();

    public DnDGhostDialog() {
        this.window.setAlwaysOnTop(true);
        WindowsUtils.setOpacity(this.window, this.alpha);
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add(this.panel);
        this.panel.setOpaque(false);
        this.window.setSize(1, 1);
    }

    public boolean containsImage() {
        return this.image != null;
    }

    public void hide() {
        if (this.image != null) {
            this.setImage(null);
            this.window.setVisible(false);
        }
    }

    public void setDialogLocation(Point location) {
        if (this.image != null) {
            this.window.setLocation(new Point(location.x - this.image.getWidth(null) / 2, location.y - this.image.getHeight(null) / 2));
            this.window.setVisible(true);
        }
    }

    public void setImage(Image dragged) {
        this.image = dragged;
        if (dragged != null) {
            this.window.setSize(dragged.getWidth(null), dragged.getHeight(null));
        }
        this.window.repaint();
    }
}

