/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.application.GeneeExtensionManager;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.OSXAdapter;
import org.broadinstitute.genee.application.OpenFileListener;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.Shutdown;
import org.broadinstitute.genee.application.SplashWindow;
import org.broadinstitute.genee.application.TreeNavigator;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.application.WindowManager;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.BreadthFirstEnumeration;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.GENEEToolTipManager;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.XIcon;
import org.broadinstitute.genee.heatmap.ExampleDatasetsMenu;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.OpenDatasetFile;
import org.broadinstitute.genee.heatmap.OpenFile;
import org.broadinstitute.genee.heatmap.OpenPlateFiles;
import org.broadinstitute.genee.heatmap.OpenRecentMenu;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.menu.AboutAction;
import org.broadinstitute.genee.io.persistence.SessionSaver;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.luminex.LuminexImporter;
import org.broadinstitute.genee.server.GeneeServer;
import org.jdesktop.swingx.util.OS;

public final class Application {
    public static final int BUILD_STATUS_DEV = 0;
    public static final int BUILD_STATUS_PROD = 1;
    private static String APP_NAME;
    private static int buildStatus;
    private static File CACHE_DIR;
    private static final String CACHE_DIR_PROP = "application.cache.dir";
    private static DefaultOpenFileListener DEFAULT_OPEN_FILE_ACTION_LISTENER;
    private static boolean exitOnClose;
    private static boolean firstTime;
    private static boolean initted;
    private static TreeNavigator navigator;
    private static List<OpenFileListener> openFileActionListenerList;
    private static Shutdown shutdownThread;
    private static Object singleInstanceListener;
    private static Version version;
    private static WindowManager windowManager;

    private Application() {
    }

    public static void add(GENEEFolderNode node) {
        Application.add(node, false);
    }

    public static void add(GENEEFolderNode node, final boolean openFirstNodeOnly) {
        final GENEEFolderNode _node = node;
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (firstTime) {
                    if (!GraphicsEnvironment.isHeadless() && GENEEToolTipManager.sharedInstance().getWindow() != null && !Application.restoreWindowState("info", (Component)((Object)GENEEToolTipManager.sharedInstance().getWindow()))) {
                        ((Component)((Object)GENEEToolTipManager.sharedInstance().getWindow())).setLocation(UIUtil.getMaximumWindowSize().width - 300, UIUtil.getScreenInsets().top + 310);
                    }
                    firstTime = false;
                }
                if (_node.getParent() == null && navigator != null) {
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)navigator.getRoot();
                    root.add(_node);
                }
                if (_node.getChildCount() > 0) {
                    BreadthFirstEnumeration children = new BreadthFirstEnumeration(_node);
                    boolean opened = false;
                    while (children.hasMoreElements()) {
                        Object child = children.nextElement();
                        if (!(child instanceof ViewableGENEETreeNode)) continue;
                        if (((ViewableGENEETreeNode)child).isAutoOpen()) {
                            windowManager.open((ViewableGENEETreeNode)child);
                            opened = true;
                        }
                        if (!openFirstNodeOnly || !opened) continue;
                        break;
                    }
                }
                if (navigator != null) {
                    navigator.nodeStructureChanged();
                }
            }
        });
    }

    public static GENEEWindow createDialog(Component c, String title) {
        return windowManager.createInputWindow(c, title);
    }

    public static GENEEWindow createDialog(String title) {
        return windowManager.createInputWindow(title, null);
    }

    public static GENEEWindow createDialog(String title, GENEEWindowNotifier notifier) {
        return windowManager.createInputWindow(title, notifier);
    }

    public static GENEEWindow createViewWindow(String title) {
        return windowManager.createViewWindow(title, null);
    }

    public static GENEEWindow createViewWindow(String title, GENEEWindowNotifier notifier) {
        return windowManager.createViewWindow(title, notifier);
    }

    public static String getAbout() {
        Version v = Application.getVersion();
        String buildString = buildStatus == 1 ? "" : "Dev";
        return Application.getName() + " version " + v.versionString + " " + buildString + "\n\n" + "Built " + v.date + "\n\n" + "Copyright 2013 Broad Institute, Inc.\nGENE-E was made available through the generosity of the Cancer Program at the Broad Institute, Inc.";
    }

    public static File getGENEEDir() {
        return CACHE_DIR;
    }

    public static String getName() {
        return APP_NAME;
    }

    public static TreeNavigator getNavigator() {
        return navigator;
    }

    public static OpenFileListener[] getOpenFileActionListeners() {
        return openFileActionListenerList.toArray(new OpenFileListener[0]);
    }

    public static Project getProject() {
        GENEETreeNode node = windowManager.getNode();
        return node instanceof ProjectGENEEResultTreeNode ? ((ProjectGENEEResultTreeNode)node).getProject() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion() {
        if (version == null) {
            URL r = Application.class.getResource("/org/broadinstitute/genee/resources/build.properties");
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = r.openStream();
                props.load(is);
                String versionString = props.get("major.rev") + "." + props.get("minor.rev") + "." + props.get("minor2.rev");
                String date = props.getProperty("date");
                version = new Version(versionString, date);
            }
            catch (Exception x) {
                version = new Version("Latest version", new Date().toString());
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return version;
    }

    public static WindowManager getWindowManager() {
        return windowManager;
    }

    public static void init(final ApplicationArgs args) {
        if (initted) {
            return;
        }
        initted = true;
        if (windowManager == null) {
            windowManager = new DefaultWindowManager();
        }
        windowManager.init();
        Window frame = windowManager.getWindow();
        if (frame instanceof Frame) {
            UIUtil.setFrame((Frame)frame);
        }
        DEFAULT_OPEN_FILE_ACTION_LISTENER = new DefaultOpenFileListener();
        openFileActionListenerList.add(DEFAULT_OPEN_FILE_ACTION_LISTENER);
        if (!GraphicsEnvironment.isHeadless()) {
            navigator = new TreeNavigator();
        }
        if (frame instanceof JFrame) {
            if (exitOnClose) {
                ((JFrame)frame).setDefaultCloseOperation(0);
            } else {
                ((JFrame)frame).setDefaultCloseOperation(2);
            }
        }
        if (exitOnClose && frame != null) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Application.quit();
                }
            });
        }
        String title = Application.getName();
        if (Application.isDevVersion()) {
            title = title + " " + Application.getVersion().date;
        }
        if (frame instanceof Frame) {
            ((Frame)frame).setTitle(title);
        } else if (frame instanceof Dialog) {
            ((Dialog)frame).setTitle(title);
        }
        if (!GraphicsEnvironment.isHeadless()) {
            Preferences p;
            if (navigator != null && navigator.getWindow() != null && !Application.restoreWindowState("navigator", navigator.getWindow())) {
                navigator.getWindow().setLocation(UIUtil.getMaximumWindowSize().width - 300, UIUtil.getScreenInsets().top);
            }
            if ((p = Preferences.userNodeForPackage(Application.class)).getBoolean("navigator.visible", true) && navigator.getWindow() != null) {
                navigator.getWindow().show();
            }
        }
        GeneeExtensionManager.getInstance();
        if (args != null) {
            OpenFile openFile = new OpenFile(args);
            if (openFile.containsData()) {
                openFile.open();
                try {
                    Application.updateRecentFilesList(new File(args.getData()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (args.getArchive() != null) {
                final String name = IOUtil.getBaseFileName(args.getArchive());
                new BackgroundTask<GENEEFolderNode>("Loading " + name){

                    @Override
                    protected GENEEFolderNode doInBackground() throws Exception {
                        History history = new History("Opened " + name);
                        ProjectGENEEResultTreeNode node = ExampleDatasetsMenu.createNodeFromArchive(IOUtil.getBaseFileName(args.getArchive()), args.getArchive());
                        return new GENEEFolderNode("Open File", history, node);
                    }

                    @Override
                    protected void succeeded(GENEEFolderNode node) {
                        Application.add(node);
                    }
                }.execute();
            }
            args.after();
        }
        new Thread(){

            @Override
            public void run() {
                GeneeServer.getInstance();
            }
        }.start();
    }

    public static boolean isDevVersion() {
        return buildStatus == 0;
    }

    public static boolean isStandalone() {
        return exitOnClose;
    }

    public static boolean isValidLicense(String email, String key) {
        try {
            email = email.trim().toLowerCase();
            key = key.trim();
            String salt = "8fueSUHrh|EpICO9c!yrWGJRsf@5*rUx-Fy-MomxqeMC_}NykM+@Y:Kwu?t-4Q')";
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (Application.isValidEmail(email)) {
                String input = email + salt;
                digest.update(input.getBytes(), 0, input.length());
                byte[] bytes = digest.digest();
                String val = new BigInteger(1, bytes).toString(16);
                return key.equals(val);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceListener = new SingleInstanceListener(){

                public void newActivation(String[] args) {
                    BasicApplicationArgs argsp;
                    OpenFile openFile;
                    if (args.length > 0 && (openFile = new OpenFile(argsp = new BasicApplicationArgs(args))).containsData()) {
                        openFile.open();
                        try {
                            Application.updateRecentFilesList(new File(argsp.getData()));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)singleInstanceListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (OS.isMacOSX()) {
            if (!GraphicsEnvironment.isHeadless()) {
                SplashWindow.splash(Application.class.getResource("/org/broadinstitute/genee/resources/GENE-E-splash.gif"));
            }
            SplashWindow.startup("org.broadinstitute.genee.application.Application", args);
            SplashWindow.disposeSplash();
        } else {
            Application.startup(args);
        }
    }

    public static void nodeStructureChanged() {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                navigator.nodeStructureChanged();
            }
        });
    }

    public static void open(String path) {
        File f = new File(path);
        if (f.exists()) {
            OpenFileListener[] listenerList;
            path = IOUtil.getPath(f);
            String[] files = new String[]{path};
            for (OpenFileListener l : listenerList = Application.getOpenFileActionListeners()) {
                l.open(files, null);
            }
        }
    }

    public static boolean quit() {
        if (GraphicsEnvironment.isHeadless()) {
            System.exit(0);
            return true;
        }
        FormBuilder fb = new FormBuilder();
        fb.nextRow();
        fb.addSpanned(new JLabel("Are you sure you want to exit?"));
        List<GENEEFolderNode> newSessions = SessionSaver.getNewSessions();
        Preferences p = Preferences.userNodeForPackage(Application.class);
        JCheckBox saveSessionCheckBox = new JCheckBox("Save session", p.getBoolean("save.session", true));
        if (Application.isDevVersion() && newSessions.size() > 0) {
            fb.nextRow();
            fb.addSpanned(saveSessionCheckBox);
        }
        if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), fb.getPanel(), APP_NAME)) {
            Map<GENEEFolderNode, String> nodeToSessionName;
            if (Application.isDevVersion() && newSessions.size() > 0 && saveSessionCheckBox.isSelected() && (nodeToSessionName = SessionSaver.showGui()) != null && shutdownThread != null) {
                shutdownThread.setNewSessionName(nodeToSessionName);
            }
            p.putBoolean("save.session", saveSessionCheckBox.isSelected());
            try {
                p.sync();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            if (shutdownThread != null) {
                shutdownThread.execute();
            }
            System.exit(0);
        }
        return false;
    }

    public static boolean restoreWindowState(String key, Component window) {
        if (window == null) {
            return false;
        }
        Preferences p = Preferences.userNodeForPackage(Application.class);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String widthKey = screenSize.width + "." + screenSize.height + "." + key + ".width";
        String heighKey = screenSize.width + "." + screenSize.height + "." + key + ".height";
        String xKey = screenSize.width + "." + screenSize.height + "." + key + ".x";
        String yKey = screenSize.width + "." + screenSize.height + "." + key + ".y";
        int w = p.getInt(widthKey, -1);
        int h = p.getInt(heighKey, -1);
        int x = p.getInt(xKey, -1);
        int y = p.getInt(yKey, -1);
        if (w > 0 && h > 0 && x != -1 && y != -1) {
            window.setSize(w, h);
            window.setLocation(x, y);
            return true;
        }
        return false;
    }

    public static void setGENEEDir(File dir) {
        Preferences p = Preferences.userNodeForPackage(Application.class);
        p.put(CACHE_DIR_PROP, IOUtil.getPath(dir));
        CACHE_DIR.renameTo(dir);
        CACHE_DIR = dir;
        try {
            p.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void setWindowManager(WindowManager wm) {
        windowManager = wm;
    }

    public static void showAbout() {
        AboutAction.showAbout();
    }

    public static void showPreferences() {
        GENEETreeNode node = Application.getWindowManager().getNode();
        if (node instanceof ViewableGENEETreeNode) {
            ((HeatMapPanel)((ViewableGENEETreeNode)node).getDisplayInfo().getComponent()).getHeatMapEditorKit().getPreferencesAction().actionPerformed(null);
        }
    }

    public static void startup(String[] args) {
        Application.init(new BasicApplicationArgs(args));
        if (!Application.hasProvidedLicenseKey()) {
            new LicenseKey();
        } else {
            Application.openSessions();
        }
    }

    static Object getSingleInstanceListener() {
        return singleInstanceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getBuildStatus() {
        URL r = Application.class.getResource("/org/broadinstitute/genee/resources/build.properties");
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = r.openStream();
            props.load(is);
        }
        catch (Exception x) {
            buildStatus = 0;
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        String status = props.getProperty("status");
        buildStatus = "prod".equalsIgnoreCase(status) ? 1 : 0;
    }

    private static boolean hasProvidedLicenseKey() {
        Preferences p = Preferences.userNodeForPackage(Application.class);
        String email = p.get(APP_NAME + ".email", "");
        if (p.getBoolean(APP_NAME + ".license.key", false) && !"".equals(email)) {
            TrackerUtil.trackEvent(email, "startup");
            return true;
        }
        if (System.getProperty("genee.email") != null && System.getProperty("genee.license") != null) {
            return Application.isValidLicense(System.getProperty("genee.email").trim(), System.getProperty("genee.license").trim());
        }
        return false;
    }

    private static boolean isValidEmail(String email) {
        return (email = email.toLowerCase()).indexOf(64) != -1 && !email.contains("gmail") && !email.contains("yahoo") && !email.contains("hotmail") && !email.contains("aol.com") && !email.contains("msn.com") && !email.contains("live.com") && !email.contains("zoho.com") && !email.contains("outlook.com");
    }

    private static void openSessions() {
        UIUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OpenSessions();
            }
        });
    }

    private static void updateRecentFilesList(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(OpenRecentMenu.class);
        String currentValue = prefs.get("open.recent", null);
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<String> uniqueFiles = new LinkedHashSet<String>();
        uniqueFiles.add(file.getCanonicalPath());
        if (currentValue != null) {
            String[] filesArray = currentValue.split(";");
            int length = filesArray.length;
            for (int i = 0; i < length && uniqueFiles.size() < 11; ++i) {
                if (filesArray[i].trim().equals("")) continue;
                uniqueFiles.add(filesArray[i]);
            }
            for (String uniqueFile : uniqueFiles) {
                sb.append(";");
                sb.append(uniqueFile);
            }
        }
        prefs.put("open.recent", sb.toString());
        try {
            prefs.sync();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    static {
        exitOnClose = true;
        firstTime = true;
        initted = false;
        openFileActionListenerList = new ArrayList<OpenFileListener>();
        shutdownThread = !GraphicsEnvironment.isHeadless() ? new Shutdown() : null;
        APP_NAME = System.getProperty("application.name");
        if (APP_NAME == null) {
            APP_NAME = "GENE-E";
        }
        Application.getBuildStatus();
        String cacheDir = System.getProperty("user.home") + File.separator + Application.getName();
        try {
            Preferences p = Preferences.userNodeForPackage(Application.class);
            String tmp = p.get(CACHE_DIR_PROP, cacheDir);
            if (tmp != null) {
                cacheDir = tmp;
            }
        }
        catch (Throwable x) {
            // empty catch block
        }
        CACHE_DIR = new File(cacheDir);
        if (!CACHE_DIR.exists()) {
            CACHE_DIR.mkdirs();
        }
        boolean bl = exitOnClose = !"false".equalsIgnoreCase(System.getProperty("org.broadinstitute.genee.application.exit"));
        if (OS.isMacOSX() && !GraphicsEnvironment.isHeadless()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            if (exitOnClose) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", APP_NAME);
                OSXAdapter.setDockIconImage(IconManager.loadIcon("heatmap-64.gif").getImage());
                try {
                    OSXAdapter.setQuitHandler(Application.class, Application.class.getMethod("quit", new Class[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    OSXAdapter.setFileHandler(Application.class, Application.class.getMethod("open", String.class));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    OSXAdapter.setPreferencesHandler(Application.class, Application.class.getMethod("showPreferences", null));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    OSXAdapter.setAboutHandler(Application.class, Application.class.getDeclaredMethod("showAbout", null));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        UIUtil.standaloneInit();
    }

    private static class OpenSessions {
        private JPanel checkBoxPanel = new JPanel();
        private JPanel panel;

        private OpenSessions() {
            File[] sessionDirs = SessionSaver.getSessionDirs();
            final HashSet<String> sessions = new HashSet<String>();
            if (Application.isDevVersion() && sessionDirs.length > 0) {
                this.panel = new JPanel(new BorderLayout());
                this.panel.add((Component)new JLabel("Select sessions to load"), "North");
                this.createForm(sessionDirs);
                this.panel.add(this.checkBoxPanel);
                if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), this.panel, "Load Session")) {
                    int nc = this.checkBoxPanel.getComponentCount();
                    for (int i = 0; i < nc; ++i) {
                        Component c = this.checkBoxPanel.getComponent(i);
                        if (!(c instanceof JCheckBox) || !((AbstractButton)c).isSelected()) continue;
                        sessions.add(((AbstractButton)c).getText());
                    }
                }
            }
            if (sessions.size() > 0) {
                new BackgroundTask<GENEEFolderNode[]>("Loading session"){

                    @Override
                    protected GENEEFolderNode[] doInBackground() throws Exception {
                        TrackerUtil.logEvent("Open Session");
                        return SessionSaver.open(sessions);
                    }

                    @Override
                    protected void succeeded(GENEEFolderNode[] sessionRootDirs) {
                        try {
                            for (GENEEFolderNode rootNode : sessionRootDirs) {
                                Enumeration<TreeNode> children = rootNode.children();
                                while (children.hasMoreElements()) {
                                    GENEEFolderNode folder = (GENEEFolderNode)children.nextElement();
                                    folder.setSessionName(rootNode.getSessionName());
                                    folder.setParent(null);
                                    Application.add(folder, false);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.execute();
            }
        }

        private void createForm(File[] sessionDirs) {
            this.checkBoxPanel.removeAll();
            final FormBuilder formBuilder = new FormBuilder(this.checkBoxPanel);
            for (final File session : sessionDirs) {
                formBuilder.nextRow();
                JCheckBox cb = new JCheckBox(session.getName());
                formBuilder.addFirstColumn(cb);
                JButton deleteBtn = new JButton(new XIcon());
                deleteBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (UIUtil.showOkCancelDialog(formBuilder.getPanel(), "Really delete " + session.getName() + "?", "")) {
                            try {
                                FileUtils.deleteDirectory((File)session);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            OpenSessions.this.createForm(SessionSaver.getSessionDirs());
                            OpenSessions.this.checkBoxPanel.revalidate();
                            OpenSessions.this.checkBoxPanel.repaint();
                        }
                    }
                });
                formBuilder.add(deleteBtn);
            }
        }
    }

    private static class LicenseKey {
        private JButton activateButton;
        private TimerTextField email2;
        private JTextField emailTextField;
        private JTextField hearAbout;
        private TimerTextField licenseKeyField;
        private JTextField nameTextField;
        private JButton okButton;
        private JTextField organizationTextField;

        private LicenseKey() {
            JPanel panel1 = new JPanel(new BorderLayout());
            this.okButton = new JButton("I Agree");
            this.okButton.setEnabled(false);
            JButton cancelButton = new JButton("I Do Not Agree");
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.nextRow();
            formBuilder.addLabel("Name");
            this.nameTextField = new JTextField(40);
            this.nameTextField.setColumns(40);
            formBuilder.add(this.nameTextField);
            formBuilder.nextRow();
            formBuilder.addLabel("Email");
            this.emailTextField = new TimerTextField(){

                @Override
                public void update() {
                    LicenseKey.this.enableOkButton1();
                }
            };
            this.emailTextField.setColumns(40);
            formBuilder.add(this.emailTextField);
            formBuilder.nextRowNoSpace();
            formBuilder.add(UIUtil.createSmallLabel("academic or nonprofit email address"));
            formBuilder.nextRow();
            this.organizationTextField = new TimerTextField(){

                @Override
                public void update() {
                    LicenseKey.this.enableOkButton1();
                }
            };
            this.organizationTextField.setColumns(40);
            formBuilder.addLabel("Organization");
            formBuilder.add(this.organizationTextField);
            formBuilder.nextRow();
            formBuilder.addLabel("How did you hear about GENE-E?");
            this.hearAbout = new JTextField(40);
            formBuilder.add(this.hearAbout);
            formBuilder.nextRow();
            formBuilder.nextRow();
            JEditorPane licensePane = new JEditorPane();
            licensePane.setContentType("text/html");
            licensePane.setPreferredSize(new Dimension(400, 400));
            licensePane.setEditable(false);
            try {
                licensePane.setPage(this.getClass().getResource("/org/broadinstitute/genee/resources/License.html"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            panel1.add((Component)formBuilder.getPanel(), "North");
            panel1.add(UIUtil.createNoBorderScrollPane(licensePane));
            panel1.add((Component)UIUtil.buildOKCancelBar(this.okButton, cancelButton), "South");
            JPanel panel2 = new JPanel(new BorderLayout());
            FormBuilder builder2 = new FormBuilder();
            builder2.nextRow();
            builder2.addLabel("Email");
            this.activateButton = new JButton("Activate");
            this.email2 = new TimerTextField(){

                @Override
                public void update() {
                    LicenseKey.this.enableActivateButton();
                }
            };
            this.email2.setColumns(40);
            builder2.add(this.email2);
            builder2.nextRow();
            builder2.addLabel("License Key");
            this.licenseKeyField = new TimerTextField(){

                @Override
                public void update() {
                    LicenseKey.this.enableActivateButton();
                }
            };
            this.licenseKeyField.setColumns(40);
            builder2.add(this.licenseKeyField);
            panel2.add(builder2.getPanel());
            this.activateButton.setEnabled(false);
            JButton cancelButton2 = new JButton("Exit");
            panel2.add((Component)UIUtil.buildOKCancelBar(this.activateButton, cancelButton2), "South");
            cancelButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(1);
                }
            });
            final JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("Register", panel1);
            tabbedPane.addTab("Activate GENE-E", panel2);
            final JDialog dialog = new JDialog(UIUtil.getCurrentFrame(), "GENE-E License");
            this.activateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key;
                    String email = LicenseKey.this.email2.getText().trim();
                    if (Application.isValidLicense(email, key = LicenseKey.this.licenseKeyField.getText().trim())) {
                        Preferences p = Preferences.userNodeForPackage(Application.class);
                        p.putBoolean(APP_NAME + ".license.key", true);
                        p.put(APP_NAME + ".license", key);
                        try {
                            p.sync();
                            dialog.dispose();
                        }
                        catch (BackingStoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            UIUtil.setDialogBorder((JComponent)dialog.getContentPane());
            dialog.getContentPane().add(tabbedPane);
            dialog.setModal(true);
            dialog.setDefaultCloseOperation(0);
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(1);
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    String email = LicenseKey.this.emailTextField.getText().trim().toLowerCase();
                    String hear = LicenseKey.this.hearAbout.getText();
                    String name = LicenseKey.this.nameTextField.getText().trim();
                    String organization = LicenseKey.this.organizationTextField.getText();
                    InputStream is = null;
                    try {
                        int bytesRead;
                        URL url = new URL("http://www.broadinstitute.org/cancer/software/GENE-E/register.php?email=" + URLEncoder.encode(email, "UTF-8") + "&name=" + URLEncoder.encode(name, "UTF-8") + "&organization=" + URLEncoder.encode(organization, "UTF-8") + "&hear=" + URLEncoder.encode(hear, "UTF-8"));
                        URLConnection con = url.openConnection();
                        is = con.getInputStream();
                        byte[] response = new byte[100];
                        StringBuilder sb = new StringBuilder();
                        while ((bytesRead = is.read(response)) != -1) {
                            sb.append(new String(response, 0, bytesRead));
                        }
                        if ("1".equals(sb.toString().trim())) {
                            Preferences p = Preferences.userNodeForPackage(Application.class);
                            p.put(APP_NAME + ".email", email);
                            p.put(APP_NAME + ".name", name);
                            p.put(APP_NAME + ".organization", organization);
                            p.sync();
                            LicenseKey.this.email2.setText(email);
                            tabbedPane.setSelectedIndex(1);
                            UIUtil.showMessageDialog(dialog, "Please check your email for your license key. This make take a minute.");
                        } else {
                            UIUtil.showErrorDialog(dialog, "Unable to register. Please try again.");
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        UIUtil.showErrorDialog(dialog, "Unable to register. Please try again.");
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e1) {}
                        }
                    }
                }
            });
            dialog.setVisible(true);
            dialog.dispose();
        }

        private void enableActivateButton() {
            this.activateButton.setEnabled(Application.isValidLicense(this.email2.getText().trim(), this.licenseKeyField.getText().trim()));
        }

        private void enableOkButton1() {
            String email = this.emailTextField.getText().trim().toLowerCase();
            this.okButton.setEnabled(email.length() > 0 && this.organizationTextField.getText().length() > 0 && Application.isValidEmail(email));
        }
    }

    private static class DefaultOpenFileListener
    implements OpenFileListener {
        private DefaultOpenFileListener() {
        }

        @Override
        public void open(String[] files, String fileType) {
            if ("LMNX".equals(fileType)) {
                LuminexImporter.showLuminexImportUI(files);
            } else if (fileType != null) {
                new OpenPlateFiles(files, fileType);
            } else {
                try {
                    OpenDatasetFile.load(files);
                }
                catch (Exception e) {
                    UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), e.getMessage());
                    System.gc();
                }
            }
            if (files.length == 1) {
                try {
                    Application.updateRecentFilesList(new File(files[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Version {
        public String date;
        public String versionString;

        public Version(String version2, String date2) {
            this.versionString = version2;
            this.date = date2;
        }

        public boolean isLatest() {
            return "Latest version".equals(this.versionString);
        }
    }

    public static class BasicApplicationArgs
    implements ApplicationArgs {
        private String archive;
        private String atr;
        private String ca;
        private String cc;
        private String data;
        private boolean delete;
        private String gtr;
        private String ra;
        private String rc;
        private Map<String, List<String>> unparsed = new HashMap<String, List<String>>();

        public BasicApplicationArgs(String[] args) {
            if (args.length == 1 && new File(args[0]).exists()) {
                this.data = args[0];
            } else {
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.equals("--archive")) {
                        this.archive = args[++i];
                        continue;
                    }
                    if (arg.equals("--col-dend")) {
                        this.atr = args[++i];
                        continue;
                    }
                    if (arg.equals("--row-dend")) {
                        this.gtr = args[++i];
                        continue;
                    }
                    if (arg.equals("--data") || arg.equals("-open")) {
                        this.data = args[++i];
                        continue;
                    }
                    if (arg.equals("--col-text")) {
                        this.ca = args[++i];
                        continue;
                    }
                    if (arg.equals("--col-color-bar")) {
                        this.cc = args[++i];
                        continue;
                    }
                    if (arg.equals("--row-text")) {
                        this.ra = args[++i];
                        continue;
                    }
                    if (arg.equals("--row-color-bar")) {
                        this.rc = args[++i];
                        continue;
                    }
                    if (arg.equals("--deleteJnlp")) {
                        this.delete = Boolean.valueOf(args[++i]);
                        continue;
                    }
                    List<String> list = this.unparsed.get(arg);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.unparsed.put(arg, list);
                    }
                    list.add(args[++i]);
                }
            }
        }

        @Override
        public void after() {
            String file;
            if (this.delete && (file = System.getProperty("jnlpx.origFilenameArg")) != null && new File(file).exists()) {
                new File(file).delete();
            }
        }

        @Override
        public String getArchive() {
            return this.archive;
        }

        @Override
        public String getAtr() {
            return this.atr;
        }

        @Override
        public String getColumnColorBarColumns() {
            return this.cc;
        }

        @Override
        public String getColumnTextColumns() {
            return this.ca;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getGtr() {
            return this.gtr;
        }

        @Override
        public String getRowColorBarColumns() {
            return this.rc;
        }

        @Override
        public String getRowTextColumns() {
            return this.ra;
        }

        @Override
        public Map<String, List<String>> getUnparsed() {
            return this.unparsed;
        }

        @Override
        public boolean isAtr() {
            return this.atr != null;
        }

        @Override
        public boolean isColumnColorBarColumns() {
            return this.cc != null;
        }

        @Override
        public boolean isColumnTextColumns() {
            return this.ca != null;
        }

        @Override
        public boolean isData() {
            return this.data != null;
        }

        @Override
        public boolean isGtr() {
            return this.gtr != null;
        }

        @Override
        public boolean isRowColorBarColumns() {
            return this.rc != null;
        }

        @Override
        public boolean isRowTextColumns() {
            return this.ra != null;
        }
    }

    public static interface ApplicationArgs {
        public String getAtr();

        public String getColumnColorBarColumns();

        public String getColumnTextColumns();

        public String getData();

        public String getGtr();

        public String getRowColorBarColumns();

        public String getRowTextColumns();

        public Map<String, List<String>> getUnparsed();

        public boolean isAtr();

        public boolean isColumnColorBarColumns();

        public boolean isColumnTextColumns();

        public boolean isData();

        public boolean isGtr();

        public boolean isRowColorBarColumns();

        public boolean isRowTextColumns();

        public void after();

        public String getArchive();
    }
}

