/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindowNotifier;
import org.broadinstitute.genee.gui.UIUtil;

public class DialogWindow
extends JDialog
implements DefaultWindowManager.WMWindow {
    private String baseName;
    private GENEEWindowNotifier notifier;
    private boolean shown = false;
    private boolean initted;
    private int type;

    public DialogWindow(Window parent, int type, GENEEWindowNotifier notifier) {
        super(parent);
        this.notifier = notifier;
        this.setFocusable(true);
        this.installKeyboardActions();
        this.type = type;
        if (type == 2) {
            UIUtil.setDialogBorder((JComponent)this.getContentPane());
        }
    }

    @Override
    public boolean activate() {
        return this.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.notifier != null) {
            this.notifier.notifyHidden();
        }
        this.shown = false;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public GENEETreeNode getNode() {
        return null;
    }

    @Override
    public int getWindowType() {
        return this.type;
    }

    @Override
    public void pack() {
        super.pack();
        Dimension size = this.getSize();
        Dimension maxWindowSize = UIUtil.getMaximumWindowSize();
        boolean changed = false;
        if (size.height > maxWindowSize.height) {
            size.height = maxWindowSize.height;
            changed = true;
        }
        if (size.width > maxWindowSize.width) {
            size.width = maxWindowSize.width;
            changed = true;
        }
        if (changed) {
            this.setSize(size);
        }
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            if (this.getRootPane().getDefaultButton() != null) {
                this.getRootPane().getDefaultButton().requestFocusInWindow();
            }
            if (!this.shown && this.notifier != null) {
                this.notifier.notifyShowing();
            }
            this.shown = true;
            if (!this.initted && !this.isVisible()) {
                Dimension primaryScreenSize = UIUtil.getMaximumWindowSize();
                int screenWidth = primaryScreenSize.width;
                int screenHeight = primaryScreenSize.height;
                if (this.type == 1) {
                    int x = screenWidth / 2;
                    int sum = x + this.getWidth();
                    if (sum >= screenWidth) {
                        x -= sum - screenWidth;
                    }
                    this.setLocation(x, screenHeight / 2 - this.getHeight() / 2);
                } else if (this.type == 2) {
                    int x = screenWidth / 2 - this.getWidth() / 2;
                    int sum = x + this.getWidth();
                    if (sum >= screenWidth) {
                        x -= sum - screenWidth;
                    }
                    this.setLocation(x, screenHeight / 2 - this.getHeight() / 2);
                }
                this.initted = true;
            }
        }
        super.setVisible(visible);
        if (!visible) {
            if (this.notifier != null) {
                this.notifier.notifyHidden();
            }
            this.shown = false;
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 87 && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
            this.setVisible(false);
            e.consume();
        } else {
            JFrame frame;
            JMenuBar menuBar;
            super.processKeyEvent(e);
            if (!e.isConsumed() && this.getOwner() instanceof JFrame && (menuBar = (frame = (JFrame)this.getOwner()).getJMenuBar()) != null) {
                menuBar.dispatchEvent(e);
            }
        }
    }

    private void installKeyboardActions() {
        AbstractAction closeAction = new AbstractAction("closeWindow"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogWindow.this.setVisible(false);
            }
        };
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(87, UIUtil.getMenuShortcutKeyMask()), "closeWindow");
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "closeWindow");
        this.rootPane.getActionMap().put("closeWindow", closeAction);
    }
}

