/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import com.jidesoft.docking.DockableFrame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.DefaultViewableGENEETreeNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.heatmap.DisplayInfo;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.persistence.GENEEOptions;

public class ProjectGENEEResultTreeNode
extends DefaultViewableGENEETreeNode {
    private transient boolean customized;
    private transient GENEEResultNodeGroup group;
    private transient List<Action> popupActions;
    private transient Project project;

    public ProjectGENEEResultTreeNode(Project project, DisplayInfo displayInfo, History history) {
        super(displayInfo, history);
        this.project = project;
        GENEEOptions options = (GENEEOptions)project.getOriginalDataset().getProperty("genee.options");
        if (options != null) {
            this.auditTrail = options.getAuditTrail();
            project.getOriginalDataset().setProperty("genee.options", null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(project.getOriginalDataset().getName());
        sb.append(this.getDimensionString());
        this.setUserObject(sb.toString());
        project.getOriginalDataset().setProperty("project.node", this);
    }

    public ProjectGENEEResultTreeNode(Project project, History history) {
        this(project, history, null);
    }

    public ProjectGENEEResultTreeNode(Project project, History history, ComponentCustomizer c) {
        this(project, ProjectGENEEResultTreeNode.createDefaultDisplayInfo(project, c), history);
    }

    public ProjectGENEEResultTreeNode(Project project, JComponent c, History history) {
        this(project, new DisplayInfo(c), history);
    }

    public void addPopupAction(Action action) {
        if (this.popupActions == null) {
            this.popupActions = new ArrayList<Action>();
            if (action != null) {
                this.popupActions.add(null);
            }
        }
        this.popupActions.add(action);
    }

    public GENEEResultNodeGroup getGroup() {
        return this.group;
    }

    public List<Action> getPopupActions() {
        return this.popupActions;
    }

    public final Project getProject() {
        return this.project;
    }

    public void setGroup(GENEEResultNodeGroup group) {
        this.group = group;
    }

    @Override
    public void setNodeName(String name) {
        this.getProject().getOriginalDataset().setName(name);
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(this.getDimensionString());
        super.setNodeName(sb.toString());
    }

    public void setParentResultNode(ViewableGENEETreeNode resultNode) {
        DockableFrame parentFrame = (DockableFrame)resultNode.getDisplayInfo().getComponent().getClientProperty("GENE-E.DockableFrame");
        if (parentFrame != null) {
            this.parentFrameKey = parentFrame.getKey();
        }
        ArrayList<ViewableGENEETreeNode> parents = new ArrayList<ViewableGENEETreeNode>();
        for (TreeNode root = resultNode; root != null; root = root.getParent()) {
            if (!(root instanceof ViewableGENEETreeNode) || !(root.getDisplayInfo().getComponent() instanceof HeatMapPanel)) continue;
            parents.add((ViewableGENEETreeNode)root);
        }
        int size = parents.size();
        for (int i = 0; i < size; ++i) {
            ViewableGENEETreeNode parentProjectInfo = (ViewableGENEETreeNode)parents.get(i);
            if (parentProjectInfo.getDisplayInfo().getComponentCustomizer() == null || !parentProjectInfo.getDisplayInfo().getComponentCustomizer().inherits()) continue;
            parentProjectInfo.getDisplayInfo().getComponentCustomizer().customize(this.getDisplayInfo().getComponent());
        }
        if (resultNode != null) {
            ViewableGENEETreeNode immediateAncestor = resultNode;
            this.auditTrail.addAll(immediateAncestor.getAuditTrail());
            HeatMapPanel parentPanel = (HeatMapPanel)immediateAncestor.getDisplayInfo().getComponent();
            ((HeatMapPanel)this.getDisplayInfo().getComponent()).initFromParent(parentPanel);
        }
        this.customize();
    }

    private void customize() {
        if (!this.customized) {
            this.customized = true;
            if (this.getDisplayInfo().getComponentCustomizer() != null) {
                this.getDisplayInfo().getComponentCustomizer().customize(this.getDisplayInfo().getComponent());
            }
        }
    }

    private String getDimensionString() {
        if (this.project.getOriginalDataset() == null) {
            return "";
        }
        return " (" + this.project.getOriginalDataset().getRowCount() + " \u00d7 " + this.project.getOriginalDataset().getColumnCount() + ")";
    }

    private static DisplayInfo createDefaultDisplayInfo(Project project, ComponentCustomizer c) {
        GENEEOptions options = (GENEEOptions)project.getOriginalDataset().getProperty("genee.options");
        if (options != null) {
            GENEEOptions.configureMetadata(project, options);
        }
        HeatMapPanel heatMapPanel = new HeatMapPanel(project);
        if (options != null) {
            GENEEOptions.configureHeatMap(heatMapPanel, options);
        }
        return new DisplayInfo(heatMapPanel, c);
    }
}

