/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.application;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.tree.QuickTreeFilterField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DefaultWindowManager;
import org.broadinstitute.genee.application.ExternalFileGENEETreeNode;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.HistoryParameter;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.RevealInFinder;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.BrowserLauncher;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.io.util.IOUtil;

public class TreeNavigator {
    private Action deleteNodeAction;
    private Action editNodeNameAction;
    private Action openNodeAction;
    private ParametersPanel parametersPanel;
    private JScrollPane parametersScrollPane;
    private JideSplitPane splitPane;
    private JTree tree;
    private DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode("Root"));
    private GENEEWindow window;

    public TreeNavigator() {
        QuickTreeFilterField field = new QuickTreeFilterField((TreeModel)this.treeModel);
        this.tree = new JTree((TreeModel)field.getDisplayTreeModel()){

            @Override
            public void addNotify() {
                super.addNotify();
                ToolTipManager.sharedInstance().registerComponent(this);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                TreePath path = TreeNavigator.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return null;
                }
                TreeNode node = (TreeNode)path.getLastPathComponent();
                if (node instanceof GENEETreeNode && RevealInFinder.isEnabled(node)) {
                    return IOUtil.getPath(((GENEETreeNode)node).getFile().getParentFile()) + File.separator + node.toString();
                }
                return null;
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                ToolTipManager.sharedInstance().unregisterComponent(this);
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                JFrame frame;
                JMenuBar menuBar;
                super.processKeyEvent(e);
                if (!e.isConsumed() && (menuBar = (frame = (JFrame)UIUtil.getCurrentFrame()).getJMenuBar()) != null) {
                    menuBar.dispatchEvent(e);
                }
            }
        };
        field.setHintText("Search");
        field.setHideEmptyParentNode(true);
        field.setTree(this.tree);
        field.setCaseSensitive(false);
        field.setWildcardEnabled(true);
        this.tree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (e.getKeyChar() == '\u007f' || e.getKeyChar() == '\b') {
                    TreeNode[] nodes = TreeNavigator.this.getSelectedNodes();
                    if (nodes.length > 0) {
                        DefaultWindowManager.promptToDelete(nodes);
                    }
                    e.consume();
                } else if (e.getKeyChar() == '\n') {
                    TreeNode[] nodes;
                    for (TreeNode node : nodes = TreeNavigator.this.getSelectedNodes()) {
                        TreeNavigator.this.setSelectedNode(node, true);
                    }
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setRootVisible(false);
        this.tree.setToggleClickCount(-1);
        this.openNodeAction = new AbstractAction("Open"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode[] nodes;
                for (TreeNode node : nodes = TreeNavigator.this.getSelectedNodes()) {
                    TreeNavigator.this.setSelectedNode(node, true);
                }
            }
        };
        this.deleteNodeAction = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode[] nodes = TreeNavigator.this.getSelectedNodes();
                if (nodes.length > 0) {
                    DefaultWindowManager.promptToDelete(nodes);
                }
            }
        };
        this.editNodeNameAction = new AbstractAction("Edit Title"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeNode node = (TreeNode)TreeNavigator.this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
                String newName = UIUtil.showInputDialog(UIUtil.getCurrentFrame(), "Enter new title", node.toString());
                if (newName != null) {
                    Application.getWindowManager().setName((GENEETreeNode)node, newName);
                }
            }
        };
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                if (path != null) {
                    TreeNode node = (TreeNode)path.getLastPathComponent();
                    TreeNavigator.this.showHistory(node);
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (!e.isPopupTrigger() && e.getClickCount() == 2 && (path = TreeNavigator.this.tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    TreeNode node = (TreeNode)path.getLastPathComponent();
                    if (e.isShiftDown()) {
                        TreeNode[] nodes;
                        for (TreeNode n : nodes = TreeNavigator.this.getSelectedNodes()) {
                            TreeNavigator.this.setSelectedNode(n, true);
                        }
                    }
                    TreeNavigator.this.setSelectedNode(node, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = TreeNavigator.this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                TreeNode node = (TreeNode)path.getLastPathComponent();
                if (node instanceof ViewableGENEETreeNode) {
                    TreeNavigator.this.showHistory((ViewableGENEETreeNode)node);
                }
                if (e.isPopupTrigger()) {
                    this.showPopup(e, path, node);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath path = TreeNavigator.this.tree.getPathForLocation(e.getX(), e.getY());
                    if (path == null) {
                        return;
                    }
                    TreeNode node = (TreeNode)path.getLastPathComponent();
                    this.showPopup(e, path, node);
                }
            }

            private void showPopup(MouseEvent e, TreePath path, TreeNode node) {
                List<Action> actions = node instanceof ProjectGENEEResultTreeNode ? ((ProjectGENEEResultTreeNode)node).getPopupActions() : null;
                JPopupMenu popupMenu = new JPopupMenu();
                popupMenu.add(TreeNavigator.this.openNodeAction);
                if (RevealInFinder.isEnabled(node)) {
                    popupMenu.add(new RevealInFinder((GENEETreeNode)node));
                }
                popupMenu.addSeparator();
                popupMenu.add(TreeNavigator.this.editNodeNameAction);
                popupMenu.addSeparator();
                popupMenu.add(TreeNavigator.this.deleteNodeAction);
                if (actions != null && actions.size() > 0) {
                    for (Action action : actions) {
                        if (action == null) {
                            popupMenu.addSeparator();
                            continue;
                        }
                        popupMenu.add(action);
                    }
                }
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                Object[] children = e.getChildren();
                TreeNode node = (TreeNode)children[children.length - 1];
                TreeNavigator.this.setSelectedNode(node, true);
                TreeNode parent = node.getParent();
                TreePath parentPath = new TreePath(TreeNavigator.getPathToRoot(parent, 0));
                TreePath nodePath = new TreePath(TreeNavigator.getPathToRoot(node, 0));
                TreeNavigator.this.tree.setSelectionPath(nodePath);
                TreeNavigator.this.tree.expandPath(parentPath);
                TreeNavigator.this.tree.scrollPathToVisible(nodePath);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.window = Application.getWindowManager().createToolWindow("Navigator", 8, 2);
        if (this.window != null) {
            this.window.setSize(200, 400);
        }
        this.splitPane = new JideSplitPane(0);
        this.parametersPanel = new ParametersPanel();
        JPanel panel = new JPanel(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        JPanel northPanel = new JPanel((LayoutManager)new FormLayout("p, 4px, p:grow:fill, 2px", "p"));
        northPanel.add((Component)field, cc.xy(1, 1));
        panel.add((Component)northPanel, "North");
        panel.add(UIUtil.createNoBorderScrollPane(this.tree));
        this.splitPane.addPane((Component)panel);
        this.parametersScrollPane = UIUtil.createNoBorderScrollPane(this.parametersPanel);
        this.parametersScrollPane.setVisible(false);
        this.splitPane.addPane((Component)this.parametersScrollPane);
        if (this.window != null) {
            this.window.getContentPane().add((Component)this.splitPane);
        }
    }

    public void delete(TreeNode node) {
        TreeNode parent = node.getParent();
        try {
            this.treeModel.removeNodeFromParent((MutableTreeNode)node);
        }
        catch (IllegalArgumentException e) {
            System.out.println("node does not have a parent");
            return;
        }
        if (parent.getChildCount() == 0 && parent instanceof GENEEFolderNode && this.tree.getModel().getRoot() != parent) {
            this.treeModel.removeNodeFromParent((MutableTreeNode)parent);
        }
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
        this.treeModel.nodeStructureChanged((TreeNode)this.tree.getModel().getRoot());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                this.tree.expandPath(treePath);
            }
        }
    }

    public TreeNode getRoot() {
        return (TreeNode)this.tree.getModel().getRoot();
    }

    public Component getWindow() {
        return (Component)((Object)this.window);
    }

    public void nodeStructureChanged() {
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
        TreePath selectionPath = this.tree.getSelectionPath();
        this.treeModel.nodeStructureChanged((TreeNode)this.tree.getModel().getRoot());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                this.tree.expandPath(treePath);
            }
        }
        this.tree.setSelectionPath(selectionPath);
    }

    public void setNodeName(GENEETreeNode node, String name) {
        node.setNodeName(name);
        this.treeModel.nodeChanged(node);
        this.tree.invalidate();
        this.tree.validate();
        this.tree.repaint();
    }

    public void setSelectedNode(TreeNode node, boolean openTab) {
        TreeNode parent = node.getParent();
        TreePath parentPath = new TreePath(TreeNavigator.getPathToRoot(parent, 0));
        TreePath nodePath = new TreePath(TreeNavigator.getPathToRoot(node, 0));
        this.tree.setSelectionPath(nodePath);
        this.tree.expandPath(parentPath);
        this.tree.scrollPathToVisible(nodePath);
        if (openTab && node instanceof ViewableGENEETreeNode) {
            Application.getWindowManager().open((ViewableGENEETreeNode)node);
        } else if (node instanceof ViewableGENEETreeNode) {
            this.showHistory((ViewableGENEETreeNode)node);
        } else if (node instanceof ExternalFileGENEETreeNode) {
            BrowserLauncher.openFile(((ExternalFileGENEETreeNode)node).getFile());
        }
    }

    private TreeNode[] getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionModel().getSelectionPaths();
        if (paths != null) {
            TreeNode[] nodes = new TreeNode[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                nodes[i] = (TreeNode)paths[i].getLastPathComponent();
            }
            return nodes;
        }
        return new TreeNode[0];
    }

    private void showHistory(TreeNode node) {
        if (node instanceof ViewableGENEETreeNode) {
            History history = ((ViewableGENEETreeNode)node).getAuditTrail().last();
            if (history.getParameters().size() > 0) {
                this.parametersPanel.setHistory(history);
                int parametersHeight = this.parametersPanel.getPreferredSize().height;
                if (parametersHeight > 200) {
                    parametersHeight = 200;
                }
                int windowHeight = this.window.getHeight();
                int topHeight = windowHeight - parametersHeight - 40;
                this.splitPane.setDividerLocation(0, topHeight);
                this.parametersScrollPane.setVisible(true);
            } else {
                this.parametersScrollPane.setVisible(false);
            }
        } else {
            this.parametersScrollPane.setVisible(false);
        }
    }

    public static TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = TreeNavigator.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    private static class ParametersPanel
    extends JPanel {
        private ParametersPanel() {
            this.setBackground(Color.WHITE);
        }

        public void setHistory(History history) {
            this.setVisible(history != null);
            this.removeAll();
            if (history != null) {
                FormBuilder builder = new FormBuilder(this);
                List<HistoryParameter> params = history.getParameters();
                for (HistoryParameter entry : params) {
                    builder.nextRow();
                    String name = entry.getKey();
                    String value = entry.getValue();
                    if (value != null) {
                        builder.addLabel(name + ":");
                        builder.add(new JLabel(value));
                        continue;
                    }
                    builder.addLabel(name);
                }
            }
            this.revalidate();
            this.repaint();
        }
    }
}

