/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.icons.IconsFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.ColumnHeaderMouseListener;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.table.IconAdapter;
import org.broadinstitute.genee.table.SortingHelper;

public abstract class AbstractColumnHeaderPanel
extends JPanel {
    public static final String TOOL_TIP = "Click to sort. Shift-click to sort multiple columns simultaneously. Alt-click to group.";
    private MetadataModel metadataModel;
    protected Project project;
    private ProjectListener projectListener;
    private MouseAdapter mouseListener;
    private Object metadataKey;
    private boolean showSortIcon = true;

    public AbstractColumnHeaderPanel(HeatMapPanel heatMapPanel, Object key) {
        this.metadataKey = key;
        this.setMinimumSize(new Dimension());
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.projectListener = new ProjectListener(){

            @Override
            public void projectChanged(ProjectEvent e) {
                if (e == null || e.isColumnChanged()) {
                    AbstractColumnHeaderPanel.this.metadataModel = AbstractColumnHeaderPanel.this.getModel();
                    AbstractColumnHeaderPanel.this.layoutLabels();
                }
            }
        };
        this.mouseListener = new ColumnHeaderMouseListener(heatMapPanel, key);
        this.addMouseListener(this.mouseListener);
    }

    public abstract int getSize(int var1);

    public void setBoldedMetadataIndex(int boldedMetadataIndex) {
        int cc = this.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            JComponent c = (JComponent)this.getComponent(i);
            Integer metadataIndex = (Integer)c.getClientProperty("metadataIndex");
            if (metadataIndex != null && metadataIndex == boldedMetadataIndex) {
                c.setForeground(UIUtil.HIGHLIGHT_COLOR);
                continue;
            }
            c.setForeground(Color.BLACK);
        }
    }

    public void setProject(Project project) {
        if (this.project != null) {
            this.project.removeProjectListener(this.projectListener);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addProjectListener(this.projectListener);
            this.projectListener.projectChanged(null);
        }
    }

    public void setShowSortIcon(boolean showSortIcon) {
        this.showSortIcon = showSortIcon;
        this.layoutLabels();
    }

    protected void layoutLabels() {
        int cc = this.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            this.getComponent(i).removeMouseListener(this.mouseListener);
        }
        this.removeAll();
        if (this.metadataModel == null) {
            return;
        }
        int count = this.metadataModel.getMetadataCount();
        StringBuilder rowString = new StringBuilder("1px");
        for (int i = 0; i < count; ++i) {
            rowString.append(", ");
            rowString.append("b:");
            int size = this.getSize(i);
            if (size != -1) {
                rowString.append(size);
                rowString.append("px:none");
                continue;
            }
            rowString.append("p");
        }
        rowString.append(", 1px");
        this.setLayout((LayoutManager)new FormLayout("right:p:g:bottom", rowString.toString()));
        List<ProjectSortKey> sortKeys = this.project.getColumnSortKeys();
        if (sortKeys == null) {
            sortKeys = Collections.emptyList();
        }
        CellConstraints cc2 = new CellConstraints();
        int i = 0;
        int cy = count + 1;
        while (i < count) {
            JLabel label = new JLabel(this.metadataModel.get(i).getName());
            label.putClientProperty("metadataIndex", i);
            label.setToolTipText("<html>" + this.metadataModel.get(i).getName() + "<br>" + TOOL_TIP);
            label.setFont(new Font(UIUtil.getFontName(), 0, Math.min(16, this.getSize(i) - 1)));
            label.setHorizontalTextPosition(4);
            label.addMouseListener(this.mouseListener);
            Icon icon = null;
            if (this.showSortIcon) {
                int sortIndex = sortKeys.indexOf(new SortKeys.VectorSortKey(this.metadataModel.get(i).getName(), SortOrder.UNSORTED, false));
                ProjectSortKey sortKey = sortIndex != -1 ? sortKeys.get(sortIndex) : new SortKeys.VectorSortKey(this.metadataModel.get(i).getName(), SortOrder.UNSORTED, false);
                icon = SortingHelper.getIcon(this.project.getColumnSortKeys(), sortKey);
            }
            if (icon != null && icon.getIconHeight() > this.getSize(i)) {
                ImageIcon imageIcon = null;
                imageIcon = icon instanceof ImageIcon ? (ImageIcon)icon : new ImageIcon(((ImageIcon)((IconAdapter)icon).getIcon()).getImage());
                icon = IconsFactory.getScaledImage((Component)label, (ImageIcon)imageIcon, (int)this.getSize(i), (int)icon.getIconHeight());
            }
            label.setIcon(icon);
            this.add((Component)label, cc2.xy(1, cy));
            ++i;
            --cy;
        }
        this.revalidate();
        this.repaint();
    }

    public MetadataModel getModel() {
        Dataset dataset = this.project.getSortedFilteredDataset();
        MetadataModel model = MetadataUtil.filter(dataset.getColumnMetadata(), this.metadataKey);
        return model;
    }
}

