/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.matrix.Vector;

public abstract class ColorPanel
extends JPanel
implements Drawable {
    protected VectorColorModel categoryColorModel;
    protected SizesAndPositions sizesAndPositions;
    protected int categorySize = 10;
    protected boolean gridVisible = true;

    public ColorPanel() {
        this.setMinimumSize(new Dimension());
        this.setBackground(Color.WHITE);
        this.setSizePerClass(this.categorySize);
    }

    public VectorColorModel getCategoryColorModel() {
        return this.categoryColorModel;
    }

    public Color getColor(Vector categoryGroup, String category) {
        return (Color)this.categoryColorModel.getMappedValue(categoryGroup, category);
    }

    public int getSizePerClass() {
        return this.categorySize;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setCategoryColorModel(VectorColorModel categoryColorModel) {
        this.categoryColorModel = categoryColorModel;
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public void setSizePerClass(int size) {
        int oldValue = this.categorySize;
        this.categorySize = size;
        this.revalidate();
        this.firePropertyChange("sizePerClass", oldValue, this.categorySize);
    }

    public void setSizesAndPositions(SizesAndPositions sizesAndPositions) {
        this.sizesAndPositions = sizesAndPositions;
    }
}

