/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.broadinstitute.genee.category.MetadataPopup;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.table.SortingHelper;

public class ColumnHeaderMouseListener
extends MouseAdapter {
    public static final String METADATA_INDEX = "metadataIndex";
    private HeatMapPanel heatMapPanel;
    private Object metadataKey;

    public ColumnHeaderMouseListener(HeatMapPanel heatMapPanel, Object metadataKey) {
        this.heatMapPanel = heatMapPanel;
        this.metadataKey = metadataKey;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        Integer metadataIndex = (Integer)c.getClientProperty(METADATA_INDEX);
        if (metadataIndex == null) {
            metadataIndex = -1;
        }
        Project project = this.heatMapPanel.getProject();
        MetadataModel metadataModel = project.getSortedFilteredDataset().getColumnMetadata();
        metadataModel = MetadataUtil.filter(metadataModel, this.metadataKey);
        if (e.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            new MetadataPopup(this.heatMapPanel, project, metadataModel, metadataIndex, popupMenu, false);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        } else if (metadataIndex != -1 && SwingUtilities.isLeftMouseButton(e)) {
            boolean additionalSort = e.isShiftDown();
            boolean isAltDown = e.isAltDown();
            List<? extends ProjectSortKey> sortKeys = project.getColumnSortKeys();
            ProjectSortKey[] groupByKeys = project.getColumnGroupBy();
            ProjectSortKey sortKey = new SortKeys.VectorSortKey(metadataModel.get(metadataIndex).getName(), SortOrder.ASCENDING, false);
            int sortKeyIndex = sortKeys.indexOf(sortKey);
            if (sortKeyIndex != -1) {
                sortKey = sortKeys.get(sortKeyIndex);
                SortOrder sortOrder = SortingHelper.toggleSortOrder(sortKey);
                sortKey.setSortOrder(sortOrder);
            }
            if (isAltDown) {
                groupByKeys = new ProjectSortKey[]{sortKey};
            }
            SortingHelper.setSortOrder(project, sortKey, additionalSort, false, groupByKeys);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            JComponent c = (JComponent)e.getSource();
            Integer metadataIndex = (Integer)c.getClientProperty(METADATA_INDEX);
            if (metadataIndex == null) {
                metadataIndex = -1;
            }
            Project project = this.heatMapPanel.getProject();
            MetadataModel metadataModel = project.getSortedFilteredDataset().getColumnMetadata();
            metadataModel = MetadataUtil.filter(metadataModel, this.metadataKey);
            new MetadataPopup(this.heatMapPanel, project, metadataModel, metadataIndex, popupMenu, false);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

