/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.category;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QualitativeColorSchemes {
    public static final Color[] TEN_COLORS = new Color[]{new Color(31, 119, 180), new Color(255, 127, 14), new Color(44, 160, 44), new Color(214, 39, 40), new Color(148, 103, 189), new Color(140, 86, 75), new Color(227, 119, 194), new Color(127, 127, 127), new Color(188, 189, 34), new Color(23, 190, 207)};
    public static final Color[] TWENTY_COLORS = new Color[]{new Color(31, 119, 180), new Color(174, 199, 232), new Color(255, 127, 14), new Color(255, 187, 120), new Color(44, 160, 44), new Color(152, 223, 138), new Color(214, 39, 40), new Color(255, 152, 150), new Color(148, 103, 189), new Color(197, 176, 213), new Color(140, 86, 75), new Color(196, 156, 148), new Color(227, 119, 194), new Color(247, 182, 210), new Color(127, 127, 127), new Color(199, 199, 199), new Color(188, 189, 34), new Color(219, 219, 141), new Color(23, 190, 207), new Color(158, 218, 229)};
    private static Map<Integer, List<Color[]>> numberOfClassesToSchemes = new HashMap<Integer, List<Color[]>>();
    private Map<Integer, Integer> numberOfClassesToListOffset = new HashMap<Integer, Integer>();

    public Color[] getColors(int numberOfClasses) {
        if (numberOfClasses < 3) {
            numberOfClasses = 3;
        }
        if (numberOfClasses >= TEN_COLORS.length) {
            return numberOfClasses >= TWENTY_COLORS.length ? TWENTY_COLORS : TEN_COLORS;
        }
        Integer offset = this.numberOfClassesToListOffset.get(numberOfClasses);
        if (offset == null) {
            offset = 0;
        }
        List<Color[]> list = numberOfClassesToSchemes.get(numberOfClasses);
        this.numberOfClassesToListOffset.put(numberOfClasses, offset + 1);
        if (list == null || offset >= list.size()) {
            list = null;
            for (int i = numberOfClasses + 1; i < 10; ++i) {
                offset = this.numberOfClassesToListOffset.get(i);
                if (offset == null) {
                    offset = 0;
                }
                this.numberOfClassesToListOffset.put(i, offset + 1);
                List<Color[]> testList = numberOfClassesToSchemes.get(i);
                if (offset >= testList.size()) continue;
                list = testList;
                break;
            }
        }
        if (list == null) {
            return numberOfClasses >= TWENTY_COLORS.length ? TWENTY_COLORS : TEN_COLORS;
        }
        return list.get(offset);
    }

    public static Color getTenColor(int index) {
        return TEN_COLORS[index % TEN_COLORS.length];
    }

    public static Color getTwentyColor(int index) {
        return TWENTY_COLORS[index % TWENTY_COLORS.length];
    }

    private static void createArray(String ... strings) {
        Color[] colors = new Color[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            colors[i] = Color.decode(strings[i]);
        }
        List<Color[]> list = numberOfClassesToSchemes.get(colors.length);
        if (list == null) {
            list = new ArrayList<Color[]>();
            numberOfClassesToSchemes.put(colors.length, list);
        }
        list.add(colors);
    }

    static {
        QualitativeColorSchemes.createArray("0x7FC97F", "0xBEAED4", "0xFDC086");
        QualitativeColorSchemes.createArray("0x1B9E77", "0xD95F02", "0x7570B3");
        QualitativeColorSchemes.createArray("0xA6CEE3", "0x1F78B4", "0xB2DF8A");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A");
        QualitativeColorSchemes.createArray("0x66C2A5", "0xFC8D62", "0x8DA0CB");
        QualitativeColorSchemes.createArray("0x8DD3C7", "0xFFFFB3", "0xBEBADA");
        QualitativeColorSchemes.createArray("0x7FC97F", "0xBEAED4", "0xFDC086", "0xFFFF99");
        QualitativeColorSchemes.createArray("0x1B9E77", "0xD95F02", "0x7570B3", "0xE7298A");
        QualitativeColorSchemes.createArray("0xA6CEE3", "0x1F78B4", "0xB2DF8A", "0x33A02C");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A", "0x984EA3");
        QualitativeColorSchemes.createArray("0x66C2A5", "0xFC8D62", "0x8DA0CB", "0xE78AC3");
        QualitativeColorSchemes.createArray("0x8DD3C7", "0xFFFFB3", "0xBEBADA", "0xFB8072");
        QualitativeColorSchemes.createArray("0x1B9E77", "0xD95F02", "0x7570B3", "0xE7298A", "0x66A61E");
        QualitativeColorSchemes.createArray("0xA6CEE3", "0x1F78B4", "0xB2DF8A", "0x33A02C", "0xFB9A99");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A", "0x984EA3", "0xFF7F00");
        QualitativeColorSchemes.createArray("0x66C2A5", "0xFC8D62", "0x8DA0CB", "0xE78AC3", "0xA6D854");
        QualitativeColorSchemes.createArray("0x8DD3C7", "0xFFFFB3", "0xBEBADA", "0xFB8072", "0x80B1D3");
        QualitativeColorSchemes.createArray("0x1B9E77", "0xD95F02", "0x7570B3", "0xE7298A", "0x66A61E", "0xE6AB02");
        QualitativeColorSchemes.createArray("0xA6CEE3", "0x1F78B4", "0xB2DF8A", "0x33A02C", "0xFB9A99", "0xE31A1C");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A", "0x984EA3", "0xFF7F00", "0xFFFF33");
        QualitativeColorSchemes.createArray("0x8DD3C7", "0xFFFFB3", "0xBEBADA", "0xFB8072", "0x80B1D3", "0xFDB462");
        QualitativeColorSchemes.createArray("0x1B9E77", "0xD95F02", "0x7570B3", "0xE7298A", "0x66A61E", "0xE6AB02", "0xA6761D");
        QualitativeColorSchemes.createArray("0xA6CEE3", "0x1F78B4", "0xB2DF8A", "0x33A02C", "0xFB9A99", "0xE31A1C", "0xFDBF6F");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A", "0x984EA3", "0xFF7F00", "0xFFFF33", "0xA65628");
        QualitativeColorSchemes.createArray("0x8DD3C7", "0xFFFFB3", "0xBEBADA", "0xFB8072", "0x80B1D3", "0xFDB462", "0xB3DE69");
        QualitativeColorSchemes.createArray("0x1B9E77", "0xD95F02", "0x7570B3", "0xE7298A", "0x66A61E", "0xE6AB02", "0xA6761D", "0x666666");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A", "0x984EA3", "0xFF7F00", "0xFFFF33", "0xA65628", "0xF781BF");
        QualitativeColorSchemes.createArray("0x8DD3C7", "0xFFFFB3", "0xBEBADA", "0xFB8072", "0x80B1D3", "0xFDB462", "0xB3DE69", "0xFCCDE5");
        QualitativeColorSchemes.createArray("0xE41A1C", "0x377EB8", "0x4DAF4A", "0x984EA3", "0xFF7F00", "0xFFFF33", "0xA65628", "0xF781BF", "0x999999");
    }
}

