/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import com.jidesoft.swing.JideLabel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;
import org.broadinstitute.genee.io.util.Formatter;

public class Axis
extends JPanel
implements Drawable {
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, (NumberFormat)new DecimalFormat("0"));
    private static final List<NumberTickUnit> INTEGER_TICK_UNITS = new ArrayList<NumberTickUnit>();
    private static final List<NumberTickUnit> STANDARD_TICK_UNITS = new ArrayList<NumberTickUnit>();
    private static final int TICK_MARK_SIZE = 4;
    private boolean autoSelectTicks = true;
    private CoordinateMapper coordinateMapper;
    private boolean horizontal;
    private JideLabel label = new JideLabel();
    private LabelDrawer labelDrawer;
    private String[] labels = new String[0];
    private float max;
    private float min;
    private boolean showDropIndicator;
    private NumberTickUnit tickUnit = DEFAULT_TICK_UNIT;
    private List<NumberTickUnit> tickUnits = STANDARD_TICK_UNITS;
    private float[] values = new float[0];

    public Axis(boolean horizontal, CoordinateMapper chartCoordinateMapper) {
        this(horizontal, chartCoordinateMapper, false);
    }

    public Axis(boolean horizontal, CoordinateMapper chartCoordinateMapper, boolean autoupdateLabels) {
        this.horizontal = horizontal;
        this.setMinimumSize(new Dimension());
        this.setFont(new Font(UIUtil.getFontName(), 0, UIUtil.DEFAULT_FONT_SIZE));
        this.coordinateMapper = chartCoordinateMapper;
        this.label.setVisible(true);
        this.label.setDoubleBuffered(false);
        DrawableWrapper.setPropsToPrint((Component)this.label, this.label.getPreferredSize());
        this.labelDrawer = !horizontal ? new YAxisLayout() : new XAxisLayout();
        this.labelDrawer.configure(this.label);
        if (autoupdateLabels) {
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    Axis.this.refresh();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    Axis.this.refresh();
                }
            });
            this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

                @Override
                public void ancestorMoved(HierarchyEvent e) {
                }

                @Override
                public void ancestorResized(HierarchyEvent e) {
                    Axis.this.refresh();
                }
            });
        }
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        this.labelDrawer.draw((Graphics2D)g);
    }

    public NumberTickUnit getCeilingTickUnit(double unit, List<NumberTickUnit> tickUnits) {
        int index = Collections.binarySearch(tickUnits, new NumberTickUnit(unit));
        if (index >= 0) {
            return tickUnits.get(index);
        }
        if ((index = -(index + 1)) < 0) {
            index = 0;
        } else if (index >= tickUnits.size()) {
            index = tickUnits.size() - 1;
        }
        return tickUnits.get(index);
    }

    @Override
    public Dimension getDrawableSize() {
        return this.getPreferredSize();
    }

    public NumberTickUnit getLargerTickUnit(float unit, List<NumberTickUnit> tickUnits) {
        int index = Collections.binarySearch(tickUnits, new NumberTickUnit(unit));
        index = index >= 0 ? ++index : -index - 1;
        if (index < 0) {
            index = 0;
        } else if (index >= tickUnits.size()) {
            index = tickUnits.size() - 1;
        }
        return tickUnits.get(index);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.labelDrawer.getPreferredSize();
    }

    public void refresh() {
        this.computeTickLabels();
    }

    public void setHorizontalLabelsRotated(boolean horizontalLabelsRotated) {
        this.labelDrawer = horizontalLabelsRotated ? new RotatedXAxisLayout() : new XAxisLayout();
        this.labelDrawer.configure(this.label);
    }

    public void setIntegerTicks(boolean integerTicks) {
        this.tickUnits = integerTicks ? INTEGER_TICK_UNITS : STANDARD_TICK_UNITS;
    }

    public void setShowDropIndicator(boolean showDropIndicator) {
        if (this.showDropIndicator != showDropIndicator) {
            this.showDropIndicator = showDropIndicator;
            this.repaint();
        }
    }

    public void setTickLabels(String[] labels, float[] values) {
        if (labels != null) {
            this.labels = labels;
            this.values = values;
        } else {
            this.labels = null;
            this.values = null;
        }
        this.autoSelectTicks = labels == null;
    }

    protected float calculateLowestVisibleTickValue(NumberTickUnit unit, float min) {
        float index = (float)Math.ceil(min / unit.size);
        return index * unit.size;
    }

    protected int calculateVisibleTickCount(NumberTickUnit unit, float min, float max) {
        return (int)(Math.floor(max / unit.size) - Math.ceil(min / unit.size) + 1.0);
    }

    protected float estimateMaximumTickLabelHeight(FontMetrics fm) {
        return fm.getHeight() + fm.getDescent();
    }

    protected double estimateMaximumTickLabelWidth(FontMetrics fm, float min, float max) {
        String lowerStr = Formatter.format(min);
        String upperStr = Formatter.format(max);
        String first = Formatter.format((max - min) / 4.0f);
        String last = Formatter.format(3.0f * (max - min) / 4.0f);
        double w1 = fm.stringWidth(lowerStr);
        double w2 = fm.stringWidth(upperStr);
        double w3 = fm.stringWidth(first);
        double w4 = fm.stringWidth(last);
        return Math.max(w4, Math.max(w3, Math.max(w1, w2))) + 1.0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(UIUtil.RENDERING_HINTS);
        this.labelDrawer.draw(g2);
        if (this.showDropIndicator) {
            Composite oldComposite = g2.getComposite();
            g2.setColor(UIUtil.DRAG_OVER_COLOR);
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            if (this.horizontal) {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g2.setComposite(oldComposite);
        }
    }

    private void computeTickLabels() {
        float pixPerUnit;
        float availablePixels;
        if (!this.horizontal) {
            this.min = this.coordinateMapper.getYMin();
            this.max = this.coordinateMapper.getYMax();
            availablePixels = this.coordinateMapper.getHeight();
            pixPerUnit = this.coordinateMapper.getYPixPerUnit();
        } else {
            this.min = this.coordinateMapper.getXMin();
            this.max = this.coordinateMapper.getXMax();
            availablePixels = this.coordinateMapper.getWidth();
            pixPerUnit = this.coordinateMapper.getXPixPerUnit();
        }
        if (availablePixels < 50.0f) {
            this.label.setFont(UIManager.getFont("Label.font").deriveFont(7.0f));
        } else if (availablePixels < 100.0f) {
            this.label.setFont(UIManager.getFont("Label.font").deriveFont(9.0f));
        } else {
            this.label.setFont(UIManager.getFont("Label.font"));
        }
        FontMetrics fm = this.label.getFontMetrics(this.label.getFont());
        if (this.autoSelectTicks) {
            if (this.horizontal && !(this.labelDrawer instanceof RotatedXAxisLayout)) {
                this.selectHorizontalAutoTickUnit(fm, availablePixels, pixPerUnit);
            } else {
                this.selectVerticalAutoTickUnit(fm, pixPerUnit);
            }
        } else if (this.labelDrawer instanceof RotatedXAxisLayout && (float)(this.label.getPreferredSize().width - 1) >= pixPerUnit) {
            this.label.setFont(UIManager.getFont("Label.font").deriveFont(9.0f));
        }
    }

    private int getHeight(String text) {
        this.label.setText(text);
        return this.label.getPreferredSize().height;
    }

    private int getWidth(String text) {
        this.label.setText(text);
        return this.label.getPreferredSize().width;
    }

    private void refreshTicksHorizontal() {
        NumberTickUnit tu = this.tickUnit;
        int count = this.calculateVisibleTickCount(this.tickUnit, this.min, this.max);
        float lowestTickValue = this.calculateLowestVisibleTickValue(this.tickUnit, this.min);
        count = Math.max(count, 0);
        count = Math.min(count, 100);
        this.labels = new String[count];
        this.values = new float[count];
        for (int i = 0; i < count; ++i) {
            float currentTickValue;
            this.values[i] = currentTickValue = lowestTickValue + (float)i * tu.size;
            this.labels[i] = tu.nf.format(currentTickValue);
        }
    }

    private void refreshTicksVertical() {
        NumberTickUnit tu = this.tickUnit;
        int count = this.calculateVisibleTickCount(this.tickUnit, this.min, this.max);
        float lowestTickValue = this.calculateLowestVisibleTickValue(this.tickUnit, this.min);
        count = Math.max(count, 0);
        count = Math.min(count, 100);
        this.labels = new String[count];
        this.values = new float[count];
        for (int i = 0; i < count; ++i) {
            float currentTickValue;
            this.values[i] = currentTickValue = lowestTickValue + (float)i * tu.size;
            this.labels[i] = tu.nf.format(currentTickValue);
        }
    }

    private void selectHorizontalAutoTickUnit(FontMetrics fm, float availablePixels, float pixPerUnit) {
        float stringWidth;
        List<NumberTickUnit> tickUnits = this.tickUnits;
        NumberTickUnit unit1 = this.getCeilingTickUnit(pixPerUnit, tickUnits);
        float unit1Width = pixPerUnit * unit1.size;
        double tickLabelWidth = this.estimateMaximumTickLabelWidth(fm, this.min, this.max);
        double guess = tickLabelWidth / (double)unit1Width * (double)unit1.size;
        NumberTickUnit unit2 = this.getCeilingTickUnit(guess, tickUnits);
        int count = this.calculateVisibleTickCount(unit2, this.min, this.max);
        float fractionFilled = (float)count * (stringWidth = (float)fm.stringWidth(unit2.nf.format(unit2.size))) / availablePixels;
        if ((double)fractionFilled >= 0.85 && (double)((float)(count = this.calculateVisibleTickCount(unit2 = this.getLargerTickUnit(unit2.size, tickUnits), this.min, this.max)) * (stringWidth = (float)fm.stringWidth(unit2.nf.format(unit2.size))) / availablePixels) >= 0.85) {
            unit2 = this.getLargerTickUnit(unit2.size, tickUnits);
        }
        this.tickUnit = unit2;
        this.refreshTicksHorizontal();
    }

    private void selectVerticalAutoTickUnit(FontMetrics fm, float pixPerUnit) {
        List<NumberTickUnit> tickUnits;
        NumberTickUnit unit1;
        float unitHeight;
        float guess;
        NumberTickUnit unit2;
        float unit2Height;
        float tickLabelHeight = this.estimateMaximumTickLabelHeight(fm);
        if (tickLabelHeight > (unit2Height = Math.abs(pixPerUnit * (unit2 = this.getCeilingTickUnit(guess = tickLabelHeight / (unitHeight = Math.abs(pixPerUnit * (unit1 = this.getCeilingTickUnit(pixPerUnit, tickUnits = this.tickUnits)).size)) * unit1.size, tickUnits)).size))) {
            unit2 = this.getLargerTickUnit(unit2.size, tickUnits);
        }
        this.tickUnit = unit2;
        this.refreshTicksVertical();
    }

    public static float getFont(int width, int defaultFontSize) {
        if (width < 50) {
            return 7.0f;
        }
        if (width < 100) {
            return 9.0f;
        }
        return defaultFontSize;
    }

    static {
        DecimalFormat df000 = new DecimalFormat("0.0000000000");
        DecimalFormat df00 = new DecimalFormat("0.000000000");
        DecimalFormat df0 = new DecimalFormat("0.00000000");
        DecimalFormat df1 = new DecimalFormat("0.0000000");
        DecimalFormat df2 = new DecimalFormat("0.000000");
        DecimalFormat df3 = new DecimalFormat("0.00000");
        DecimalFormat df4 = new DecimalFormat("0.0000");
        DecimalFormat df5 = new DecimalFormat("0.000");
        DecimalFormat df6 = new DecimalFormat("0.00");
        DecimalFormat df7 = new DecimalFormat("0.0");
        DecimalFormat df8 = new DecimalFormat("#,##0");
        DecimalFormat df9 = new DecimalFormat("#,###,##0");
        DecimalFormat df10 = new DecimalFormat("#,###,###,##0");
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E-9, df00, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E-8, df0, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E-7, df1, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E-6, df2, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E-5, df3, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E-4, df4, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.001, df5, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.01, df6, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.1, df7, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0, df8, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(10.0, df8, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(100.0, df8, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1000.0, df8, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(10000.0, df8, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(100000.0, df8, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1000000.0, df9, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E7, df9, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E8, df9, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E9, df10, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E10, df10, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(1.0E11, df10, 2.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E-9, df000, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E-8, df00, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E-7, df0, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E-6, df1, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E-5, df2, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E-4, df3, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.0025, df4, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.025, df5, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.25, df6, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5, df7, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(25.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(250.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2500.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(25000.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(250000.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2500000.0, df9, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E7, df9, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E8, df9, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E9, df10, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E10, df10, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(2.5E11, df10, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E-9, df00, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E-8, df0, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E-7, df1, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E-6, df2, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E-5, df3, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E-4, df4, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.005, df5, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.05, df6, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(0.5, df7, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(50.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(500.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5000.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(50000.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(500000.0, df8, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5000000.0, df9, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E7, df9, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E8, df9, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E9, df10, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E10, df10, 5.0));
        STANDARD_TICK_UNITS.add(new NumberTickUnit(5.0E11, df10, 5.0));
        Collections.sort(STANDARD_TICK_UNITS);
        DecimalFormat df02 = new DecimalFormat("0");
        DecimalFormat df12 = new DecimalFormat("#,##0");
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1.0, df02, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(2.0, df02, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(5.0, df02, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(10.0, df02, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(20.0, df02, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(50.0, df02, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(100.0, df02, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(200.0, df02, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(500.0, df02, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(2000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(5000.0, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(10000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(20000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(50000.0, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(100000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(200000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(500000.0, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1000000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(2000000.0, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(5000000.0, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1.0E7, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(2.0E7, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(5.0E7, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1.0E8, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(2.0E8, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(5.0E8, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1.0E9, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(2.0E9, df12, 2.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(5.0E9, df12, 5.0));
        INTEGER_TICK_UNITS.add(new NumberTickUnit(1.0E10, df12, 2.0));
        Collections.sort(INTEGER_TICK_UNITS);
    }

    private class YAxisLayout
    implements LabelDrawer {
        private YAxisLayout() {
        }

        @Override
        public void configure(JideLabel label) {
            label.setHorizontalTextPosition(2);
        }

        @Override
        public void draw(Graphics2D g2) {
            int width = 0;
            Rectangle clip = g2.getClipBounds();
            if (clip != null) {
                width = clip.width;
            } else {
                Dimension size = this.getPreferredSize();
                width = size.width;
            }
            g2.setColor(Color.BLACK);
            AffineTransform t = g2.getTransform();
            if (Axis.this.labels != null) {
                int length = Axis.this.labels.length;
                for (int i = 0; i < length; ++i) {
                    int ypix = (int)Axis.this.coordinateMapper.yToPix(Axis.this.values[i]);
                    String text = Axis.this.labels[i];
                    Axis.this.label.setText(text);
                    Dimension labelSize = Axis.this.label.getPreferredSize();
                    int labelWidth = Math.min(labelSize.width, width);
                    int labelX = width - labelWidth - 4 - 2;
                    g2.translate(labelX, ypix - labelSize.height / 2);
                    DrawableWrapper.setPropsToPrint((Component)Axis.this.label, new Dimension(labelWidth, labelSize.height));
                    Axis.this.label.print((Graphics)g2);
                    g2.setTransform(t);
                    g2.drawLine(width - 4, ypix, width, ypix);
                }
            }
            g2.setTransform(t);
        }

        @Override
        public Dimension getPreferredSize() {
            int maxLabelWidth = 0;
            if (Axis.this.labels != null) {
                Axis.this.label.setPreferredSize(null);
                int length = Axis.this.labels.length;
                for (int i = 0; i < length; ++i) {
                    Axis.this.label.setText(Axis.this.labels[i]);
                    int labelWidth = ((Axis)Axis.this).label.getPreferredSize().width;
                    if (labelWidth <= maxLabelWidth) continue;
                    maxLabelWidth = labelWidth;
                }
            }
            int width = 2 + maxLabelWidth + 4;
            return new Dimension(width, (int)Math.ceil(Axis.this.coordinateMapper.getHeight()));
        }
    }

    private class XAxisLayout
    implements LabelDrawer {
        private XAxisLayout() {
        }

        @Override
        public void configure(JideLabel label) {
            label.setOrientation(0);
            label.setHorizontalTextPosition(0);
            label.setVerticalTextPosition(3);
        }

        @Override
        public void draw(Graphics2D g2) {
            if (Axis.this.labels != null) {
                AffineTransform t = g2.getTransform();
                int step = 1;
                int length = Axis.this.labels.length;
                for (int i = 0; i < length; i += step) {
                    String text = Axis.this.labels[i];
                    Axis.this.label.setText(text);
                    Dimension preferredSize = Axis.this.label.getPreferredSize();
                    int xpix = (int)Axis.this.coordinateMapper.xToPix(Axis.this.values[i]);
                    g2.setTransform(t);
                    g2.translate(xpix - preferredSize.width / 2, 6);
                    DrawableWrapper.setPropsToPrint((Component)Axis.this.label, preferredSize);
                    Axis.this.label.print((Graphics)g2);
                    g2.translate(0, -6);
                    g2.drawLine(preferredSize.width / 2, 0, preferredSize.width / 2, 4);
                }
                g2.setTransform(t);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)Math.ceil(Axis.this.coordinateMapper.getWidth()), new JideLabel((String)" ").getPreferredSize().height + 4 + 4);
        }
    }

    private static class TickMarkIcon
    implements Icon {
        private TickMarkIcon() {
        }

        @Override
        public int getIconHeight() {
            return 4;
        }

        @Override
        public int getIconWidth() {
            return 1;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.BLACK);
            g.drawLine(0, 0, 4, 0);
        }
    }

    private class RotatedXAxisLayout
    implements LabelDrawer {
        private RotatedXAxisLayout() {
        }

        @Override
        public void configure(JideLabel label) {
            label.setOrientation(1);
            label.setClockwise(false);
            label.setHorizontalTextPosition(4);
            label.setVerticalTextPosition(0);
        }

        @Override
        public void draw(Graphics2D g2) {
            int clipHeight;
            Rectangle clip = g2.getClipBounds();
            int n = clipHeight = clip == null ? -1 : clip.height;
            if (Axis.this.labels != null) {
                int step = 1;
                if (!Axis.this.autoSelectTicks && Axis.this.values.length >= 2) {
                    float preferredWidth = ((Axis)Axis.this).label.getPreferredSize().width + 1;
                    float xpix0 = Axis.this.coordinateMapper.xToPix(Axis.this.values[0]);
                    float xpix1 = Axis.this.coordinateMapper.xToPix(Axis.this.values[1]);
                    float diff = Math.abs(xpix1 - xpix0);
                    if (preferredWidth >= diff && (step = (int)Math.abs(Math.ceil(preferredWidth / diff))) < 1) {
                        step = 1;
                    }
                }
                AffineTransform transform = g2.getTransform();
                int start = 0;
                Line2D.Float line = new Line2D.Float();
                int length = Axis.this.labels.length;
                for (int i = start; i < length; i += step) {
                    String text = Axis.this.labels[i];
                    Axis.this.label.setText(text);
                    Dimension labelSize = Axis.this.label.getPreferredSize();
                    int xpix = (int)Axis.this.coordinateMapper.xToPix(Axis.this.values[i]);
                    int labelHeight = labelSize.height;
                    if (clipHeight != -1) {
                        labelHeight = Math.min(labelHeight, clipHeight);
                    }
                    g2.setTransform(transform);
                    g2.translate(xpix - labelSize.width / 2, 6);
                    DrawableWrapper.setPropsToPrint((Component)Axis.this.label, new Dimension(labelSize.width, labelHeight));
                    Axis.this.label.print((Graphics)g2);
                    g2.setTransform(transform);
                    line.setLine(xpix, 0.0f, xpix, 4.0f);
                    g2.draw(line);
                }
                g2.setTransform(transform);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int h = 0;
            if (Axis.this.labels != null) {
                int length = Axis.this.labels.length;
                for (int i = 0; i < length; ++i) {
                    h = Math.max(h, Axis.this.getHeight(Axis.this.labels[i]));
                }
            }
            return new Dimension((int)Math.ceil(Axis.this.coordinateMapper.getWidth()), 5 + h + 4);
        }
    }

    private static class NumberTickUnit
    implements Comparable<NumberTickUnit> {
        private NumberFormat nf;
        private float size;

        public NumberTickUnit(double size) {
            this.size = (float)size;
        }

        private NumberTickUnit(double size, NumberFormat nf) {
            this.size = (float)size;
            this.nf = nf;
        }

        private NumberTickUnit(double size, NumberFormat nf, double t) {
            this.size = (float)size;
            this.nf = nf;
        }

        @Override
        public int compareTo(NumberTickUnit o) {
            return Float.compare(this.size, o.size);
        }

        public boolean equals(Object obj) {
            return Float.valueOf(this.size).equals(Float.valueOf(((NumberTickUnit)obj).size));
        }

        public int hashCode() {
            return Float.valueOf(this.size).hashCode();
        }

        public String toString() {
            return this.nf.format(this.size);
        }
    }

    private static interface LabelDrawer {
        public void configure(JideLabel var1);

        public void draw(Graphics2D var1);

        public Dimension getPreferredSize();
    }
}

