/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.broadinstitute.genee.chart.AbstractChartRenderer;
import org.broadinstitute.genee.chart.GENEEChart;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.grid.ChartUtil;
import org.broadinstitute.genee.heatmap.CoordinateMapper;

public class BarRenderer
extends AbstractChartRenderer {
    private boolean horizontal;
    private boolean rangeChart;
    private boolean sumValues;

    public BarRenderer(boolean sumValues) {
        this.sumValues = sumValues;
    }

    @Override
    public int getItemIndex(GENEEChart chart, CoordinateMapper chartCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, int xpix, int ypix) {
        return ChartUtil.findSortedBarItemIndex(this.chartPropertiesSupplier, chartCoordinateMapper, chartDataset, datasetIndex, seriesIndex, xpix, ypix);
    }

    @Override
    public void paint(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        if (!this.horizontal) {
            this.paintVertical(chartDataset, datasetIndex, g2, worldCoordinateMapper);
        } else {
            int nseries = chartDataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                this.paintNoStackHorizontalBars(g2, worldCoordinateMapper, chartDataset, datasetIndex, seriesIndex, this.rangeChart);
            }
        }
    }

    public void setHorizontal(boolean b) {
        this.horizontal = b;
    }

    protected void paintVertical(XYChartDataset chartDataset, int datasetIndex, Graphics2D g2, CoordinateMapper worldCoordinateMapper) {
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float ymin = chartDataset.getYMin();
        if (ymin < 0.0f) {
            ymin = 0.0f;
        }
        float yminPix = worldCoordinateMapper.yToPix(ymin);
        int itemCount = chartDataset.getItemCount(0);
        float[] values = new float[chartDataset.getSeriesCount()];
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            int[] seriesPaintOrder = ChartUtil.getSeriesPaintOrder(chartDataset, itemIndex, values, true);
            float itemSum = 0.0f;
            float previousYPix = yminPix;
            int nseries = chartDataset.getSeriesCount();
            for (int seriesIndex = 0; seriesIndex < nseries; ++seriesIndex) {
                float barWidth;
                float value = chartDataset.getY(seriesPaintOrder[seriesIndex], itemIndex);
                if (Float.isNaN(value)) continue;
                float y = value;
                if (this.sumValues) {
                    y = itemSum += value;
                }
                float xpix = worldCoordinateMapper.xToPix(chartDataset.getX(seriesIndex, itemIndex));
                if (this.sumValues) {
                    float xpix0 = worldCoordinateMapper.xToPix(chartDataset.getXStart(seriesIndex, itemIndex));
                    float xpix1 = worldCoordinateMapper.xToPix(chartDataset.getXEnd(seriesIndex, itemIndex));
                    barWidth = xpix1 - xpix0;
                } else {
                    barWidth = this.chartPropertiesSupplier.getBarSize(chartDataset, datasetIndex, seriesIndex, itemIndex);
                }
                float ypixBarTop = worldCoordinateMapper.yToPix(y);
                g2.setColor(this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesPaintOrder[seriesIndex], itemIndex));
                float height = Math.abs(previousYPix - ypixBarTop);
                float rectY = previousYPix >= ypixBarTop ? ypixBarTop : previousYPix;
                rect.setRect(xpix - barWidth / 2.0f, rectY, barWidth, height);
                g2.fill(rect);
                previousYPix = ypixBarTop;
            }
        }
    }

    private void paintNoStackHorizontalBars(Graphics2D g2, CoordinateMapper worldCoordinateMapper, XYChartDataset chartDataset, int datasetIndex, int seriesIndex, boolean isRangeChart) {
        Rectangle2D.Float rect = new Rectangle2D.Float();
        if (chartDataset.getSeriesCount() == 0) {
            return;
        }
        float xpixStart = 0.0f;
        if (!isRangeChart) {
            float x0 = chartDataset.getXMin();
            if (x0 < 0.0f) {
                x0 = 0.0f;
            }
            xpixStart = worldCoordinateMapper.xToPix(x0);
        } else {
            g2.setColor(Color.LIGHT_GRAY);
            float xminPix = worldCoordinateMapper.xToPix(chartDataset.getXMin());
            float ytop = worldCoordinateMapper.yToPix(chartDataset.getYMin());
            float ybottom = worldCoordinateMapper.yToPix(chartDataset.getYMax());
            Line2D.Float line = new Line2D.Float(xminPix, ytop, xminPix, ybottom);
            g2.draw(line);
            float xmaxPix = worldCoordinateMapper.xToPix(chartDataset.getXMax());
            line.setLine(xmaxPix, ytop, xmaxPix, ybottom);
            g2.draw(line);
        }
        int nitems = chartDataset.getItemCount(seriesIndex);
        for (int itemIndex = 0; itemIndex < nitems; ++itemIndex) {
            float length;
            float end = chartDataset.getXEnd(seriesIndex, itemIndex);
            if (Float.isNaN(end)) continue;
            float xpixEnd = worldCoordinateMapper.xToPix(end);
            float barWidth = this.chartPropertiesSupplier.getBarSize(chartDataset, datasetIndex, seriesIndex, itemIndex);
            g2.setColor(this.chartPropertiesSupplier.getItemColor(chartDataset, datasetIndex, seriesIndex, itemIndex));
            if (isRangeChart) {
                xpixStart = worldCoordinateMapper.xToPix(chartDataset.getXStart(seriesIndex, itemIndex));
            }
            if (xpixEnd < xpixStart) {
                length = xpixStart - xpixEnd;
                rect.setRect(xpixEnd, worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex)) - barWidth / 2.0f, length, barWidth);
            } else {
                length = xpixEnd - xpixStart;
                rect.setRect(xpixStart, worldCoordinateMapper.yToPix(chartDataset.getY(seriesIndex, itemIndex)) - barWidth / 2.0f, length, barWidth);
            }
            g2.fill(rect);
        }
    }
}

