/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import org.broadinstitute.genee.matrix.FloatList;

public class BoxAndWhiskerItem {
    private float lowerAdjacentValue;
    private FloatList lowerOutliers;
    private float max;
    private float mean;
    private float median;
    private float min;
    private String name;
    private float q1;
    private float q3;
    private float standardDeviation;
    private float upperAdjacentValue;
    private FloatList upperOutliers;

    public BoxAndWhiskerItem(float mean, float median, float standardDeviation, float q1, float q3, float minValue, float maxValue, float lowerAdjacentValue, float upperAdjacentValue, FloatList lowerOutliers, FloatList upperOutliers) {
        this.mean = mean;
        this.median = median;
        this.standardDeviation = standardDeviation;
        this.q1 = q1;
        this.q3 = q3;
        if (mean - standardDeviation < minValue) {
            minValue = mean - standardDeviation;
        }
        if (mean + standardDeviation > maxValue) {
            maxValue = mean + standardDeviation;
        }
        this.min = minValue;
        this.max = maxValue;
        this.lowerAdjacentValue = lowerAdjacentValue;
        this.upperAdjacentValue = upperAdjacentValue;
        this.lowerOutliers = lowerOutliers;
        this.upperOutliers = upperOutliers;
    }

    public float getLowerAdjacentValue() {
        return this.lowerAdjacentValue;
    }

    public FloatList getLowerOutliers() {
        return this.lowerOutliers;
    }

    public float getMax() {
        return this.max;
    }

    public float getMean() {
        return this.mean;
    }

    public float getMedian() {
        return this.median;
    }

    public float getMin() {
        return this.min;
    }

    public String getName() {
        return this.name;
    }

    public float getQ1() {
        return this.q1;
    }

    public float getQ3() {
        return this.q3;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public float getUpperAdjacentValue() {
        return this.upperAdjacentValue;
    }

    public FloatList getUpperOutliers() {
        return this.upperOutliers;
    }

    public void setName(String name) {
        this.name = name;
    }
}

