/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.chart;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.genee.chart.BoxPlotChartDataset;
import org.broadinstitute.genee.chart.DefaultBoxPlotChartSeries;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.chart.DefaultXYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.InterpolatedBoxPlotChartDataset;
import org.broadinstitute.genee.chart.XYChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDataset;
import org.broadinstitute.genee.chart.XYInterpolatedChartDatasetSupplier;
import org.broadinstitute.genee.matrix.FloatList;

public class DefaultBoxPlotChartDataset
implements BoxPlotChartDataset,
XYInterpolatedChartDatasetSupplier {
    private List<DefaultBoxPlotChartSeries> seriesList = new ArrayList<DefaultBoxPlotChartSeries>();

    public void addSeries(DefaultBoxPlotChartSeries series) {
        this.seriesList.add(series);
    }

    @Override
    public XYInterpolatedChartDataset createXYInterpolatedChartDataset(XYChartDataset dest) {
        return dest instanceof BoxPlotChartDataset ? new InterpolatedBoxPlotChartDataset() : new DefaultXYInterpolatedChartDataset();
    }

    @Override
    public int getItemCount(int series) {
        return this.seriesList.get(series).getItemCount();
    }

    public int getItemCount(int series, int index) {
        return this.seriesList.get(series).getItemCount();
    }

    @Override
    public String getItemName(int series, int index) {
        return this.seriesList.get(series).getItemName(index);
    }

    @Override
    public float getLowerAdjacentValue(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getLowerAdjacentValue();
    }

    @Override
    public FloatList getLowerOutliers(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getLowerOutliers();
    }

    @Override
    public float getMax(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getMax();
    }

    @Override
    public float getMean(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getMean();
    }

    @Override
    public float getMedian(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getMedian();
    }

    @Override
    public float getMin(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getMin();
    }

    public String getName(int series, int index) {
        return this.seriesList.get(series).getName();
    }

    @Override
    public float getQ1(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getQ1();
    }

    @Override
    public float getQ3(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getQ3();
    }

    public DefaultBoxPlotChartSeries getSeries(int series) {
        return this.seriesList.get(series);
    }

    @Override
    public int getSeriesCount() {
        return this.seriesList.size();
    }

    @Override
    public String getSeriesName(int series) {
        return this.seriesList.get(series).getName();
    }

    @Override
    public float getStandardDeviation(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getStandardDeviation();
    }

    @Override
    public float getUpperAdjacentValue(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getUpperAdjacentValue();
    }

    @Override
    public FloatList getUpperOutliers(int series, int index) {
        return this.seriesList.get(series).getBoxAndWhiskerItem(index).getUpperOutliers();
    }

    @Override
    public float getX(int series, int index) {
        return this.seriesList.get(series).getX(index);
    }

    @Override
    public float getXEnd(int series, int index) {
        return this.seriesList.get(series).getXEnd(index);
    }

    @Override
    public float getXMax() {
        return DefaultXYChartDataset.getXMax(this.seriesList);
    }

    @Override
    public float getXMax(int series) {
        return this.seriesList.get(series).getXMax();
    }

    @Override
    public float getXMin() {
        return DefaultXYChartDataset.getXMin(this.seriesList);
    }

    @Override
    public float getXMin(int series) {
        return this.seriesList.get(series).getXMin();
    }

    @Override
    public float getXStart(int series, int index) {
        return this.seriesList.get(series).getXStart(index);
    }

    @Override
    public float getY(int series, int index) {
        return this.seriesList.get(series).getY(index);
    }

    @Override
    public float getYEnd(int series, int index) {
        return this.seriesList.get(series).getYEnd(index);
    }

    @Override
    public float getYMax() {
        return DefaultXYChartDataset.getYMax(this.seriesList);
    }

    @Override
    public float getYMax(int series) {
        return this.seriesList.get(series).getYMax();
    }

    @Override
    public float getYMin() {
        return DefaultXYChartDataset.getYMin(this.seriesList);
    }

    @Override
    public float getYMin(int series) {
        return this.seriesList.get(series).getYMin();
    }

    @Override
    public float getYStart(int series, int index) {
        return this.seriesList.get(series).getYStart(index);
    }
}

